/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.storage.BlockSkyChest;
import appeng.client.render.BaseBlockRender;
import appeng.tile.storage.TileSkyChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderBlockSkyChest
extends BaseBlockRender<BlockSkyChest, TileSkyChest> {
    private static final ResourceLocation SKY_STONE_CHEST = new ResourceLocation("appliedenergistics2", "textures/models/skychest.png");
    private static final ResourceLocation SKY_BLOCK_CHEST = new ResourceLocation("appliedenergistics2", "textures/models/skyblockchest.png");
    private static final ResourceLocation[] METADATA_TO_TEXTURE = new ResourceLocation[]{SKY_STONE_CHEST, SKY_BLOCK_CHEST};
    private final ModelChest model = new ModelChest();

    public RenderBlockSkyChest() {
        super(true, 80.0);
    }

    @Override
    public void renderInventory(BlockSkyChest blk, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int metaData = is.getItemDamage();
        ResourceLocation loc = METADATA_TO_TEXTURE[metaData];
        Minecraft.getMinecraft().getTextureManager().bindTexture(loc);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.0f, (float)-1.0f, (float)-1.0f);
        this.model.chestLid.offsetY = -0.05625f;
        float lidAngle = 0.0f;
        this.model.chestLid.rotateAngleX = -0.0f;
        this.model.renderAll();
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean renderInWorld(BlockSkyChest blk, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        return true;
    }

    @Override
    public void renderTile(BlockSkyChest block, TileSkyChest skyChest, Tessellator tess, double x, double y, double z, float partialTick, RenderBlocks renderer) {
        if (skyChest == null || !skyChest.hasWorldObj()) {
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int metaData = skyChest.getWorldObj().getBlockMetadata(skyChest.xCoord, skyChest.yCoord, skyChest.zCoord);
        ResourceLocation loc = METADATA_TO_TEXTURE[metaData];
        Minecraft.getMinecraft().getTextureManager().bindTexture(loc);
        this.applyTESRRotation(x, y, z, skyChest.getForward(), skyChest.getUp());
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.0f, (float)-1.0f, (float)-1.0f);
        long now = System.currentTimeMillis();
        long distance = now - skyChest.getLastEvent();
        if (skyChest.getPlayerOpen() > 0) {
            skyChest.setLidAngle(skyChest.getLidAngle() + (float)distance * 1.0E-4f);
        } else {
            skyChest.setLidAngle(skyChest.getLidAngle() - (float)distance * 1.0E-4f);
        }
        if (skyChest.getLidAngle() > 0.5f) {
            skyChest.setLidAngle(0.5f);
        }
        if (skyChest.getLidAngle() < 0.0f) {
            skyChest.setLidAngle(0.0f);
        }
        float lidAngle = skyChest.getLidAngle();
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.model.chestLid.offsetY = -0.063125f;
        this.model.chestLid.rotateAngleX = -(lidAngle * 3.141593f / 2.0f);
        GL11.glCullFace((int)1028);
        this.model.renderAll();
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

