/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiCraftingStatus
extends GuiCraftingCPU {
    private final ContainerCraftingStatus status = (ContainerCraftingStatus)this.inventorySlots;
    private GuiButton selectCPU;
    private GuiTabButton originalGuiBtn;
    private GuiBridge originalGui;
    private ItemStack myIcon = null;

    public GuiCraftingStatus(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftingStatus(inventoryPlayer, te));
        ItemStack stack;
        Iterator iterator;
        Object target = this.status.getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            iterator = definitions.items().wirelessTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack wirelessTerminalStack;
                this.myIcon = wirelessTerminalStack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (target instanceof PartTerminal) {
            iterator = parts.terminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            iterator = parts.craftingTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
    }

    @Override
    protected void actionPerformed(GuiButton btn) {
        super.actionPerformed(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.selectCPU) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Terminal.Cpu", backwards ? "Prev" : "Next"));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.selectCPU = new GuiButton(0, this.guiLeft + 8, this.guiTop + this.ySize - 25, 150, 20, GuiText.CraftingCPU.getLocal() + ": " + (Object)((Object)GuiText.NoCraftingCPUs));
        this.buttonList.add(this.selectCPU);
        if (this.myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.guiLeft + 213, this.guiTop - 4, this.myIcon, this.myIcon.getDisplayName(), itemRender);
            this.buttonList.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float btn) {
        this.updateCPUButtonText();
        super.drawScreen(mouseX, mouseY, btn);
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.NoCraftingJobs.getLocal();
        if (this.status.selectedCpu >= 0) {
            if (this.status.myName.length() > 0) {
                String name = this.status.myName.substring(0, Math.min(20, this.status.myName.length()));
                btnTextText = GuiText.CPUs.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CPUs.getLocal() + ": #" + this.status.selectedCpu;
            }
        }
        if (this.status.noCPU) {
            btnTextText = GuiText.NoCraftingJobs.getLocal();
        }
        this.selectCPU.displayString = btnTextText;
    }

    @Override
    protected String getGuiDisplayName(String in) {
        return in;
    }
}

