/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseItemBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.WorldRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.features.AEBlockFeatureHandler;
import appeng.core.features.AEFeature;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.IAEFeature;
import appeng.core.features.IFeatureHandler;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.util.LookDirection;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AEBaseBlock
extends Block
implements IAEFeature {
    private final String featureFullName;
    protected final Optional<String> featureSubName;
    protected boolean isOpaque = true;
    protected boolean isFullSize = true;
    protected boolean hasSubtypes = false;
    protected boolean isInventory = false;
    private IFeatureHandler handler;
    @SideOnly(value=Side.CLIENT)
    private BlockRenderInfo renderInfo;

    protected AEBaseBlock(Material mat) {
        this(mat, (Optional<String>)Optional.absent());
        this.setLightOpacity(255);
        this.setLightLevel(0.0f);
        this.setHardness(2.2f);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected AEBaseBlock(Material mat, Optional<String> subName) {
        super(mat);
        if (mat == AEGlassMaterial.INSTANCE || mat == Material.glass) {
            this.setStepSound(Block.soundTypeGlass);
        } else if (mat == Material.rock) {
            this.setStepSound(Block.soundTypeStone);
        } else if (mat == Material.wood) {
            this.setStepSound(Block.soundTypeWood);
        } else {
            this.setStepSound(Block.soundTypeMetal);
        }
        this.featureFullName = new FeatureNameExtractor(this.getClass(), subName).get();
        this.featureSubName = subName;
    }

    public String toString() {
        return this.featureFullName;
    }

    public void registerNoIcons() {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon i = new FlippableIcon(new MissingIcon(this));
        info.updateIcons(i, i, i, i, i, i);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderInfo getRendererInstance() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> renderer = this.getRenderer();
        this.renderInfo = new BlockRenderInfo(renderer);
        return this.renderInfo;
    }

    @SideOnly(value=Side.CLIENT)
    protected BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> getRenderer() {
        return new BaseBlockRender();
    }

    IIcon unmappedGetIcon(IBlockAccess w, int x, int y, int z, int s) {
        return super.getIcon(w, x, y, z, s);
    }

    protected void setFeature(EnumSet<AEFeature> f) {
        AEBlockFeatureHandler featureHandler = new AEBlockFeatureHandler(f, this, this.featureSubName);
        this.setHandler(featureHandler);
    }

    @Override
    public final IFeatureHandler handler() {
        return this.handler;
    }

    protected final void setHandler(IFeatureHandler handler) {
        this.handler = handler;
    }

    @Override
    public void postInit() {
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public boolean renderAsNormalBlock() {
        return this.isFullSize && this.isOpaque;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return WorldRender.INSTANCE.getRenderId();
    }

    public IIcon getIcon(IBlockAccess w, int x, int y, int z, int s) {
        return this.getIcon(this.mapRotation(w, x, y, z, s), w.getBlockMetadata(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int direction, int metadata) {
        return this.getRendererInstance().getTexture(ForgeDirection.getOrientation((int)direction));
    }

    protected ICustomCollision getCustomCollision(World w, int x, int y, int z) {
        if (this instanceof ICustomCollision) {
            return (ICustomCollision)((Object)this);
        }
        return null;
    }

    public void addCollisionBoxesToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null && bb != null) {
            ArrayList<AxisAlignedBB> tmp = new ArrayList<AxisAlignedBB>();
            collisionHandler.addCollidingBlockToList(w, x, y, z, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                b.minX += (double)x;
                b.minY += (double)y;
                b.minZ += (double)z;
                b.maxX += (double)x;
                b.maxY += (double)y;
                b.maxZ += (double)z;
                if (!bb.intersectsWith(b)) continue;
                out.add(b);
            }
        } else {
            super.addCollisionBoxesToList(w, x, y, z, bb, out, e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB getSelectedBoundingBoxFromPool(World w, int x, int y, int z) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, (Entity)Minecraft.getMinecraft().thePlayer, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                for (AxisAlignedBB bb : bbs) {
                    this.setBlockBounds((float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ);
                    MovingObjectPosition r = super.collisionRayTrace(w, x, y, z, ld.getA(), ld.getB());
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    if (r == null) continue;
                    double xLen = ld.getA().xCoord - r.hitVec.xCoord;
                    double yLen = ld.getA().yCoord - r.hitVec.yCoord;
                    double zLen = ld.getA().zCoord - r.hitVec.zCoord;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br.setBounds(br.minX + (double)x, br.minY + (double)y, br.minZ + (double)z, br.maxX + (double)x, br.maxY + (double)y, br.maxZ + (double)z);
                    return br;
                }
            }
            AxisAlignedBB b = AxisAlignedBB.getBoundingBox((double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)0.0);
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, false)) {
                double minX = Math.min(b.minX, bx.minX);
                double minY = Math.min(b.minY, bx.minY);
                double minZ = Math.min(b.minZ, bx.minZ);
                double maxX = Math.max(b.maxX, bx.maxX);
                double maxY = Math.max(b.maxY, bx.maxY);
                double maxZ = Math.max(b.maxZ, bx.maxZ);
                b.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.setBounds(b.minX + (double)x, b.minY + (double)y, b.minZ + (double)z, b.maxX + (double)x, b.maxY + (double)y, b.maxZ + (double)z);
            return b;
        }
        return super.getSelectedBoundingBoxFromPool(w, x, y, z);
    }

    public final boolean isOpaqueCube() {
        return this.isOpaque;
    }

    public MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 a, Vec3 b) {
        ICustomCollision collisionHandler = this.getCustomCollision(w, x, y, z);
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, true);
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            for (AxisAlignedBB bb : bbs) {
                this.setBlockBounds((float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ);
                MovingObjectPosition r = super.collisionRayTrace(w, x, y, z, a, b);
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                double xLen = a.xCoord - r.hitVec.xCoord;
                double yLen = a.yCoord - r.hitVec.yCoord;
                double zLen = a.zCoord - r.hitVec.zCoord;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            if (br != null) {
                return br;
            }
            return null;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.collisionRayTrace(w, x, y, z, a, b);
    }

    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final void getSubBlocks(Item item, CreativeTabs tabs, List itemStacks) {
        this.getCheckedSubBlocks(item, tabs, itemStacks);
    }

    public boolean hasComparatorInputOverride() {
        return this.isInventory;
    }

    public int getComparatorInputOverride(World w, int x, int y, int z, int s) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegistry) {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon topIcon = this.optionalIcon(iconRegistry, this.getTextureName(), null);
        FlippableIcon bottomIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Bottom", topIcon);
        FlippableIcon sideIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Side", topIcon);
        FlippableIcon eastIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "East", sideIcon);
        FlippableIcon westIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "West", sideIcon);
        FlippableIcon southIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Front", sideIcon);
        FlippableIcon northIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Back", sideIcon);
        this.blockIcon = topIcon;
        info.updateIcons(bottomIcon, topIcon, northIcon, southIcon, eastIcon, westIcon);
    }

    public final boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.isFullSize;
    }

    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        if (this instanceof IOrientableBlock) {
            return this.getOrientable(w, x, y, z);
        }
        return null;
    }

    public final boolean rotateBlock(World w, int x, int y, int z, ForgeDirection axis) {
        IOrientable rotatable = this.getOrientable((IBlockAccess)w, x, y, z);
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            ForgeDirection forward = rotatable.getForward();
            ForgeDirection up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, x, y, z, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, x, y, z, axis);
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
    }

    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return true;
    }

    public ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        return new ForgeDirection[0];
    }

    @SideOnly(value=Side.CLIENT)
    private FlippableIcon optionalIcon(IIconRegister ir, String name, IIcon substitute) {
        while (substitute instanceof FlippableIcon) {
            substitute = ((FlippableIcon)substitute).getOriginal();
        }
        if (substitute != null) {
            try {
                ResourceLocation resLoc = new ResourceLocation(name);
                resLoc = new ResourceLocation(resLoc.getResourceDomain(), String.format("%s/%s%s", "textures/blocks", resLoc.getResourcePath(), ".png"));
                IResource res = Minecraft.getMinecraft().getResourceManager().getResource(resLoc);
                if (res != null) {
                    return new FlippableIcon(ir.registerIcon(name));
                }
            }
            catch (Throwable e) {
                return new FlippableIcon(substitute);
            }
        }
        return new FlippableIcon(ir.registerIcon(name));
    }

    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getSubBlocks(item, tabs, itemStacks);
    }

    private int mapRotation(IBlockAccess w, int x, int y, int z, int s) {
        IOrientable ori = this.getOrientable(w, x, y, z);
        if (ori != null && ori.canBeRotated()) {
            return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
        }
        return s;
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        ForgeDirection west = ForgeDirection.UNKNOWN;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir == forward) {
            return ForgeDirection.SOUTH;
        }
        if (dir == forward.getOpposite()) {
            return ForgeDirection.NORTH;
        }
        if (dir == up) {
            return ForgeDirection.UP;
        }
        if (dir == up.getOpposite()) {
            return ForgeDirection.DOWN;
        }
        if (dir == west) {
            return ForgeDirection.WEST;
        }
        if (dir == west.getOpposite()) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderStateByMeta(int itemDamage) {
    }

    public String getUnlocalizedName(ItemStack is) {
        return this.getUnlocalizedName();
    }

    void addInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
    }

    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlock.class;
    }

    public boolean hasSubtypes() {
        return this.hasSubtypes;
    }
}

