/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui.helper;

import eu.usrv.yamcore.client.dynamicgui.helper.IQuadDrawer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class ColoredQuadDrawer
implements IQuadDrawer {
    private final Tessellator tessellator = Tessellator.instance;
    private int color0;
    private int color1;
    private int color2;
    private int color3;
    public int width;
    public int height;
    private float zLevel = 0.0f;

    public ColoredQuadDrawer(int color) {
        this(color, 0, 0);
    }

    public ColoredQuadDrawer(int color, int width, int height) {
        this(color, color, color, color, width, height);
    }

    public ColoredQuadDrawer(int color0, int color1, int color2, int color3, int width, int height) {
        this.width = width;
        this.height = height;
        this.color0 = color0;
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
    }

    @Override
    public void draw(int x, int y) {
        this.draw(x, y, this.width, this.height);
    }

    @Override
    public void draw(int x, int y, int drawWidth, int drawHeight) {
        this.tessellator.startDrawingQuads();
        this.tessellator.setColorOpaque_I(this.color0);
        this.tessellator.addVertex((double)x, (double)(y + drawHeight), (double)this.zLevel);
        this.tessellator.setColorOpaque_I(this.color1);
        this.tessellator.addVertex((double)(x + drawWidth), (double)(y + drawHeight), (double)this.zLevel);
        this.tessellator.setColorOpaque_I(this.color2);
        this.tessellator.addVertex((double)(x + drawWidth), (double)y, (double)this.zLevel);
        this.tessellator.setColorOpaque_I(this.color3);
        this.tessellator.addVertex((double)x, (double)y, (double)this.zLevel);
        this.tessellator.draw();
    }

    @Override
    public void draw(int x, int y, int drawWidth, int drawHeight, float rotation) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.draw(x, y, drawWidth, drawHeight);
        GL11.glPopMatrix();
    }

    @Override
    public float getZLayer() {
        return this.zLevel;
    }

    @Override
    public ColoredQuadDrawer setWH(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public IQuadDrawer setZLayer(float z) {
        this.zLevel = z;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

