/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui;

import eu.usrv.yamcore.client.dynamicgui.backgrounds.GUIBackgroundProvider;
import eu.usrv.yamcore.client.dynamicgui.backgrounds.SimpleRectangleBackground;
import eu.usrv.yamcore.client.dynamicgui.elements.IGuiElement;
import eu.usrv.yamcore.client.dynamicgui.elements.SimpleDrawingElement;
import eu.usrv.yamcore.client.dynamicgui.skins.BackgroundSkin;
import eu.usrv.yamcore.client.dynamicgui.widgets.IWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public abstract class DynGUIScreen
extends GuiScreen {
    final BackgroundSkin skin;
    protected EntityPlayer player;
    protected int guiWidth;
    protected int guiHeight;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    protected List<IGuiElement> elements;
    private GUIBackgroundProvider background;
    private boolean center = true;

    public DynGUIScreen(EntityPlayer player, int x, int y) {
        this(player);
        this.center = false;
        this.guiLeft = x;
        this.guiTop = y;
    }

    public DynGUIScreen(EntityPlayer player, BackgroundSkin skin, int x, int y) {
        this(player, skin);
        this.center = false;
        this.guiLeft = x;
        this.guiTop = y;
    }

    public DynGUIScreen(EntityPlayer player) {
        this(player, BackgroundSkin.defualt);
    }

    public DynGUIScreen(EntityPlayer player, BackgroundSkin skin) {
        this.player = player;
        this.skin = skin;
    }

    public void initGui() {
        this.elements = new ArrayList<IGuiElement>();
        this.addInitialElements(this.elements);
        int newWidth = 0;
        int newHeight = 0;
        for (IGuiElement element2 : this.elements) {
            if (element2.getElementX() + element2.getElementWidth() + 7 > newWidth) {
                newWidth = element2.getElementX() + element2.getElementWidth() + 7;
            }
            if (element2.getElementY() + element2.getElementHeight() + 7 <= newHeight) continue;
            newHeight = element2.getElementY() + element2.getElementHeight() + 7;
        }
        this.xSize = this.guiWidth = newWidth;
        this.ySize = this.guiHeight = newHeight;
        if (this.center) {
            this.guiLeft = this.width / 2 - this.xSize / 2;
            this.guiTop = this.height / 2 - this.ySize / 2;
        }
        this.elements.stream().filter(element -> element instanceof SimpleDrawingElement).forEach(element -> ((SimpleDrawingElement)element).setXY(this.guiLeft + element.getElementX(), this.guiTop + element.getElementY()));
        this.background = this.getBackgroundProvider();
    }

    protected abstract void addInitialElements(List<IGuiElement> var1);

    protected GUIBackgroundProvider getBackgroundProvider() {
        return new SimpleRectangleBackground(this.skin, this.guiWidth, this.guiHeight);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiBackgroundLayer(mouseX, mouseY);
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.drawGuiForegroundLayer(mouseX, mouseY);
    }

    protected void drawGuiForegroundLayer(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.elements.forEach(o -> o.drawForeground(this.mc, mouseX, mouseY));
    }

    protected void drawGuiBackgroundLayer(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.guiLeft, (double)this.guiTop, (double)0.0);
        this.background.drawBackground(this.mc, mouseX, mouseY);
        this.background.drawForeground(this.mc, mouseX, mouseY);
        GL11.glTranslated((double)(-this.guiLeft), (double)(-this.guiTop), (double)0.0);
        GL11.glPopMatrix();
        this.elements.forEach(o -> o.drawBackground(this.mc, mouseX, mouseY));
    }

    public void updateScreen() {
        super.updateScreen();
        this.elements.stream().filter(element -> element instanceof IWidget).forEach(element -> ((IWidget)element).update());
    }
}

