/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui;

import eu.usrv.yamcore.client.dynamicgui.backgrounds.GUIBackgroundProvider;
import eu.usrv.yamcore.client.dynamicgui.backgrounds.SimpleRectangleBackground;
import eu.usrv.yamcore.client.dynamicgui.elements.IGuiElement;
import eu.usrv.yamcore.client.dynamicgui.elements.SimpleDrawingElement;
import eu.usrv.yamcore.client.dynamicgui.elements.SlotElement;
import eu.usrv.yamcore.client.dynamicgui.skins.BackgroundSkin;
import eu.usrv.yamcore.client.dynamicgui.widgets.IWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public abstract class DynGUIContainer<T extends Container>
extends GuiContainer {
    protected final T container;
    final BackgroundSkin skin;
    protected int guiWidth;
    protected int guiHeight;
    protected List<IGuiElement> elements;
    private GUIBackgroundProvider background;

    public DynGUIContainer(T container) {
        this(container, BackgroundSkin.defualt);
    }

    public DynGUIContainer(T container, BackgroundSkin skin) {
        super(container);
        this.container = container;
        this.skin = skin;
    }

    public void initGui() {
        super.initGui();
        this.elements = new ArrayList<IGuiElement>();
        this.elements.addAll(((ArrayList)((Container)this.container).inventorySlots).stream().map(slot -> new SlotElement((Slot)slot, this.skin)).collect(Collectors.toList()));
        this.addInitialElements(this.elements);
        int newWidth = 0;
        int newHeight = 0;
        for (IGuiElement element2 : this.elements) {
            if (element2.getElementX() + element2.getElementWidth() + 7 > newWidth) {
                newWidth = element2.getElementX() + element2.getElementWidth() + 7;
            }
            if (element2.getElementY() + element2.getElementHeight() + 7 <= newHeight) continue;
            newHeight = element2.getElementY() + element2.getElementHeight() + 7;
        }
        this.xSize = this.guiWidth = newWidth;
        this.ySize = this.guiHeight = newHeight;
        this.guiLeft = this.width / 2 - this.xSize / 2;
        this.guiTop = this.height / 2 - this.ySize / 2;
        this.elements.stream().filter(element -> element instanceof SimpleDrawingElement).forEach(element -> ((SimpleDrawingElement)element).setXY(this.guiLeft + element.getElementX(), this.guiTop + element.getElementY()));
        this.background = this.getBackgroundProvider();
    }

    public abstract void addInitialElements(List<IGuiElement> var1);

    protected GUIBackgroundProvider getBackgroundProvider() {
        return new SimpleRectangleBackground(this.skin, this.guiWidth, this.guiHeight);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.elements.forEach(o -> o.drawForeground(this.mc, mouseX, mouseY));
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.background.drawBackground(this.mc, mouseX, mouseY);
        this.background.drawForeground(this.mc, mouseX, mouseY);
        GL11.glTranslatef((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
        GL11.glPopMatrix();
        this.elements.forEach(o -> o.drawBackground(this.mc, mouseX, mouseY));
    }

    public void updateScreen() {
        super.updateScreen();
        this.elements.stream().filter(element -> element instanceof IWidget).forEach(element -> ((IWidget)element).update());
    }
}

