/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.client.Notification;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiNotification
extends Gui {
    private static final ResourceLocation backGround = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private final Minecraft minecraft;
    private int width;
    private int height;
    private String title;
    private String description;
    private Notification notification;
    private long timeOpen;
    private final RenderItem itemRenderer;
    private boolean hide;
    private final List<Notification> notifications = new ArrayList<Notification>();

    public GuiNotification(Minecraft mc) {
        this.minecraft = mc;
        this.itemRenderer = new RenderItem();
    }

    public void queueNotification(Notification notification) {
        this.queueNotification(notification, true);
    }

    public void queueNotification(Notification notification, boolean checkAlreadyQueued) {
        if (checkAlreadyQueued) {
            for (Notification noti : this.notifications) {
                if (!noti.equals(notification)) continue;
                return;
            }
        }
        if (this.notifications.isEmpty()) {
            this.title = notification.getTitle();
            this.description = notification.getDescription();
            this.timeOpen = Minecraft.getSystemTime();
            this.notification = notification;
        }
        this.notifications.add(notification);
    }

    public void moveToNextNotification() {
        if (!this.notifications.isEmpty()) {
            this.notifications.remove(0);
            this.setDead();
            if (!this.notifications.isEmpty()) {
                this.title = this.notifications.get(0).getTitle();
                this.description = this.notifications.get(0).getDescription();
                this.timeOpen = Minecraft.getSystemTime();
                this.notification = this.notifications.get(0);
                this.hide = false;
            }
        }
    }

    private void updateScale() {
        GL11.glViewport((int)0, (int)0, (int)this.minecraft.displayWidth, (int)this.minecraft.displayHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.width = this.minecraft.displayWidth;
        this.height = this.minecraft.displayHeight;
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft, this.minecraft.displayWidth, this.minecraft.displayHeight);
        this.width = scaledresolution.getScaledWidth();
        this.height = scaledresolution.getScaledHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void update() {
        if (this.notification != null && this.timeOpen != 0L && Minecraft.getMinecraft().thePlayer != null) {
            double d0 = (double)(Minecraft.getSystemTime() - this.timeOpen) / 3000.0;
            if (!this.hide) {
                if (d0 < 0.0 || d0 > 1.0) {
                    this.timeOpen = 0L;
                    this.moveToNextNotification();
                    return;
                }
            } else if (d0 > 0.5) {
                d0 = 0.5;
            }
            this.updateScale();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            double d1 = d0 * 2.0;
            if (d1 > 1.0) {
                d1 = 2.0 - d1;
            }
            d1 *= 4.0;
            if ((d1 = 1.0 - d1) < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            d1 *= d1;
            int i = this.width / 2 - 80;
            int j = 0 - (int)(d1 * 36.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            this.minecraft.getTextureManager().bindTexture(backGround);
            GL11.glDisable((int)2896);
            this.drawTexturedModalRect(i, j, 96, 202, 160, 32);
            if (this.hide) {
                this.minecraft.fontRenderer.drawSplitString(this.description, i + 30, j + 7, 120, -1);
            } else {
                this.minecraft.fontRenderer.drawString(this.title, i + 30, j + 7, -256);
                this.minecraft.fontRenderer.drawString(this.description, i + 30, j + 18, -1);
            }
            RenderHelper.enableGUIStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2903);
            GL11.glEnable((int)2896);
            this.itemRenderer.renderItemAndEffectIntoGUI(this.minecraft.fontRenderer, this.minecraft.getTextureManager(), this.notification.getIcon(), i + 8, j + 8);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
        }
    }

    public void setDead() {
        this.notification = null;
        this.timeOpen = 0L;
    }
}

