/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.IntHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.io.IOUtils;

public final class DonorController {
    private final URL _mDonorSourceURL;
    private final ArrayList<Donor> _mDonorList = new ArrayList();

    public DonorController(URL pDonorSourceURL) {
        this._mDonorSourceURL = pDonorSourceURL;
        this.loadDonors();
    }

    private void loadDonors() {
        try {
            String[] lines;
            InputStream tDonorFileStream = this._mDonorSourceURL.openStream();
            String tDonorDefinition = IOUtils.toString((InputStream)tDonorFileStream);
            IOUtils.closeQuietly((InputStream)tDonorFileStream);
            for (String line : lines = tDonorDefinition.split("\\r?\\n")) {
                Donor tDonor = Donor.tryLoad(line);
                if (tDonor == null) continue;
                this._mDonorList.add(tDonor);
            }
        }
        catch (Exception e) {
            YAMCore.instance.getLogger().warn(String.format("Unable to connect to %s. DonorController will not do anything!", this._mDonorSourceURL));
        }
    }

    public boolean isDonor(EntityPlayer pPlayer) {
        return this.isDonor(pPlayer.getUniqueID());
    }

    public boolean isDonor(EntityPlayerMP pPlayer) {
        return this.isDonor(pPlayer.getUniqueID());
    }

    public int getLevel(EntityPlayer pPlayer) {
        return this.getLevel(pPlayer.getUniqueID());
    }

    public int getLevel(EntityPlayerMP pPlayer) {
        return this.getLevel(pPlayer.getUniqueID());
    }

    public boolean hasExtraArg(EntityPlayer pPlayer, String pDonorArg) {
        return this.hasExtraArg(pPlayer.getUniqueID(), pDonorArg);
    }

    public boolean hasExtraArg(EntityPlayerMP pPlayer, String pDonorArg) {
        return this.hasExtraArg(pPlayer.getUniqueID(), pDonorArg);
    }

    private Donor getDonor(UUID pPlayerUUID) {
        for (Donor d : this._mDonorList) {
            if (!d.getUUID().equals(pPlayerUUID)) continue;
            return d;
        }
        return null;
    }

    public boolean isDonor(UUID pPlayerUUID) {
        return this.getDonor(pPlayerUUID) != null;
    }

    public boolean hasExtraArg(UUID pPlayerUUID, String pDonorArg) {
        Donor d = this.getDonor(pPlayerUUID);
        return d != null && d._mDonorExtraArgs.contains(pDonorArg);
    }

    public int getLevel(UUID pPlayerUUID) {
        Donor d = this.getDonor(pPlayerUUID);
        return d != null ? d.getLevel() : -1;
    }

    private static final class Donor {
        private UUID _mUUID;
        private int _mLevel;
        private List<String> _mDonorExtraArgs;

        public UUID getUUID() {
            return this._mUUID;
        }

        public int getLevel() {
            return this._mLevel;
        }

        public List<String> getDonorArgs() {
            return Collections.unmodifiableList(this._mDonorExtraArgs);
        }

        public static Donor tryLoad(String pDonorLine) {
            ArrayList<String> tArgs;
            String[] lineArgs = pDonorLine.split("#");
            UUID tUUID = null;
            int tLevel = 0;
            try {
                if (lineArgs.length > 0) {
                    tUUID = UUID.fromString(lineArgs[0]);
                }
            }
            catch (Exception e) {
                YAMCore.instance.getLogger().error(String.format("Invalid PlayerUUID found in DonorFile: %s", lineArgs[0]));
            }
            try {
                if (lineArgs.length > 1) {
                    if (!IntHelper.tryParse(lineArgs[1])) {
                        YAMCore.instance.getLogger().error(String.format("Second argument in DonorLine is not an integer: %s DonorLevel will default to 0", lineArgs[1]));
                    } else {
                        tLevel = Integer.parseInt(lineArgs[1]);
                    }
                }
            }
            catch (Exception e) {
                tLevel = 0;
            }
            try {
                tArgs = lineArgs.length > 2 ? new ArrayList<String>(Arrays.asList(lineArgs[2].split("!"))) : new ArrayList();
            }
            catch (Exception e) {
                tArgs = new ArrayList<String>();
            }
            if (tUUID != null) {
                return new Donor(tUUID, tLevel, tArgs);
            }
            return null;
        }

        private Donor(UUID pUserUUID, int pDonationLevel, ArrayList<String> pExtraArgs) {
            this._mUUID = pUserUUID;
            this._mLevel = pDonationLevel;
            this._mDonorExtraArgs = pExtraArgs;
        }
    }
}

