/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileBrainbox;

public class TileThaumatorium
extends TileThaumcraft
implements IAspectContainer,
IEssentiaTransport,
ISidedInventory {
    public ItemStack inputStack = null;
    public AspectList essentia = new AspectList();
    public ArrayList<Integer> recipeHash = new ArrayList();
    public ArrayList<AspectList> recipeEssentia = new ArrayList();
    public ArrayList<String> recipePlayer = new ArrayList();
    public int currentCraft = -1;
    public int maxRecipes = 1;
    public ForgeDirection facing = ForgeDirection.NORTH;
    public Aspect currentSuction = null;
    int venting = 0;
    int counter = 0;
    boolean heated = false;
    CrucibleRecipe currentRecipe = null;
    public Container eventHandler;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)this.yCoord, (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 2), (double)(this.zCoord + 2));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.facing = ForgeDirection.getOrientation((int)nbttagcompound.getByte("facing"));
        this.essentia.readFromNBT(nbttagcompound);
        this.maxRecipes = nbttagcompound.getByte("maxrec");
        this.recipeEssentia = new ArrayList();
        this.recipeHash = new ArrayList();
        this.recipePlayer = new ArrayList();
        int[] hashes = nbttagcompound.getIntArray("recipes");
        if (hashes != null) {
            for (int hash : hashes) {
                CrucibleRecipe recipe = ThaumcraftApi.getCrucibleRecipeFromHash(hash);
                if (recipe == null) continue;
                this.recipeEssentia.add(recipe.aspects.copy());
                this.recipePlayer.add("");
                this.recipeHash.add(hash);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("facing", (byte)this.facing.ordinal());
        nbttagcompound.setByte("maxrec", (byte)this.maxRecipes);
        this.essentia.writeToNBT(nbttagcompound);
        int[] hashes = new int[this.recipeHash.size()];
        int a = 0;
        for (Integer i : this.recipeHash) {
            hashes[a] = i;
            ++a;
        }
        nbttagcompound.setIntArray("recipes", hashes);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtCompound) {
        super.readFromNBT(nbtCompound);
        NBTTagList nbttaglist = nbtCompound.getTagList("Items", 10);
        if (nbttaglist.tagCount() > 0) {
            this.inputStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttaglist.getCompoundTagAt(0));
        }
        NBTTagList nbttaglist2 = nbtCompound.getTagList("OutputPlayer", 8);
        for (int a = 0; a < nbttaglist2.tagCount(); ++a) {
            if (this.recipePlayer.size() <= a) continue;
            this.recipePlayer.set(a, nbttaglist2.getStringTagAt(a));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtCompound) {
        super.writeToNBT(nbtCompound);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.inputStack != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)0);
            this.inputStack.writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbtCompound.setTag("Items", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        if (this.recipePlayer.size() > 0) {
            for (int a = 0; a < this.recipePlayer.size(); ++a) {
                if (this.recipePlayer.get(a) == null) continue;
                NBTTagString nbttagcompound1 = new NBTTagString(this.recipePlayer.get(a));
                nbttaglist2.appendTag((NBTBase)nbttagcompound1);
            }
        }
        nbtCompound.setTag("OutputPlayer", (NBTBase)nbttaglist2);
    }

    public boolean canUpdate() {
        return true;
    }

    boolean checkHeat() {
        Material mat = this.worldObj.getBlock(this.xCoord, this.yCoord - 2, this.zCoord).getMaterial();
        Block bi = this.worldObj.getBlock(this.xCoord, this.yCoord - 2, this.zCoord);
        int md = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 2, this.zCoord);
        return mat == Material.lava || mat == Material.fire || bi == ConfigBlocks.blockAiry && md == 1;
    }

    public ItemStack getCurrentOutputRecipe() {
        CrucibleRecipe recipe;
        ItemStack out = null;
        if (this.currentCraft >= 0 && this.recipeHash != null && this.recipeHash.size() > 0 && (recipe = ThaumcraftApi.getCrucibleRecipeFromHash(this.recipeHash.get(this.currentCraft))) != null) {
            out = recipe.getRecipeOutput().copy();
        }
        return out;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            if (this.counter == 0 || this.counter % 40 == 0) {
                this.heated = this.checkHeat();
                this.getUpgrades();
            }
            ++this.counter;
            if (this.heated && !this.gettingPower() && this.counter % 5 == 0 && this.recipeHash != null && this.recipeHash.size() > 0) {
                if (this.inputStack == null) {
                    this.currentSuction = null;
                    return;
                }
                if (this.currentCraft < 0 || this.currentCraft >= this.recipeHash.size() || this.currentRecipe == null || !this.currentRecipe.catalystMatches(this.inputStack)) {
                    for (int a = 0; a < this.recipeHash.size(); ++a) {
                        CrucibleRecipe recipe = ThaumcraftApi.getCrucibleRecipeFromHash(this.recipeHash.get(a));
                        if (!recipe.catalystMatches(this.inputStack)) continue;
                        this.currentCraft = a;
                        this.currentRecipe = recipe;
                        break;
                    }
                }
                if (this.currentCraft < 0 || this.currentCraft >= this.recipeHash.size()) {
                    return;
                }
                TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + this.facing.offsetX, this.yCoord, this.zCoord + this.facing.offsetZ);
                if (inventory != null && inventory instanceof IInventory) {
                    ItemStack dropped = this.getCurrentOutputRecipe();
                    if ((dropped = InventoryUtils.placeItemStackIntoInventory(dropped, (IInventory)inventory, this.facing.getOpposite().ordinal(), false)) != null) {
                        return;
                    }
                }
                boolean done = true;
                this.currentSuction = null;
                for (Aspect aspect : this.recipeEssentia.get(this.currentCraft).getAspectsSorted()) {
                    if (this.essentia.getAmount(aspect) >= this.recipeEssentia.get(this.currentCraft).getAmount(aspect)) continue;
                    this.currentSuction = aspect;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeRecipe();
                } else if (this.currentSuction != null) {
                    this.fill();
                }
            }
        } else if (this.venting > 0) {
            --this.venting;
            float fx = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            float fz = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            float fy = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            float fx2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            float fz2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            float fy2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
            int color = 0xFFFFFF;
            Thaumcraft.proxy.drawVentParticles(this.worldObj, (float)this.xCoord + 0.5f + fx + (float)this.facing.offsetX / 2.0f, (float)this.yCoord + 0.5f + fy, (float)this.zCoord + 0.5f + fz + (float)this.facing.offsetZ / 2.0f, (float)this.facing.offsetX / 4.0f + fx2, fy2, (float)this.facing.offsetZ / 4.0f + fz2, color);
        }
    }

    private void completeRecipe() {
        if (this.currentRecipe != null && this.currentCraft < this.recipeHash.size() && this.currentRecipe.matches(this.essentia, this.inputStack) && this.decrStackSize(0, 1) != null) {
            TileEntity inventory;
            this.essentia = new AspectList();
            ItemStack dropped = this.getCurrentOutputRecipe();
            EntityPlayer p = this.worldObj.getPlayerEntityByName(this.recipePlayer.get(this.currentCraft));
            if (p != null) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(p, dropped, (IInventory)new InventoryFake(new ItemStack[]{this.inputStack}));
            }
            if ((inventory = this.worldObj.getTileEntity(this.xCoord + this.facing.offsetX, this.yCoord, this.zCoord + this.facing.offsetZ)) != null && inventory instanceof IInventory) {
                dropped = InventoryUtils.placeItemStackIntoInventory(dropped, (IInventory)inventory, this.facing.getOpposite().ordinal(), true);
            }
            if (dropped != null) {
                EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)this.facing.offsetX * 0.66, (double)this.yCoord + 0.33 + (double)this.facing.getOpposite().offsetY, (double)this.zCoord + 0.5 + (double)this.facing.offsetZ * 0.66, dropped.copy());
                ei.motionX = 0.075f * (float)this.facing.offsetX;
                ei.motionY = 0.025f;
                ei.motionZ = 0.075f * (float)this.facing.offsetZ;
                this.worldObj.spawnEntityInWorld((Entity)ei);
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
            }
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.fizz", 0.25f, 2.6f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.8f);
            this.currentCraft = -1;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
    }

    void fill() {
        TileEntity te = null;
        IEssentiaTransport ic = null;
        for (int y = 0; y <= 1; ++y) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int ess;
                if (dir == this.facing || dir == ForgeDirection.DOWN || y == 0 && dir == ForgeDirection.UP || (te = ThaumcraftApiHelper.getConnectableTile(this.worldObj, this.xCoord, this.yCoord + y, this.zCoord, dir)) == null || (ic = (IEssentiaTransport)te).getEssentiaAmount(dir.getOpposite()) <= 0 || ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(null) || this.getSuctionAmount(null) < ic.getMinimumSuction() || (ess = ic.takeEssentia(this.currentSuction, 1, dir.getOpposite())) <= 0) continue;
                this.addToContainer(this.currentSuction, ess);
                return;
            }
        }
    }

    @Override
    public int addToContainer(Aspect tt, int am) {
        int ce = this.currentRecipe.aspects.getAmount(tt) - this.essentia.getAmount(tt);
        if (this.currentRecipe == null || ce <= 0) {
            return am;
        }
        int add = Math.min(ce, am);
        this.essentia.add(tt, add);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
        return am - add;
    }

    @Override
    public boolean takeFromContainer(Aspect tt, int am) {
        if (this.essentia.getAmount(tt) >= am) {
            this.essentia.remove(tt, am);
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tt, int am) {
        return this.essentia.getAmount(tt) >= am;
    }

    @Override
    public int containerContains(Aspect tt) {
        return this.essentia.getAmount(tt);
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public boolean receiveClientEvent(int i, int j) {
        if (i >= 0) {
            if (this.worldObj.isRemote) {
                this.venting = 7;
            }
            return true;
        }
        return super.receiveClientEvent(i, j);
    }

    @Override
    public boolean isConnectable(ForgeDirection face) {
        return face != this.facing;
    }

    @Override
    public boolean canInputFrom(ForgeDirection face) {
        return face != this.facing;
    }

    @Override
    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        this.currentSuction = aspect;
    }

    @Override
    public Aspect getSuctionType(ForgeDirection loc) {
        return this.currentSuction;
    }

    @Override
    public int getSuctionAmount(ForgeDirection loc) {
        return this.currentSuction != null ? 128 : 0;
    }

    @Override
    public Aspect getEssentiaType(ForgeDirection loc) {
        return null;
    }

    @Override
    public int getEssentiaAmount(ForgeDirection loc) {
        return 0;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canOutputTo(face) && this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    @Override
    public int getMinimumSuction() {
        return 0;
    }

    @Override
    public boolean renderExtendedTube() {
        return false;
    }

    @Override
    public AspectList getAspects() {
        return this.essentia;
    }

    @Override
    public void setAspects(AspectList aspects) {
        this.essentia = aspects;
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int par1) {
        return this.inputStack;
    }

    public ItemStack decrStackSize(int par1, int par2) {
        if (this.inputStack != null) {
            if (this.inputStack.stackSize <= par2) {
                ItemStack itemstack = this.inputStack;
                this.inputStack = null;
                if (this.eventHandler != null) {
                    this.eventHandler.onCraftMatrixChanged((IInventory)this);
                }
                return itemstack;
            }
            ItemStack itemstack = this.inputStack.splitStack(par2);
            if (this.inputStack.stackSize == 0) {
                this.inputStack = null;
            }
            if (this.eventHandler != null) {
                this.eventHandler.onCraftMatrixChanged((IInventory)this);
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int par1) {
        if (this.inputStack != null) {
            ItemStack itemstack = this.inputStack;
            this.inputStack = null;
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.inputStack = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
            par2ItemStack.stackSize = this.getInventoryStackLimit();
        }
        if (this.eventHandler != null) {
            this.eventHandler.onCraftMatrixChanged((IInventory)this);
        }
    }

    public String getInventoryName() {
        return "container.alchemyfurnace";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public int[] getAccessibleSlotsFromSide(int par1) {
        return new int[]{0};
    }

    public boolean canInsertItem(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }

    public boolean canExtractItem(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }

    public boolean gettingPower() {
        return this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) || this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord - 1, this.zCoord) || this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    public void getUpgrades() {
        int mr = 1;
        for (int yy = 0; yy <= 1; ++yy) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te;
                if (dir == ForgeDirection.DOWN || dir == this.facing) continue;
                int xx = this.xCoord + dir.offsetX;
                int zz = this.zCoord + dir.offsetZ;
                Block bi = this.worldObj.getBlock(xx, this.yCoord + yy + dir.offsetY, zz);
                int md = this.worldObj.getBlockMetadata(xx, this.yCoord + yy + dir.offsetY, zz);
                if (bi != ConfigBlocks.blockMetalDevice || md != 12 || (te = this.worldObj.getTileEntity(xx, this.yCoord + yy + dir.offsetY, zz)) == null || !(te instanceof TileBrainbox) || ((TileBrainbox)te).facing != dir.getOpposite()) continue;
                mr += 2;
            }
        }
        if (mr != this.maxRecipes) {
            this.maxRecipes = mr;
            while (this.recipeHash.size() > this.maxRecipes) {
                this.recipeHash.remove(this.recipeHash.size() - 1);
            }
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
    }
}

