/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.common.lib.research.ResearchManager;

public class TileNodeEnergized
extends TileVisNode
implements IAspectContainer {
    private AspectList auraBase = new AspectList().add(Aspect.AIR, 20).add(Aspect.FIRE, 20).add(Aspect.EARTH, 20).add(Aspect.WATER, 20).add(Aspect.ORDER, 20).add(Aspect.ENTROPY, 20);
    AspectList visBase = new AspectList();
    AspectList vis = new AspectList();
    private NodeType nodeType = NodeType.NORMAL;
    private NodeModifier nodeModifier = null;
    String id = "blank";

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote) {
            if (this.getNodeType() == NodeType.UNSTABLE && this.worldObj.rand.nextInt(500) == 1) {
                this.visBase = new AspectList();
            }
            if (this.visBase.size() == 0 && this.getAuraBase().size() > 0) {
                this.setupNode();
            }
            this.vis = this.visBase.copy();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void setupNode() {
        this.visBase = new AspectList();
        AspectList temp = ResearchManager.reduceToPrimals(this.getAuraBase(), true);
        for (Aspect aspect : temp.getAspects()) {
            int amt = temp.getAmount(aspect);
            if (this.getNodeModifier() == NodeModifier.BRIGHT) {
                amt = (int)((float)amt * 1.2f);
            }
            if (this.getNodeModifier() == NodeModifier.PALE) {
                amt = (int)((float)amt * 0.8f);
            }
            if (this.getNodeModifier() == NodeModifier.FADING) {
                amt = (int)((float)amt * 0.5f);
            }
            amt = MathHelper.floor_double((double)MathHelper.sqrt_double((double)amt));
            if (this.getNodeType() == NodeType.UNSTABLE) {
                amt += this.worldObj.rand.nextInt(5) - 2;
            }
            if (amt < 1) continue;
            this.visBase.merge(aspect, amt);
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.id = nbttagcompound.getString("nodeId");
        this.setNodeType(NodeType.values()[nbttagcompound.getByte("type")]);
        byte mod = nbttagcompound.getByte("modifier");
        if (mod >= 0) {
            this.setNodeModifier(NodeModifier.values()[mod]);
        } else {
            this.setNodeModifier(null);
        }
        this.visBase.aspects.clear();
        NBTTagList tlist = nbttagcompound.getTagList("AEB", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            this.visBase.add(Aspect.getAspect(rs.getString("key")), rs.getInteger("amount"));
        }
        this.getAuraBase().readFromNBT(nbttagcompound);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setString("nodeId", this.id);
        nbttagcompound.setByte("type", (byte)this.getNodeType().ordinal());
        nbttagcompound.setByte("modifier", this.getNodeModifier() == null ? (byte)-1 : (byte)this.getNodeModifier().ordinal());
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("AEB", (NBTBase)tlist);
        for (Aspect aspect : this.visBase.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.visBase.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
        this.getAuraBase().writeToNBT(nbttagcompound);
    }

    public boolean receiveClientEvent(int i, int j) {
        return super.receiveClientEvent(i, j);
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setNodeModifier(NodeModifier nodeModifier) {
        this.nodeModifier = nodeModifier;
    }

    public NodeModifier getNodeModifier() {
        return this.nodeModifier;
    }

    @Override
    public int getRange() {
        return 8;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public int consumeVis(Aspect aspect, int amount) {
        int drain = Math.min(this.vis.getAmount(aspect), amount);
        if (drain > 0) {
            this.vis.reduce(aspect, drain);
        }
        return drain;
    }

    public AspectList getAuraBase() {
        return this.auraBase;
    }

    @Override
    public AspectList getAspects() {
        return this.visBase;
    }

    @Override
    public void setAspects(AspectList aspects) {
        this.auraBase = aspects;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public byte getAttunement() {
        return -1;
    }
}

