/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.lib.research.ResearchManager;

public class TileManaPod
extends TileThaumcraft
implements IAspectContainer {
    public Aspect aspect = null;

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspect = Aspect.getAspect(nbttagcompound.getString("aspect"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        if (this.aspect != null) {
            nbttagcompound.setString("aspect", this.aspect.getTag());
        }
    }

    public void checkGrowth() {
        int l = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
        if (l < 7) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, ++l, 3);
        }
        if (l > 2) {
            if (l == 3) {
                AspectList al = new AspectList();
                if (this.aspect != null) {
                    al.add(this.aspect, 1);
                }
                for (int d = 2; d < 6; ++d) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)d);
                    int x = this.xCoord + dir.offsetX;
                    int y = this.yCoord + dir.offsetY;
                    int z = this.zCoord + dir.offsetZ;
                    TileEntity tile = this.worldObj.getTileEntity(x, y, z);
                    if (tile == null || !(tile instanceof TileManaPod) || ((TileManaPod)tile).aspect == null) continue;
                    al.add(((TileManaPod)tile).aspect, 1);
                }
                if (al.size() > 1) {
                    Aspect[] aa = al.getAspects();
                    ArrayList<Aspect> outlist = new ArrayList<Aspect>();
                    for (int i = 0; i < aa.length; ++i) {
                        outlist.add(aa[i]);
                        for (int j = 0; j < aa.length; ++j) {
                            Aspect combo;
                            if (i == j || (combo = ResearchManager.getCombinationResult(aa[i], aa[j])) == null) continue;
                            outlist.add(combo);
                            outlist.add(combo);
                        }
                    }
                    if (outlist.size() > 0) {
                        this.aspect = (Aspect)outlist.get(this.worldObj.rand.nextInt(outlist.size()));
                        this.markDirty();
                    }
                }
                if (al.size() >= 1 && this.aspect == null) {
                    this.aspect = al.getAspectsSortedAmount()[0];
                    this.markDirty();
                }
            }
            if (this.aspect == null) {
                if (this.worldObj.rand.nextInt(8) == 0) {
                    this.aspect = Aspect.PLANT;
                } else {
                    ArrayList<Aspect> outlist = Aspect.getPrimalAspects();
                    this.aspect = outlist.get(this.worldObj.rand.nextInt(outlist.size()));
                }
                this.markDirty();
            }
        }
    }

    @Override
    public AspectList getAspects() {
        return this.aspect != null && this.getBlockMetadata() == 7 ? new AspectList().add(this.aspect, 1) : null;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }
}

