/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.common.container.ContainerMagicBox;

public class TileMagicBox
extends TileThaumcraft
implements IInventory {
    ArrayList<ItemStack> boxContents = new ArrayList();
    WorldCoordinates master = null;
    byte sorting = (byte)-1;
    short linkedBoxes = (short)-1;
    public static ContainerMagicBox tc;

    public int getSizeInventory() {
        return 27 * (this.getInventory().linkedBoxes + 1);
    }

    private ArrayList<ItemStack> getContents() {
        return this.master != null ? this.getInventory().boxContents : this.boxContents;
    }

    private TileMagicBox getInventory() {
        TileEntity tile = null;
        if (this.master != null) {
            tile = this.worldObj.getTileEntity(this.master.x, this.master.y, this.master.z);
        }
        return tile != null && tile instanceof TileMagicBox ? (TileMagicBox)tile : this;
    }

    public ItemStack getStackInSlot(int par1) {
        return par1 >= this.getContents().size() ? null : this.getContents().get(par1);
    }

    public ItemStack decrStackSize(int par1, int par2) {
        if (par1 < this.getContents().size() && this.getContents().get(par1) != null) {
            if (this.getContents().get((int)par1).stackSize <= par2) {
                ItemStack var3 = this.getContents().get(par1);
                this.getContents().remove(par1);
                this.getInventory().markDirty();
                return var3;
            }
            ItemStack var3 = this.getContents().get(par1).splitStack(par2);
            if (this.getContents().get((int)par1).stackSize == 0) {
                this.getContents().remove(par1);
            }
            this.getInventory().markDirty();
            return var3;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int par1) {
        if (par1 < this.getContents().size() && this.getContents().get(par1) != null) {
            ItemStack var2 = this.getContents().get(par1);
            this.getContents().remove(par1);
            return var2;
        }
        return null;
    }

    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        if (par1 >= this.getContents().size() && par2ItemStack != null && par2ItemStack.stackSize > 0) {
            this.getContents().add(par2ItemStack);
        } else if (par2ItemStack != null && par2ItemStack.stackSize > 0) {
            this.getContents().set(par1, par2ItemStack);
        } else if (par1 < this.getContents().size()) {
            this.getContents().remove(par1);
        }
        if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
            par2ItemStack.stackSize = this.getInventoryStackLimit();
        }
        this.getInventory().markDirty();
    }

    public void markDirty() {
        super.markDirty();
        this.sort();
    }

    public String getInventoryName() {
        return "Magic Box";
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.getTagList("Items", 10);
        this.boxContents = new ArrayList();
        for (int var3 = 0; var3 < var2.tagCount(); ++var3) {
            NBTTagCompound var4 = var2.getCompoundTagAt(var3);
            this.boxContents.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)var4));
        }
        this.sort();
    }

    @Override
    public void readCustomNBT(NBTTagCompound par1NBTTagCompound) {
        this.sorting = par1NBTTagCompound.getByte("sort");
        this.master = null;
        if (par1NBTTagCompound.hasKey("w_x")) {
            this.master = new WorldCoordinates();
            this.master.readNBT(par1NBTTagCompound);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.boxContents.size(); ++var3) {
            if (this.boxContents.get(var3) == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            this.boxContents.get(var3).writeToNBT(var4);
            var2.appendTag((NBTBase)var4);
        }
        par1NBTTagCompound.setTag("Items", (NBTBase)var2);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setByte("sort", this.sorting);
        if (this.master != null) {
            this.master.writeNBT(par1NBTTagCompound);
        }
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.getInventory() == this && this.linkedBoxes < 0) {
            this.refreshLinks();
        }
    }

    public boolean receiveClientEvent(int par1, int par2) {
        if (par1 == 1) {
            return true;
        }
        if (par1 == 2) {
            return true;
        }
        return this.tileEntityInvalid;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void invalidate() {
        this.updateContainingBlockInfo();
        super.invalidate();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public void sort() {
        if (this.getWorldObj() == null || this.sorting < 0) {
            return;
        }
        boolean done = false;
        block0: while (!done) {
            done = true;
            for (int i = 0; i < this.getContents().size() - 1; ++i) {
                done = this.swopSlots(i, i + 1);
                if (this.getContents().get((int)i).stackSize >= this.getContents().get(i).getMaxStackSize() || !this.getContents().get(i).isItemEqual(this.getContents().get(i + 1)) || !ItemStack.areItemStackTagsEqual((ItemStack)this.getContents().get(i), (ItemStack)this.getContents().get(i + 1))) continue;
                ItemStack is1 = this.getContents().get(i).copy();
                ItemStack is2 = this.getContents().get(i + 1).copy();
                int c = Math.min(is1.getMaxStackSize() - is1.stackSize, is2.stackSize);
                is1.stackSize += c;
                is2.stackSize -= c;
                this.getContents().set(i, is1);
                done = false;
                if (is2.stackSize > 0) {
                    this.getContents().set(i + 1, is2);
                    continue;
                }
                this.getContents().remove(i + 1);
                continue block0;
            }
        }
    }

    private boolean swopSlots(int i, int j) {
        if (this.sorting == 0 || this.sorting == 1) {
            if (this.getContents().get(i).getDisplayName() != null && this.getContents().get(j).getDisplayName() != null) {
                int r;
                String s1 = "";
                String s2 = "";
                s1 = s1 + this.getContents().get(i).getDisplayName();
                s2 = s2 + this.getContents().get(j).getDisplayName();
                if (this.getContents().get(i).hasTagCompound()) {
                    s1 = s1 + "" + this.getContents().get((int)i).stackTagCompound.hashCode();
                }
                if (this.getContents().get(j).hasTagCompound()) {
                    s2 = s2 + "" + this.getContents().get((int)j).stackTagCompound.hashCode();
                }
                if ((r = s1.compareToIgnoreCase(s2)) > 0 && this.sorting == 0 || r < 0 && this.sorting == 1) {
                    ItemStack is1 = this.getContents().get(i).copy();
                    ItemStack is2 = this.getContents().get(j).copy();
                    this.getContents().set(i, is2);
                    this.getContents().set(j, is1);
                    return false;
                }
            }
        } else if (this.sorting == 2 && this.getContents().get(i).getDisplayName() != null && this.getContents().get(j).getDisplayName() != null) {
            int r;
            String s1 = "";
            String s2 = "";
            if (GameRegistry.findUniqueIdentifierFor((Item)this.getContents().get(i).getItem()) != null) {
                s1 = s1 + GameRegistry.findUniqueIdentifierFor((Item)this.getContents().get((int)i).getItem()).modId;
            } else if (GameRegistry.findUniqueIdentifierFor((Block)Block.getBlockFromItem((Item)this.getContents().get(i).getItem())) != null) {
                s1 = s1 + GameRegistry.findUniqueIdentifierFor((Block)Block.getBlockFromItem((Item)this.getContents().get((int)i).getItem())).modId;
            }
            if (GameRegistry.findUniqueIdentifierFor((Item)this.getContents().get(j).getItem()) != null) {
                s1 = s1 + GameRegistry.findUniqueIdentifierFor((Item)this.getContents().get((int)j).getItem()).modId;
            } else if (GameRegistry.findUniqueIdentifierFor((Block)Block.getBlockFromItem((Item)this.getContents().get(j).getItem())) != null) {
                s1 = s1 + GameRegistry.findUniqueIdentifierFor((Block)Block.getBlockFromItem((Item)this.getContents().get((int)j).getItem())).modId;
            }
            s1 = s1 + this.getContents().get(i).getDisplayName();
            s2 = s2 + this.getContents().get(j).getDisplayName();
            if (this.getContents().get(i).hasTagCompound()) {
                s1 = s1 + "" + this.getContents().get((int)i).stackTagCompound.hashCode();
            }
            if (this.getContents().get(j).hasTagCompound()) {
                s2 = s2 + "" + this.getContents().get((int)j).stackTagCompound.hashCode();
            }
            if ((r = s1.compareToIgnoreCase(s2)) > 0 && this.sorting == 2) {
                ItemStack is1 = this.getContents().get(i).copy();
                ItemStack is2 = this.getContents().get(j).copy();
                this.getContents().set(i, is2);
                this.getContents().set(j, is1);
                return false;
            }
        }
        return true;
    }

    public void refreshLinks() {
        if (this.getInventory() != this) {
            return;
        }
        this.linkedBoxes = 0;
        ArrayList<WorldCoordinates> list = new ArrayList<WorldCoordinates>();
        this.findBoxes(this.xCoord, this.yCoord, this.zCoord, list);
        this.linkedBoxes = (short)list.size();
    }

    private void findBoxes(int x, int y, int z, ArrayList<WorldCoordinates> list) {
        if (list.size() >= 1024) {
            return;
        }
        for (int a = 0; a < 6; ++a) {
            WorldCoordinates wc;
            ForgeDirection dir = ForgeDirection.getOrientation((int)a);
            TileEntity tile = this.worldObj.getTileEntity(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (tile == null || !(tile instanceof TileMagicBox) || list.contains(wc = new WorldCoordinates(tile))) continue;
            list.add(wc);
            this.findBoxes(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, list);
        }
    }
}

