/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.tiles.TileJar;

public class TileJarBrain
extends TileJar {
    public float field_40063_b;
    public float field_40061_d;
    public float field_40059_f;
    public float field_40066_q;
    public float rota;
    public float rotb;
    public int xp = 0;
    public int xpMax = 2000;
    public int eatDelay = 0;
    long lastsigh = System.currentTimeMillis() + 1500L;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.xp = nbttagcompound.getInteger("XP");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("XP", this.xp);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        List ents;
        double var7;
        double var5;
        double var3;
        double var9;
        double var11;
        super.updateEntity();
        Entity entity = null;
        if (this.xp > this.xpMax) {
            this.xp = this.xpMax;
        }
        if (this.xp < this.xpMax && (entity = this.getClosestXPOrb()) != null && this.eatDelay == 0 && (var11 = 1.0 - (var9 = Math.sqrt((var3 = ((double)this.xCoord + 0.5 - entity.posX) / 7.0) * var3 + (var5 = ((double)this.yCoord + 0.5 - entity.posY) / 7.0) * var5 + (var7 = ((double)this.zCoord + 0.5 - entity.posZ) / 7.0) * var7))) > 0.0) {
            var11 *= var11;
            entity.motionX += var3 / var9 * var11 * 0.15;
            entity.motionY += var5 / var9 * var11 * 0.33;
            entity.motionZ += var7 / var9 * var11 * 0.15;
        }
        if (this.worldObj.isRemote) {
            float f;
            this.rotb = this.rota;
            if (entity == null && (entity = this.worldObj.getClosestPlayer((double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + 0.5f), (double)((float)this.zCoord + 0.5f), 6.0)) != null && this.lastsigh < System.currentTimeMillis()) {
                this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:brain", 0.15f, 0.8f + this.worldObj.rand.nextFloat() * 0.4f, false);
                this.lastsigh = System.currentTimeMillis() + 5000L + (long)this.worldObj.rand.nextInt(25000);
            }
            if (entity != null) {
                double d = entity.posX - (double)((float)this.xCoord + 0.5f);
                double d1 = entity.posZ - (double)((float)this.zCoord + 0.5f);
                this.field_40066_q = (float)Math.atan2(d1, d);
                this.field_40059_f += 0.1f;
                if (this.field_40059_f < 0.5f || rand.nextInt(40) == 0) {
                    float f3 = this.field_40061_d;
                    do {
                        this.field_40061_d += (float)(rand.nextInt(4) - rand.nextInt(4));
                    } while (f3 == this.field_40061_d);
                }
            } else {
                this.field_40066_q += 0.01f;
            }
            while (this.rota >= 3.141593f) {
                this.rota -= 6.283185f;
            }
            while (this.rota < -3.141593f) {
                this.rota += 6.283185f;
            }
            while (this.field_40066_q >= 3.141593f) {
                this.field_40066_q -= 6.283185f;
            }
            while (this.field_40066_q < -3.141593f) {
                this.field_40066_q += 6.283185f;
            }
            for (f = this.field_40066_q - this.rota; f >= 3.141593f; f -= 6.283185f) {
            }
            while (f < -3.141593f) {
                f += 6.283185f;
            }
            this.rota += f * 0.04f;
        }
        if (this.eatDelay > 0) {
            --this.eatDelay;
        } else if (this.xp < this.xpMax && (ents = this.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBox((double)((double)this.xCoord - 0.1), (double)((double)this.yCoord - 0.1), (double)((double)this.zCoord - 0.1), (double)((double)this.xCoord + 1.1), (double)((double)this.yCoord + 1.1), (double)((double)this.zCoord + 1.1)))).size() > 0) {
            for (Object ent : ents) {
                EntityXPOrb eo = (EntityXPOrb)ent;
                this.xp += eo.getXpValue();
                this.worldObj.playSoundAtEntity((Entity)eo, "random.eat", 0.1f, (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f + 1.0f);
                eo.setDead();
            }
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
    }

    public Entity getClosestXPOrb() {
        double cdist = Double.MAX_VALUE;
        EntityXPOrb orb = null;
        List ents = this.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(6.0, 6.0, 6.0));
        if (ents.size() > 0) {
            for (Object ent : ents) {
                EntityXPOrb eo = (EntityXPOrb)ent;
                double d = this.getDistanceTo(eo.posX, eo.posY, eo.posZ);
                if (!(d < cdist)) continue;
                orb = eo;
                cdist = d;
            }
        }
        return orb;
    }

    public double getDistanceTo(double par1, double par3, double par5) {
        double var7 = (double)this.xCoord + 0.5 - par1;
        double var9 = (double)this.yCoord + 0.5 - par3;
        double var11 = (double)this.zCoord + 0.5 - par5;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }
}

