/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.tiles.TileCrystal;
import thaumcraft.common.tiles.TileEldritchCrabSpawner;

public class GenCommon {
    static ArrayList<ChunkCoordinates> decoCommon = new ArrayList();
    static ArrayList<ChunkCoordinates> crabSpawner = new ArrayList();
    static ArrayList<ChunkCoordinates> decoUrn = new ArrayList();
    static final int BEDROCK = 1;
    static final int BEDROCK_REPL = 99;
    static final int STONE = 2;
    static final int VOID = 8;
    static final int AIR_REPL = 9;
    static final int STAIR_DIRECTIONAL = 10;
    static final int STAIR_DIRECTIONAL_INV = 11;
    static final int SLAB = 12;
    static final int DOOR_BLOCK = 15;
    static final int DOOR_LOCK = 16;
    static final int VOID_DOOR = 17;
    static final int ROCK = 18;
    static final int STONE_NOSPAWN = 19;
    static final int STONE_TRAPPED = 20;
    static final int CRUST = 21;
    static final int[][] PAT_CONNECT = new int[][]{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 8, 8, 8, 8, 8, 8, 8, 8, 8, 1}, {1, 8, 8, 2, 2, 2, 2, 2, 8, 8, 1}, {1, 8, 2, 5, 9, 9, 9, 6, 2, 8, 1}, {1, 8, 2, 9, 9, 9, 9, 9, 2, 8, 1}, {1, 8, 2, 9, 9, 9, 9, 9, 2, 8, 1}, {1, 8, 2, 9, 9, 9, 9, 9, 2, 8, 1}, {1, 8, 2, 3, 9, 9, 9, 4, 2, 8, 1}, {1, 8, 8, 2, 2, 2, 2, 2, 8, 8, 1}, {1, 8, 8, 8, 8, 8, 8, 8, 8, 8, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}};

    static void placeBlock(World world, int i, int j, int k, int l, Cell cell) {
        GenCommon.placeBlock(world, i, j, k, l, ForgeDirection.UNKNOWN, cell);
    }

    static void placeBlock(World world, int x, int y, int z, int b, ForgeDirection dir, Cell cell) {
        Block block = null;
        int meta = 0;
        block0 : switch (b) {
            case 1: {
                if (!world.isAirBlock(x, y, z)) break;
                block = Blocks.bedrock;
                break;
            }
            case 15: {
                block = ConfigBlocks.blockEldritch;
                meta = 7;
                decoCommon.remove(new ChunkCoordinates(x, y, z));
                crabSpawner.remove(new ChunkCoordinates(x, y, z));
                decoUrn.remove(new ChunkCoordinates(x, y, z));
                break;
            }
            case 16: {
                block = ConfigBlocks.blockEldritch;
                meta = 8;
                decoCommon.remove(new ChunkCoordinates(x, y, z));
                crabSpawner.remove(new ChunkCoordinates(x, y, z));
                decoUrn.remove(new ChunkCoordinates(x, y, z));
                break;
            }
            case 99: {
                block = Blocks.bedrock;
                break;
            }
            case 8: {
                block = ConfigBlocks.blockEldritchNothing;
                break;
            }
            case 17: {
                block = ConfigBlocks.blockAiry;
                meta = 12;
                break;
            }
            case 9: {
                block = Blocks.air;
                decoCommon.remove(new ChunkCoordinates(x, y, z));
                crabSpawner.remove(new ChunkCoordinates(x, y, z));
                decoUrn.remove(new ChunkCoordinates(x, y, z));
                break;
            }
            case 2: {
                if (cell.feature != 7 || world.rand.nextInt(3) != 0) {
                    if (world.getBlock(x, y, z) == ConfigBlocks.blockEldritchNothing) break;
                    if (world.rand.nextInt(25) == 0) {
                        boolean crab;
                        boolean bl = cell.feature == 7 ? true : (crab = world.rand.nextInt(50) == 0);
                        if (crab && cell.feature == 0 || crab && cell.feature == 7) {
                            crabSpawner.add(new ChunkCoordinates(x, y, z));
                        } else {
                            decoCommon.add(new ChunkCoordinates(x, y, z));
                        }
                    }
                    block = ConfigBlocks.blockCosmeticSolid;
                    meta = 11;
                    break;
                }
            }
            case 21: {
                boolean crab;
                if (world.getBlock(x, y, z) == ConfigBlocks.blockEldritchNothing) break;
                block = ConfigBlocks.blockCosmeticSolid;
                meta = 14;
                if (world.rand.nextInt(25) == 0) {
                    block = ConfigBlocks.blockEldritch;
                    meta = 4;
                    break;
                }
                if (world.rand.nextInt(25) != 0) break;
                boolean bl = cell.feature == 7 ? true : (cell.feature == 12 && world.rand.nextBoolean() ? true : (crab = world.rand.nextInt(25) == 0));
                if (!(crab && cell.feature == 0 || crab && cell.feature == 7) && (!crab || cell.feature != 12)) break;
                crabSpawner.add(new ChunkCoordinates(x, y, z));
                break;
            }
            case 18: {
                if (world.getBlock(x, y, z) == ConfigBlocks.blockEldritchNothing) break;
                block = ConfigBlocks.blockCosmeticSolid;
                meta = 12;
                break;
            }
            case 19: {
                if (world.getBlock(x, y, z) == ConfigBlocks.blockEldritchNothing) break;
                block = ConfigBlocks.blockCosmeticSolid;
                meta = 13;
                break;
            }
            case 20: {
                if (world.getBlock(x, y, z) == ConfigBlocks.blockEldritchNothing) break;
                block = ConfigBlocks.blockEldritch;
                meta = 10;
                break;
            }
            case 10: {
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir) {
                    case NORTH: {
                        meta = 3;
                        break block0;
                    }
                    case SOUTH: {
                        meta = 2;
                        break block0;
                    }
                    case EAST: {
                        meta = 0;
                        break block0;
                    }
                    case WEST: {
                        meta = 1;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir) {
                    case NORTH: {
                        meta = 7;
                        break block0;
                    }
                    case SOUTH: {
                        meta = 6;
                        break block0;
                    }
                    case EAST: {
                        meta = 4;
                        break block0;
                    }
                    case WEST: {
                        meta = 5;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                if ((double)world.rand.nextFloat() < 0.005) {
                    decoUrn.add(new ChunkCoordinates(x, y, z));
                }
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 3;
                    }
                }
                break;
            }
            case 4: {
                if ((double)world.rand.nextFloat() < 0.005) {
                    decoUrn.add(new ChunkCoordinates(x, y, z));
                }
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 0;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 2;
                    }
                }
                break;
            }
            case 5: {
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 5;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 7;
                    }
                }
                break;
            }
            case 6: {
                block = ConfigBlocks.blockStairsEldritch;
                switch (dir.ordinal()) {
                    case 2: 
                    case 3: {
                        meta = 4;
                        break;
                    }
                    case 4: 
                    case 5: {
                        meta = 6;
                    }
                }
                break;
            }
            case 7: {
                block = ConfigBlocks.blockEldritch;
                meta = 4;
            }
        }
        if (block != null) {
            world.setBlock(x, y, z, block, meta, block == ConfigBlocks.blockEldritchNothing || block == Blocks.bedrock || block == Blocks.air ? 0 : 3);
        }
    }

    public static void genObelisk(World world, int x, int y, int z) {
        world.setBlock(x, y, z, ConfigBlocks.blockEldritch, 1, 3);
        world.setBlock(x, y + 1, z, ConfigBlocks.blockEldritch, 2, 3);
        world.setBlock(x, y + 2, z, ConfigBlocks.blockEldritch, 2, 3);
        world.setBlock(x, y + 3, z, ConfigBlocks.blockEldritch, 2, 3);
        world.setBlock(x, y + 4, z, ConfigBlocks.blockEldritch, 2, 3);
    }

    static void processDecorations(World world) {
        int meta;
        for (ChunkCoordinates cc : decoUrn) {
            if (!world.isAirBlock(cc.posX, cc.posY + 1, cc.posZ)) continue;
            world.setBlock(cc.posX, cc.posY, cc.posZ, ConfigBlocks.blockCosmeticSolid, 15, 3);
            float rr = world.rand.nextFloat();
            meta = rr < 0.025f ? 2 : (rr < 0.1f ? 1 : 0);
            world.setBlock(cc.posX, cc.posY + 1, cc.posZ, ConfigBlocks.blockLootUrn, meta, 3);
        }
        block1: for (ChunkCoordinates cc : decoCommon) {
            int exp = BlockUtils.countExposedSides(world, cc.posX, cc.posY, cc.posZ);
            if (exp <= 0 || exp != 1 && GenCommon.isBedrockShowing(world, cc.posX, cc.posY, cc.posZ) || BlockUtils.isBlockAdjacentToAtleast((IBlockAccess)world, cc.posX, cc.posY, cc.posZ, ConfigBlocks.blockEldritch, Short.MAX_VALUE, 1)) continue;
            meta = world.rand.nextInt(3) != 0 ? 4 : (world.rand.nextInt(8) != 0 ? 5 : 10);
            world.setBlock(cc.posX, cc.posY, cc.posZ, ConfigBlocks.blockEldritch, meta, 3);
            if (meta != 4 || world.rand.nextInt(12) != 0) continue;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!world.isAirBlock(cc.posX + dir.offsetX, cc.posY + dir.offsetY, cc.posZ + dir.offsetZ)) continue;
                world.setBlock(cc.posX + dir.offsetX, cc.posY + dir.offsetY, cc.posZ + dir.offsetZ, ConfigBlocks.blockCrystal, 7, 3);
                TileCrystal te = (TileCrystal)world.getTileEntity(cc.posX + dir.offsetX, cc.posY + dir.offsetY, cc.posZ + dir.offsetZ);
                te.orientation = (short)dir.ordinal();
                continue block1;
            }
        }
        block3: for (ChunkCoordinates cc : crabSpawner) {
            int exp = BlockUtils.countExposedSides(world, cc.posX, cc.posY, cc.posZ);
            if (exp != 1 || BlockUtils.isBlockAdjacentToAtleast((IBlockAccess)world, cc.posX, cc.posY, cc.posZ, ConfigBlocks.blockEldritch, Short.MAX_VALUE, 1)) continue;
            world.setBlock(cc.posX, cc.posY, cc.posZ, ConfigBlocks.blockEldritch, 9, 3);
            TileEntity te = world.getTileEntity(cc.posX, cc.posY, cc.posZ);
            if (te == null || !(te instanceof TileEldritchCrabSpawner)) continue;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!world.isAirBlock(cc.posX + dir.offsetX, cc.posY + dir.offsetY, cc.posZ + dir.offsetZ)) continue;
                ((TileEldritchCrabSpawner)te).setFacing((byte)dir.ordinal());
                continue block3;
            }
        }
        decoCommon.clear();
        crabSpawner.clear();
        decoUrn.clear();
    }

    static boolean isBedrockShowing(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (world.getBlock(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isOpaqueCube() || world.getBlock(x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ) != Blocks.bedrock && world.getBlock(x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ) != ConfigBlocks.blockEldritchNothing) continue;
            return true;
        }
        return false;
    }

    static void generateConnections(World world, Random random, int cx, int cz, int y, Cell cell, int depth, boolean justthetip) {
        int h;
        int w;
        int d;
        int x = cx * 16;
        int z = cz * 16;
        if (cell.north) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n2 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 3 + w, y + 10 - h, z + d, PAT_CONNECT[h][w], ForgeDirection.NORTH, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.south) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n3 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 3 + w, y + 10 - h, z + 16 - d, PAT_CONNECT[h][w], ForgeDirection.SOUTH, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.east) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n4 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + 16 - d, y + 10 - h, z + 3 + w, PAT_CONNECT[h][w], ForgeDirection.EAST, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
        if (cell.west) {
            for (d = 0; d <= depth; ++d) {
                int n = d == depth && justthetip ? 2 : (w = d == depth - 1 && justthetip ? 1 : 0);
                while (w < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                    int n5 = d == depth && justthetip ? 2 : (h = d == depth - 1 && justthetip ? 1 : 0);
                    while (h < (d == depth && justthetip ? 9 : (d == depth - 1 && justthetip ? 10 : 11))) {
                        if (d != depth || !justthetip || PAT_CONNECT[h][w] != 8) {
                            GenCommon.placeBlock(world, x + d, y + 10 - h, z + 3 + w, PAT_CONNECT[h][w], ForgeDirection.WEST, cell);
                        }
                        ++h;
                    }
                    ++w;
                }
            }
        }
    }
}

