/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.Utils;

public class ThaumcraftCraftingManager {
    public static ShapedRecipes createFakeRecipe(ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        int var9;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])par2ArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).copy() : null;
        }
        return new ShapedRecipes(var5, var6, var15, par1ItemStack);
    }

    public static CrucibleRecipe findMatchingCrucibleRecipe(String username, AspectList aspects, ItemStack lastDrop) {
        int highest = 0;
        int index = -1;
        for (int a = 0; a < ThaumcraftApi.getCraftingRecipes().size(); ++a) {
            int result;
            if (!(ThaumcraftApi.getCraftingRecipes().get(a) instanceof CrucibleRecipe)) continue;
            CrucibleRecipe recipe = (CrucibleRecipe)ThaumcraftApi.getCraftingRecipes().get(a);
            ItemStack temp = lastDrop.copy();
            temp.stackSize = 1;
            if (!ResearchManager.isResearchComplete(username, recipe.key) || !recipe.matches(aspects, temp) || (result = recipe.aspects.size()) <= highest) continue;
            highest = result;
            index = a;
        }
        if (index < 0) {
            return null;
        }
        AspectList output = new AspectList();
        return (CrucibleRecipe)ThaumcraftApi.getCraftingRecipes().get(index);
    }

    public static ItemStack findMatchingArcaneRecipe(IInventory awb, EntityPlayer player) {
        int var2 = 0;
        ItemStack var3 = null;
        ItemStack var4 = null;
        for (int var5 = 0; var5 < 9; ++var5) {
            ItemStack var6 = awb.getStackInSlot(var5);
            if (var6 == null) continue;
            if (var2 == 0) {
                var3 = var6;
            }
            if (var2 == 1) {
                var4 = var6;
            }
            ++var2;
        }
        IArcaneRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof IArcaneRecipe) || !((IArcaneRecipe)var11).matches(awb, player.worldObj, player)) continue;
            var13 = (IArcaneRecipe)var11;
            break;
        }
        return var13 == null ? null : var13.getCraftingResult(awb);
    }

    public static AspectList findMatchingArcaneRecipeAspects(IInventory awb, EntityPlayer player) {
        int var2 = 0;
        ItemStack var3 = null;
        ItemStack var4 = null;
        for (int var5 = 0; var5 < 9; ++var5) {
            ItemStack var6 = awb.getStackInSlot(var5);
            if (var6 == null) continue;
            if (var2 == 0) {
                var3 = var6;
            }
            if (var2 == 1) {
                var4 = var6;
            }
            ++var2;
        }
        IArcaneRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof IArcaneRecipe) || !((IArcaneRecipe)var11).matches(awb, player.worldObj, player)) continue;
            var13 = (IArcaneRecipe)var11;
            break;
        }
        return var13 == null ? new AspectList() : (var13.getAspects() != null ? var13.getAspects() : var13.getAspects(awb));
    }

    public static InfusionRecipe findMatchingInfusionRecipe(ArrayList<ItemStack> items, ItemStack input, EntityPlayer player) {
        InfusionRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof InfusionRecipe) || !((InfusionRecipe)var11).matches(items, input, player.worldObj, player)) continue;
            var13 = (InfusionRecipe)var11;
            break;
        }
        return var13;
    }

    public static InfusionEnchantmentRecipe findMatchingInfusionEnchantmentRecipe(ArrayList<ItemStack> items, ItemStack input, EntityPlayer player) {
        InfusionEnchantmentRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof InfusionEnchantmentRecipe) || !((InfusionEnchantmentRecipe)var11).matches(items, input, player.worldObj, player)) continue;
            var13 = (InfusionEnchantmentRecipe)var11;
            break;
        }
        return var13;
    }

    public static AspectList getObjectTags(ItemStack itemstack) {
        int meta;
        Item item;
        try {
            item = itemstack.getItem();
            meta = itemstack.getItemDamage();
        }
        catch (Exception e) {
            return null;
        }
        AspectList tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, meta));
        if (tmp == null) {
            Set col = ThaumcraftApi.objectTags.keySet();
            for (List l : col) {
                if ((Item)l.get(0) != item || !(l.get(1) instanceof int[])) continue;
                int[] range = (int[])l.get(1);
                Arrays.sort(range);
                if (Arrays.binarySearch(range, meta) < 0) continue;
                tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, range));
                return tmp;
            }
            tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, Short.MAX_VALUE));
            if (tmp == null && tmp == null) {
                if (meta == Short.MAX_VALUE && tmp == null) {
                    int index = 0;
                    do {
                        tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, index));
                    } while (++index < 16 && tmp == null);
                }
                if (tmp == null) {
                    tmp = ThaumcraftCraftingManager.generateTags(item, meta);
                }
            }
        }
        if (itemstack.getItem() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)itemstack.getItem();
            if (tmp == null) {
                tmp = new AspectList();
            }
            tmp.merge(Aspect.MAGIC, (wand.getRod(itemstack).getCraftCost() + wand.getCap(itemstack).getCraftCost()) / 2);
            tmp.merge(Aspect.TOOL, (wand.getRod(itemstack).getCraftCost() + wand.getCap(itemstack).getCraftCost()) / 3);
        }
        if (item != null && item == Items.potionitem) {
            if (tmp == null) {
                tmp = new AspectList();
            }
            tmp.merge(Aspect.WATER, 1);
            ItemPotion ip = (ItemPotion)item;
            List effects = ip.getEffects(itemstack.getItemDamage());
            if (effects != null) {
                if (ItemPotion.isSplash((int)itemstack.getItemDamage())) {
                    tmp.merge(Aspect.ENTROPY, 2);
                }
                for (PotionEffect var6 : effects) {
                    tmp.merge(Aspect.MAGIC, (var6.getAmplifier() + 1) * 2);
                    if (var6.getPotionID() == Potion.blindness.id) {
                        tmp.merge(Aspect.DARKNESS, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.confusion.id) {
                        tmp.merge(Aspect.ELDRITCH, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.damageBoost.id) {
                        tmp.merge(Aspect.WEAPON, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.digSlowdown.id) {
                        tmp.merge(Aspect.TRAP, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.digSpeed.id) {
                        tmp.merge(Aspect.TOOL, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.fireResistance.id) {
                        tmp.merge(Aspect.ARMOR, var6.getAmplifier() + 1);
                        tmp.merge(Aspect.FIRE, (var6.getAmplifier() + 1) * 2);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.harm.id) {
                        tmp.merge(Aspect.DEATH, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.heal.id) {
                        tmp.merge(Aspect.HEAL, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.hunger.id) {
                        tmp.merge(Aspect.DEATH, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.invisibility.id) {
                        tmp.merge(Aspect.SENSES, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.jump.id) {
                        tmp.merge(Aspect.FLIGHT, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.moveSlowdown.id) {
                        tmp.merge(Aspect.TRAP, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.moveSpeed.id) {
                        tmp.merge(Aspect.MOTION, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.nightVision.id) {
                        tmp.merge(Aspect.SENSES, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.poison.id) {
                        tmp.merge(Aspect.POISON, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.regeneration.id) {
                        tmp.merge(Aspect.HEAL, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.resistance.id) {
                        tmp.merge(Aspect.ARMOR, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() == Potion.waterBreathing.id) {
                        tmp.merge(Aspect.AIR, (var6.getAmplifier() + 1) * 3);
                        continue;
                    }
                    if (var6.getPotionID() != Potion.weakness.id) continue;
                    tmp.merge(Aspect.DEATH, (var6.getAmplifier() + 1) * 3);
                }
            }
        }
        return ThaumcraftCraftingManager.capAspects(tmp, 64);
    }

    private static AspectList capAspects(AspectList sourcetags, int amount) {
        if (sourcetags == null) {
            return sourcetags;
        }
        AspectList out = new AspectList();
        for (Aspect aspect : sourcetags.getAspects()) {
            out.merge(aspect, Math.min(amount, sourcetags.getAmount(aspect)));
        }
        return out;
    }

    public static AspectList getBonusTags(ItemStack itemstack, AspectList sourcetags) {
        AspectList tmp = new AspectList();
        Item item = itemstack.getItem();
        if (item != null && item instanceof IEssentiaContainerItem && (tmp = ((IEssentiaContainerItem)item).getAspects(itemstack)) != null && tmp.size() > 0) {
            for (Aspect tag : tmp.copy().getAspects()) {
                if (tmp.getAmount(tag) > 0) continue;
                tmp.remove(tag);
            }
        }
        if (tmp == null) {
            tmp = new AspectList();
        }
        if (sourcetags != null) {
            for (Aspect tag : sourcetags.getAspects()) {
                if (tag == null) continue;
                tmp.add(tag, sourcetags.getAmount(tag));
            }
        }
        int id = Item.getIdFromItem((Item)itemstack.getItem());
        int meta = itemstack.getItemDamage();
        if (item != null && (tmp != null || item == Items.potionitem)) {
            if (item instanceof ItemArmor) {
                tmp.merge(Aspect.ARMOR, ((ItemArmor)item).damageReduceAmount);
            } else if (item instanceof ItemSword && ((ItemSword)item).func_150931_i() + 1.0f > 0.0f) {
                tmp.merge(Aspect.WEAPON, (int)(((ItemSword)item).func_150931_i() + 1.0f));
            } else if (item instanceof ItemBow) {
                tmp.merge(Aspect.WEAPON, 3).merge(Aspect.FLIGHT, 1);
            } else if (item instanceof ItemPickaxe) {
                String mat = ((ItemTool)item).getToolMaterialName();
                for (Item.ToolMaterial tm : Item.ToolMaterial.values()) {
                    if (!tm.toString().equals(mat)) continue;
                    tmp.merge(Aspect.MINE, tm.getHarvestLevel() + 1);
                }
            } else if (item instanceof ItemTool) {
                String mat = ((ItemTool)item).getToolMaterialName();
                for (Item.ToolMaterial tm : Item.ToolMaterial.values()) {
                    if (!tm.toString().equals(mat)) continue;
                    tmp.merge(Aspect.TOOL, tm.getHarvestLevel() + 1);
                }
            } else if (item instanceof ItemShears || item instanceof ItemHoe) {
                if (item.getMaxDamage() <= Item.ToolMaterial.WOOD.getMaxUses()) {
                    tmp.merge(Aspect.HARVEST, 1);
                } else if (item.getMaxDamage() <= Item.ToolMaterial.STONE.getMaxUses() || item.getMaxDamage() <= Item.ToolMaterial.GOLD.getMaxUses()) {
                    tmp.merge(Aspect.HARVEST, 2);
                } else if (item.getMaxDamage() <= Item.ToolMaterial.IRON.getMaxUses()) {
                    tmp.merge(Aspect.HARVEST, 3);
                } else {
                    tmp.merge(Aspect.HARVEST, 4);
                }
            }
            NBTTagList ench = itemstack.getEnchantmentTagList();
            if (item instanceof ItemEnchantedBook) {
                ench = ((ItemEnchantedBook)item).func_92110_g(itemstack);
            }
            if (ench != null) {
                int var5 = 0;
                for (int var3 = 0; var3 < ench.tagCount(); ++var3) {
                    short eid = ench.getCompoundTagAt(var3).getShort("id");
                    short lvl = ench.getCompoundTagAt(var3).getShort("lvl");
                    if (eid == Enchantment.aquaAffinity.effectId) {
                        tmp.merge(Aspect.WATER, lvl);
                    } else if (eid == Enchantment.baneOfArthropods.effectId) {
                        tmp.merge(Aspect.BEAST, lvl);
                    } else if (eid == Enchantment.blastProtection.effectId) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.efficiency.effectId) {
                        tmp.merge(Aspect.TOOL, lvl);
                    } else if (eid == Enchantment.featherFalling.effectId) {
                        tmp.merge(Aspect.FLIGHT, lvl);
                    } else if (eid == Enchantment.fireAspect.effectId) {
                        tmp.merge(Aspect.FIRE, lvl);
                    } else if (eid == Enchantment.fireProtection.effectId) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.flame.effectId) {
                        tmp.merge(Aspect.FIRE, lvl);
                    } else if (eid == Enchantment.fortune.effectId) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.infinity.effectId) {
                        tmp.merge(Aspect.CRAFT, lvl);
                    } else if (eid == Enchantment.knockback.effectId) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.looting.effectId) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.power.effectId) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.projectileProtection.effectId) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.protection.effectId) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.punch.effectId) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.respiration.effectId) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.sharpness.effectId) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.silkTouch.effectId) {
                        tmp.merge(Aspect.EXCHANGE, lvl);
                    } else if (eid == Enchantment.thorns.effectId) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.smite.effectId) {
                        tmp.merge(Aspect.ENTROPY, lvl);
                    } else if (eid == Enchantment.unbreaking.effectId) {
                        tmp.merge(Aspect.EARTH, lvl);
                    } else if (eid == Enchantment.field_151370_z.effectId) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.field_151369_A.effectId) {
                        tmp.merge(Aspect.BEAST, lvl);
                    } else if (eid == Config.enchHaste.effectId) {
                        tmp.merge(Aspect.MOTION, lvl);
                    } else if (eid == Config.enchRepair.effectId) {
                        tmp.merge(Aspect.TOOL, lvl);
                    }
                    var5 += lvl;
                }
                if (var5 > 0) {
                    tmp.merge(Aspect.MAGIC, var5);
                }
            }
        }
        return ThaumcraftApiHelper.cullTags(tmp);
    }

    public static AspectList generateTags(Item item, int meta) {
        AspectList temp = ThaumcraftCraftingManager.generateTags(item, meta, new ArrayList<List>());
        return temp;
    }

    public static AspectList generateTags(Item item, int meta, ArrayList<List> history) {
        int tmeta = meta;
        try {
            tmeta = new ItemStack(item, 1, meta).getItem().isDamageable() || !new ItemStack(item, 1, meta).getItem().getHasSubtypes() ? Short.MAX_VALUE : meta;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ThaumcraftApi.exists(item, tmeta)) {
            return ThaumcraftCraftingManager.getObjectTags(new ItemStack(item, 1, tmeta));
        }
        if (history.contains(Arrays.asList(item, tmeta))) {
            return null;
        }
        history.add(Arrays.asList(item, tmeta));
        if (history.size() >= 100) {
            return null;
        }
        AspectList ret = ThaumcraftCraftingManager.generateTagsFromRecipes(item, tmeta == Short.MAX_VALUE ? 0 : meta, history);
        ret = ThaumcraftCraftingManager.capAspects(ret, 64);
        ThaumcraftApi.registerObjectTag(new ItemStack(item, 1, tmeta), ret);
        return ret;
    }

    private static AspectList generateTagsFromCrucibleRecipes(Item item, int meta, ArrayList<List> history) {
        CrucibleRecipe cr = ThaumcraftApi.getCrucibleRecipe(new ItemStack(item, 1, meta));
        if (cr != null) {
            AspectList ot = cr.aspects.copy();
            int ss = cr.getRecipeOutput().stackSize;
            ItemStack cat = null;
            if (cr.catalyst instanceof ItemStack) {
                cat = (ItemStack)cr.catalyst;
            } else if (cr.catalyst instanceof ArrayList && ((ArrayList)cr.catalyst).size() > 0) {
                cat = (ItemStack)((ArrayList)cr.catalyst).get(0);
            }
            AspectList ot2 = ThaumcraftCraftingManager.generateTags(cat.getItem(), cat.getItemDamage());
            AspectList out = new AspectList();
            if (ot2 != null && ot2.size() > 0) {
                for (Aspect tt : ot2.getAspects()) {
                    out.add(tt, ot2.getAmount(tt));
                }
            }
            for (Aspect tt : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)ss);
                out.add(tt, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    private static AspectList generateTagsFromArcaneRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        boolean value = false;
        List recipeList = ThaumcraftApi.getCraftingRecipes();
        block2: for (int q = 0; q < recipeList.size(); ++q) {
            int idS;
            IArcaneRecipe recipe;
            if (!(recipeList.get(q) instanceof IArcaneRecipe) || (recipe = (IArcaneRecipe)recipeList.get(q)).getRecipeOutput() == null) continue;
            int idR = recipe.getRecipeOutput().getItemDamage() == Short.MAX_VALUE ? 0 : recipe.getRecipeOutput().getItemDamage();
            int n = idS = meta < 0 ? 0 : meta;
            if (recipe.getRecipeOutput().getItem() != item || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            AspectList ph = new AspectList();
            boolean cval = false;
            try {
                if (recipeList.get(q) instanceof ShapedArcaneRecipe) {
                    int width = ((ShapedArcaneRecipe)recipeList.get((int)q)).width;
                    int height = ((ShapedArcaneRecipe)recipeList.get((int)q)).height;
                    Object[] items = ((ShapedArcaneRecipe)recipeList.get(q)).getInput();
                    for (int i = 0; i < width && i < 3; ++i) {
                        block4: for (int j = 0; j < height && j < 3; ++j) {
                            if (items[i + j * width] == null) continue;
                            if (items[i + j * width] instanceof ArrayList) {
                                for (ItemStack it : (ArrayList)items[i + j * width]) {
                                    if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                                    AspectList obj = ThaumcraftCraftingManager.generateTags(it.getItem(), it.getItemDamage(), history);
                                    if (obj == null || obj.size() <= 0) continue;
                                    ItemStack is = it.copy();
                                    is.stackSize = 1;
                                    ingredients.add(is);
                                    continue block4;
                                }
                                continue;
                            }
                            ItemStack it = (ItemStack)items[i + j * width];
                            if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                            ItemStack is = it.copy();
                            is.stackSize = 1;
                            ingredients.add(is);
                        }
                    }
                } else if (recipeList.get(q) instanceof ShapelessArcaneRecipe) {
                    ArrayList items = ((ShapelessArcaneRecipe)recipeList.get(q)).getInput();
                    block6: for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (items.get(i) instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items.get(i)) {
                                if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(it.getItem(), it.getItemDamage(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is = it.copy();
                                is.stackSize = 1;
                                ingredients.add(is);
                                continue block6;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items.get(i);
                        if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                        ItemStack is = it.copy();
                        is.stackSize = 1;
                        ingredients.add(is);
                    }
                }
                ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipe.getRecipeOutput(), history);
                if (recipe.getAspects() != null) {
                    for (Aspect a : recipe.getAspects().getAspects()) {
                        ph.add(a, (int)(Math.sqrt(recipe.getAspects().getAmount(a)) / (double)recipe.getRecipeOutput().stackSize));
                    }
                }
                for (Aspect as : ph.copy().getAspects()) {
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                if (cval < value) continue;
                ret = ph;
                value = cval;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static AspectList generateTagsFromInfusionRecipes(Item item, int meta, ArrayList<List> history) {
        InfusionRecipe cr = ThaumcraftApi.getInfusionRecipe(new ItemStack(item, 1, meta));
        if (cr != null) {
            AspectList ot = cr.getAspects().copy();
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            ItemStack is = cr.getRecipeInput().copy();
            is.stackSize = 1;
            ingredients.add(is);
            for (ItemStack cat : cr.getComponents()) {
                ItemStack is2 = cat.copy();
                is2.stackSize = 1;
                ingredients.add(is2);
            }
            AspectList out = new AspectList();
            AspectList ot2 = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, (ItemStack)cr.getRecipeOutput(), history);
            for (Aspect tt : ot2.getAspects()) {
                out.add(tt, ot2.getAmount(tt));
            }
            for (Aspect tt : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)((ItemStack)cr.getRecipeOutput()).stackSize);
                out.add(tt, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    private static AspectList generateTagsFromCraftingRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        int value = Integer.MAX_VALUE;
        List recipeList = CraftingManager.getInstance().getRecipeList();
        block2: for (int q = 0; q < recipeList.size(); ++q) {
            int idS;
            IRecipe recipe = (IRecipe)recipeList.get(q);
            if (recipe == null || recipe.getRecipeOutput() == null || Item.getIdFromItem((Item)recipe.getRecipeOutput().getItem()) <= 0 || recipe.getRecipeOutput().getItem() == null) continue;
            int idR = recipe.getRecipeOutput().getItemDamage() == Short.MAX_VALUE ? 0 : recipe.getRecipeOutput().getItemDamage();
            int n = idS = meta == Short.MAX_VALUE ? 0 : meta;
            if (recipe.getRecipeOutput().getItem() != item || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            AspectList ph = new AspectList();
            boolean cval = false;
            try {
                ItemStack is;
                if (recipeList.get(q) instanceof ShapedRecipes) {
                    int width = ((ShapedRecipes)recipeList.get((int)q)).recipeWidth;
                    int height = ((ShapedRecipes)recipeList.get((int)q)).recipeHeight;
                    ItemStack[] items = ((ShapedRecipes)recipeList.get((int)q)).recipeItems;
                    for (int i = 0; i < width && i < 3; ++i) {
                        for (int j = 0; j < height && j < 3; ++j) {
                            if (items[i + j * width] == null) continue;
                            if (Utils.isEETransmutionItem(items[i + j * width].getItem())) continue block2;
                            is = items[i + j * width].copy();
                            is.stackSize = 1;
                            ingredients.add(is);
                        }
                    }
                } else if (recipeList.get(q) instanceof ShapelessRecipes) {
                    List items = ((ShapelessRecipes)recipeList.get((int)q)).recipeItems;
                    for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (Utils.isEETransmutionItem(((ItemStack)items.get(i)).getItem())) continue block2;
                        ItemStack is2 = ((ItemStack)items.get(i)).copy();
                        is2.stackSize = 1;
                        ingredients.add(is2);
                    }
                } else if (recipeList.get(q) instanceof ShapedOreRecipe) {
                    int size = ((ShapedOreRecipe)recipeList.get(q)).getRecipeSize();
                    Object[] items = ((ShapedOreRecipe)recipeList.get(q)).getInput();
                    block6: for (int i = 0; i < size && i < 9; ++i) {
                        if (items[i] == null) continue;
                        if (items[i] instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items[i]) {
                                if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(it.getItem(), it.getItemDamage(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is3 = it.copy();
                                is3.stackSize = 1;
                                ingredients.add(is3);
                                continue block6;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items[i];
                        if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                        ItemStack is4 = it.copy();
                        is4.stackSize = 1;
                        ingredients.add(is4);
                    }
                } else if (recipeList.get(q) instanceof ShapelessOreRecipe) {
                    ArrayList items = ((ShapelessOreRecipe)recipeList.get(q)).getInput();
                    block8: for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (items.get(i) instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items.get(i)) {
                                if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(it.getItem(), it.getItemDamage(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                is = it.copy();
                                is.stackSize = 1;
                                ingredients.add(is);
                                continue block8;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items.get(i);
                        if (Utils.isEETransmutionItem(it.getItem())) continue block2;
                        ItemStack is5 = it.copy();
                        is5.stackSize = 1;
                        ingredients.add(is5);
                    }
                }
                ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipe.getRecipeOutput(), history);
                for (Aspect as : ph.copy().getAspects()) {
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                if (ph.visSize() >= value || ph.visSize() <= 0) continue;
                ret = ph;
                value = ph.visSize();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static AspectList getAspectsFromIngredients(ArrayList<ItemStack> ingredients, ItemStack recipeOut, ArrayList<List> history) {
        AspectList out = new AspectList();
        AspectList mid = new AspectList();
        for (ItemStack is : ingredients) {
            AspectList obj = ThaumcraftCraftingManager.generateTags(is.getItem(), is.getItemDamage(), history);
            if (is.getItem().getContainerItem() != null) {
                if (is.getItem().getContainerItem() == is.getItem()) continue;
                AspectList objC = ThaumcraftCraftingManager.generateTags(is.getItem().getContainerItem(), Short.MAX_VALUE, history);
                for (Aspect as : objC.getAspects()) {
                    out.reduce(as, objC.getAmount(as));
                }
            }
            if (obj == null) continue;
            for (Aspect as : obj.getAspects()) {
                if (as == null) continue;
                mid.add(as, obj.getAmount(as));
            }
        }
        for (Aspect as : mid.getAspects()) {
            if (as == null) continue;
            out.add(as, (int)((float)mid.getAmount(as) * 0.75f / (float)recipeOut.stackSize));
        }
        for (Aspect as : out.getAspects()) {
            if (out.getAmount(as) > 0) continue;
            out.remove(as);
        }
        return out;
    }

    private static AspectList generateTagsFromRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        boolean value = false;
        ret = ThaumcraftCraftingManager.generateTagsFromCrucibleRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromArcaneRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromInfusionRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromCraftingRecipes(item, meta, history);
        return ret;
    }
}

