/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessNBTOreRecipe
extends ShapelessOreRecipe {
    private ItemStack output = null;
    private ArrayList input = new ArrayList();

    public ShapelessNBTOreRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessNBTOreRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessNBTOreRecipe(ItemStack result, Object ... recipe) {
        super(result, recipe);
        this.output = result.copy();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).copy());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public ItemStack getCraftingResult(InventoryCrafting var1) {
        return this.output.copy();
    }

    public boolean matches(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.getSizeInventory(); ++x) {
            ItemStack slot = var1.getStackInSlot(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = this.checkItemEquals((ItemStack)next, slot);
                } else if (next instanceof ArrayList) {
                    for (ItemStack item : (ArrayList)next) {
                        match = match || this.checkItemEquals(item, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.getItem() == input.getItem() && ItemStack.areItemStackTagsEqual((ItemStack)target, (ItemStack)input) && (target.getItemDamage() == Short.MAX_VALUE || target.getItemDamage() == input.getItemDamage());
    }

    public ArrayList getInput() {
        return this.input;
    }
}

