/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileHole;

public class ItemFocusPortableHole
extends ItemFocusBasic {
    IIcon depthIcon = null;
    private static final AspectList cost = new AspectList().add(Aspect.ENTROPY, 10).add(Aspect.AIR, 10);

    public ItemFocusPortableHole() {
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "BPH" + super.getSortingHelper(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.depthIcon = ir.registerIcon("thaumcraft:focus_portablehole_depth");
        this.icon = ir.registerIcon("thaumcraft:focus_portablehole");
    }

    @Override
    public IIcon getFocusDepthLayerIcon(ItemStack itemstack) {
        return this.depthIcon;
    }

    @Override
    public int getFocusColor(ItemStack itemstack) {
        return 594985;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return cost.copy();
    }

    public static boolean createHole(World world, int ii, int jj, int kk, int side, byte count, int max) {
        Block bi = world.getBlock(ii, jj, kk);
        if (!(world.getTileEntity(ii, jj, kk) != null || ThaumcraftApi.portableHoleBlackList.contains(bi) || bi == Blocks.bedrock || bi == ConfigBlocks.blockHole || bi.isAir((IBlockAccess)world, ii, jj, kk) || bi.canPlaceBlockAt(world, ii, jj, kk) || bi.getBlockHardness(world, ii, jj, kk) == -1.0f)) {
            TileHole ts = new TileHole(bi, world.getBlockMetadata(ii, jj, kk), (short)max, count, (byte)side, null);
            world.setBlock(ii, jj, kk, Blocks.air, 0, 0);
            if (world.setBlock(ii, jj, kk, ConfigBlocks.blockHole, 0, 0)) {
                world.setTileEntity(ii, jj, kk, (TileEntity)ts);
            }
            world.markBlockForUpdate(ii, jj, kk);
            Thaumcraft.proxy.blockSparkle(world, ii, jj, kk, 0x400040, 1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.getItem();
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block bi;
            if (world.provider.dimensionId == Config.dimensionOuterId) {
                if (!world.isRemote) {
                    world.playSoundEffect((double)mop.blockX + 0.5, (double)mop.blockY + 0.5, (double)mop.blockZ + 0.5, "thaumcraft:wandfail", 1.0f, 1.0f);
                }
                player.swingItem();
                return itemstack;
            }
            int ii = mop.blockX;
            int jj = mop.blockY;
            int kk = mop.blockZ;
            int enlarge = wand.getFocusEnlarge(itemstack);
            int distance = 0;
            int maxdis = 33 + enlarge * 8;
            block8: for (distance = 0; distance < maxdis && !ThaumcraftApi.portableHoleBlackList.contains(bi = world.getBlock(ii, jj, kk)) && bi != Blocks.bedrock && bi != ConfigBlocks.blockHole && !bi.isAir((IBlockAccess)world, ii, jj, kk) && bi.getBlockHardness(world, ii, jj, kk) != -1.0f; ++distance) {
                switch (mop.sideHit) {
                    case 0: {
                        ++jj;
                        continue block8;
                    }
                    case 1: {
                        --jj;
                        continue block8;
                    }
                    case 2: {
                        ++kk;
                        continue block8;
                    }
                    case 3: {
                        --kk;
                        continue block8;
                    }
                    case 4: {
                        ++ii;
                        continue block8;
                    }
                    case 5: {
                        --ii;
                    }
                }
            }
            AspectList c = this.getVisCost(itemstack);
            for (Aspect a : c.getAspects()) {
                c.merge(a, c.getAmount(a) * distance);
            }
            if (wand.consumeAllVis(itemstack, player, c, true, false)) {
                int di = this.getUpgradeLevel(wand.getFocusItem(itemstack), FocusUpgradeType.extend);
                short dur = (short)(120 + 60 * di);
                ItemFocusPortableHole.createHole(world, mop.blockX, mop.blockY, mop.blockZ, mop.sideHit, (byte)(distance + 1), dur);
            }
            player.swingItem();
            if (!world.isRemote) {
                world.playSoundEffect((double)mop.blockX + 0.5, (double)mop.blockY + 0.5, (double)mop.blockZ + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
        return itemstack;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
        }
        return null;
    }
}

