/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.equipment;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import thaumcraft.api.IRepairable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.utils.Utils;

public class ItemElementalSword
extends ItemSword
implements IRepairable {
    public IIcon icon;

    public ItemElementalSword(Item.ToolMaterial enumtoolmaterial) {
        super(enumtoolmaterial);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:elementalsword");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.isItemEqual(new ItemStack(ConfigItems.itemResource, 1, 2)) ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        List targets;
        super.onUsingTick(stack, player, count);
        int ticks = this.getMaxItemUseDuration(stack) - count;
        if (player.motionY < 0.0) {
            player.motionY /= (double)1.2f;
            player.fallDistance /= 1.2f;
        }
        player.motionY += (double)0.08f;
        if (player.motionY > 0.5) {
            player.motionY = 0.2f;
        }
        if (player instanceof EntityPlayerMP) {
            Utils.resetFloatCounter((EntityPlayerMP)player);
        }
        if ((targets = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, player.boundingBox.expand(2.5, 2.5, 2.5))).size() > 0) {
            for (int var9 = 0; var9 < targets.size(); ++var9) {
                Entity entity = (Entity)targets.get(var9);
                if (entity instanceof EntityPlayer || entity.isDead || player.ridingEntity != null && player.ridingEntity == entity) continue;
                Vec3 p = Vec3.createVectorHelper((double)player.posX, (double)player.posY, (double)player.posZ);
                Vec3 t = Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ);
                double distance = p.distanceTo(t) + 0.1;
                Vec3 r = Vec3.createVectorHelper((double)(t.xCoord - p.xCoord), (double)(t.yCoord - p.yCoord), (double)(t.zCoord - p.zCoord));
                entity.motionX += r.xCoord / 2.5 / distance;
                entity.motionY += r.yCoord / 2.5 / distance;
                entity.motionZ += r.zCoord / 2.5 / distance;
            }
        }
        if (player.worldObj.isRemote) {
            int miny = (int)(player.boundingBox.minY - 2.0);
            if (player.onGround) {
                miny = MathHelper.floor_double((double)player.boundingBox.minY);
            }
            for (int a = 0; a < 5; ++a) {
                Thaumcraft.proxy.smokeSpiral(player.worldObj, player.posX, player.boundingBox.minY + (double)(player.height / 2.0f), player.posZ, 1.5f, player.worldObj.rand.nextInt(360), miny, 0xDDDDDD);
            }
            if (player.onGround) {
                float r1 = player.worldObj.rand.nextFloat() * 360.0f;
                float mx = -MathHelper.sin((float)(r1 / 180.0f * (float)Math.PI)) / 5.0f;
                float mz = MathHelper.cos((float)(r1 / 180.0f * (float)Math.PI)) / 5.0f;
                player.worldObj.spawnParticle("smoke", player.posX, player.boundingBox.minY + (double)0.1f, player.posZ, (double)mx, 0.0, (double)mz);
            }
        } else if (ticks == 0 || ticks % 20 == 0) {
            player.worldObj.playSoundAtEntity((Entity)player, "thaumcraft:wind", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f);
        }
        if (ticks % 20 == 0) {
            stack.damageItem(1, (EntityLivingBase)player);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity.isEntityAlive()) {
            List targets = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, entity.boundingBox.expand(1.2, 1.1, 1.2));
            int count = 0;
            if (targets.size() > 1) {
                for (int var9 = 0; var9 < targets.size(); ++var9) {
                    Entity var10 = (Entity)targets.get(var9);
                    if (var10.isDead || var10 instanceof EntityGolemBase && ((EntityGolemBase)var10).getOwnerName().equals(player.getCommandSenderName()) || var10 instanceof EntityTameable && ((EntityTameable)var10).func_152113_b().equals(player.getCommandSenderName()) || !(var10 instanceof EntityLiving) || var10.getEntityId() == entity.getEntityId() || var10 instanceof EntityPlayer && ((EntityPlayer)var10).getCommandSenderName() == player.getCommandSenderName() || !var10.isEntityAlive()) continue;
                    this.attackTargetEntityWithCurrentItem(var10, player);
                    ++count;
                }
                if (count > 0 && !player.worldObj.isRemote) {
                    player.worldObj.playSoundAtEntity(entity, "thaumcraft:swing", 1.0f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f);
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity, EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, par1Entity))) {
            return;
        }
        if (par1Entity.canAttackWithItem() && !par1Entity.hitByEntity((Entity)player)) {
            float f = (float)player.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
            int i = 0;
            float f1 = 0.0f;
            if (par1Entity instanceof EntityLivingBase) {
                f1 = EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
                i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (player.isSprinting()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                IEntityMultiPart ientitymultipart;
                boolean flag2;
                boolean flag;
                boolean bl = flag = player.fallDistance > 0.0f && !player.onGround && !player.isOnLadder() && !player.isInWater() && !player.isPotionActive(Potion.blindness) && player.ridingEntity == null && par1Entity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)player);
                if (par1Entity instanceof EntityLivingBase && j > 0 && !par1Entity.isBurning()) {
                    flag1 = true;
                    par1Entity.setFire(1);
                }
                if (flag2 = par1Entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)player), f)) {
                    if (i > 0) {
                        par1Entity.addVelocity((double)(-MathHelper.sin((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.motionX *= 0.6;
                        player.motionZ *= 0.6;
                        player.setSprinting(false);
                    }
                    if (flag) {
                        player.onCriticalHit(par1Entity);
                    }
                    if (f1 > 0.0f) {
                        player.onEnchantmentCritical(par1Entity);
                    }
                    if (f >= 18.0f) {
                        player.triggerAchievement((StatBase)AchievementList.overkill);
                    }
                    player.setLastAttacker(par1Entity);
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)player);
                    }
                }
                ItemStack itemstack = player.getCurrentEquippedItem();
                Entity object = par1Entity;
                if (par1Entity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)par1Entity).entityDragonObj) != null && ientitymultipart instanceof EntityLivingBase) {
                    object = (EntityLivingBase)ientitymultipart;
                }
                if (itemstack != null && object instanceof EntityLivingBase) {
                    itemstack.hitEntity((EntityLivingBase)object, player);
                    if (itemstack.stackSize <= 0) {
                        player.destroyCurrentEquippedItem();
                    }
                }
                if (par1Entity instanceof EntityLivingBase) {
                    player.addStat(StatList.damageDealtStat, Math.round(f * 10.0f));
                    if (j > 0 && flag2) {
                        par1Entity.setFire(j * 4);
                    } else if (flag1) {
                        par1Entity.extinguish();
                    }
                }
                player.addExhaustion(0.3f);
            }
        }
    }
}

