/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.equipment;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.BlockCoordinates;
import thaumcraft.api.IArchitect;
import thaumcraft.api.IRepairable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;

public class ItemElementalShovel
extends ItemSpade
implements IRepairable,
IArchitect {
    private static final Block[] isEffective = new Block[]{Blocks.grass, Blocks.dirt, Blocks.sand, Blocks.gravel, Blocks.snow_layer, Blocks.snow, Blocks.clay, Blocks.farmland, Blocks.soul_sand, Blocks.mycelium};
    public IIcon icon;
    int side = 0;

    public ItemElementalShovel(Item.ToolMaterial enumtoolmaterial) {
        super(enumtoolmaterial);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"shovel");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:elementalshovel");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.isItemEqual(new ItemStack(ConfigItems.itemResource, 1, 2)) ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int xm = ForgeDirection.getOrientation((int)side).offsetX;
        int ym = ForgeDirection.getOrientation((int)side).offsetY;
        int zm = ForgeDirection.getOrientation((int)side).offsetZ;
        Block bi = world.getBlock(x, y, z);
        int md = world.getBlockMetadata(x, y, z);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te == null) {
            for (int aa = -1; aa <= 1; ++aa) {
                for (int bb = -1; bb <= 1; ++bb) {
                    int xx = 0;
                    int yy = 0;
                    int zz = 0;
                    byte o = ItemElementalShovel.getOrientation(itemstack);
                    if (o == 1) {
                        yy = bb;
                        if (side <= 1) {
                            int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                            if (l == 0 || l == 2) {
                                xx = aa;
                            } else {
                                zz = aa;
                            }
                        } else if (side <= 3) {
                            zz = aa;
                        } else {
                            xx = aa;
                        }
                    } else if (o == 2) {
                        if (side <= 1) {
                            int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                            yy = bb;
                            if (l == 0 || l == 2) {
                                xx = aa;
                            } else {
                                zz = aa;
                            }
                        } else {
                            zz = bb;
                            xx = aa;
                        }
                    } else if (side <= 1) {
                        xx = aa;
                        zz = bb;
                    } else if (side <= 3) {
                        xx = aa;
                        yy = bb;
                    } else {
                        zz = aa;
                        yy = bb;
                    }
                    Block b2 = world.getBlock(x + xx + xm, y + yy + ym, z + zz + zm);
                    if (!world.isAirBlock(x + xx + xm, y + yy + ym, z + zz + zm) && b2 != Blocks.vine && b2 != Blocks.tallgrass && b2.getMaterial() != Material.water && b2 != Blocks.deadbush && !b2.isReplaceable((IBlockAccess)world, x + xx + xm, y + yy + ym, z + zz + zm)) continue;
                    if (player.capabilities.isCreativeMode || InventoryUtils.consumeInventoryItem(player, Item.getItemFromBlock((Block)bi), md)) {
                        world.playSound((double)(x + xx + xm), (double)(y + yy + ym), (double)(z + zz + zm), bi.stepSound.func_150496_b(), 0.6f, 0.9f + world.rand.nextFloat() * 0.2f, false);
                        world.setBlock(x + xx + xm, y + yy + ym, z + zz + zm, bi, md, 3);
                        itemstack.damageItem(1, (EntityLivingBase)player);
                        Thaumcraft.proxy.blockSparkle(world, x + xx + xm, y + yy + ym, z + zz + zm, 8401408, 4);
                        player.swingItem();
                        continue;
                    }
                    if (bi != Blocks.grass || !player.capabilities.isCreativeMode && !InventoryUtils.consumeInventoryItem(player, Item.getItemFromBlock((Block)Blocks.dirt), 0)) continue;
                    world.playSound((double)(x + xx + xm), (double)(y + yy + ym), (double)(z + zz + zm), bi.stepSound.func_150496_b(), 0.6f, 0.9f + world.rand.nextFloat() * 0.2f, false);
                    world.setBlock(x + xx + xm, y + yy + ym, z + zz + zm, Blocks.dirt, 0, 3);
                    itemstack.damageItem(1, (EntityLivingBase)player);
                    Thaumcraft.proxy.blockSparkle(world, x + xx + xm, y + yy + ym, z + zz + zm, 3, 4);
                    player.swingItem();
                }
            }
        }
        return false;
    }

    private boolean isEffectiveAgainst(Block block) {
        int var3 = 0;
        while (true) {
            if (var3 >= isEffective.length) break;
            if (isEffective[var3] == block) {
                return true;
            }
            ++var3;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = BlockUtils.getTargetBlock(player.worldObj, (Entity)player, true);
        if (movingobjectposition != null && movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.side = movingobjectposition.sideHit;
        }
        return super.onBlockStartBreak(itemstack, X, Y, Z, player);
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block bi, int x, int y, int z, EntityLivingBase ent) {
        int md;
        if (ent.isSneaking()) {
            return super.onBlockDestroyed(stack, world, bi, x, y, z, ent);
        }
        if (!ent.worldObj.isRemote && (ForgeHooks.isToolEffective((ItemStack)stack, (Block)bi, (int)(md = world.getBlockMetadata(x, y, z))) || this.isEffectiveAgainst(bi))) {
            for (int aa = -1; aa <= 1; ++aa) {
                for (int bb = -1; bb <= 1; ++bb) {
                    int xx = 0;
                    int yy = 0;
                    int zz = 0;
                    if (this.side <= 1) {
                        xx = aa;
                        zz = bb;
                    } else if (this.side <= 3) {
                        xx = aa;
                        yy = bb;
                    } else {
                        zz = aa;
                        yy = bb;
                    }
                    if (ent instanceof EntityPlayer && !world.canMineBlock((EntityPlayer)ent, x + xx, y + yy, z + zz)) continue;
                    Block bl = world.getBlock(x + xx, y + yy, z + zz);
                    md = world.getBlockMetadata(x + xx, y + yy, z + zz);
                    if (!(bl.getBlockHardness(world, x + xx, y + yy, z + zz) >= 0.0f) || !ForgeHooks.isToolEffective((ItemStack)stack, (Block)bl, (int)md) && !this.isEffectiveAgainst(bl)) continue;
                    stack.damageItem(1, ent);
                    BlockUtils.harvestBlock(world, (EntityPlayer)ent, x + xx, y + yy, z + zz, true, 3);
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList<BlockCoordinates> getArchitectBlocks(ItemStack focusstack, World world, int x, int y, int z, int side, EntityPlayer player) {
        ArrayList<BlockCoordinates> b = new ArrayList<BlockCoordinates>();
        if (!player.isSneaking()) {
            return b;
        }
        int xm = ForgeDirection.getOrientation((int)side).offsetX;
        int ym = ForgeDirection.getOrientation((int)side).offsetY;
        int zm = ForgeDirection.getOrientation((int)side).offsetZ;
        for (int aa = -1; aa <= 1; ++aa) {
            for (int bb = -1; bb <= 1; ++bb) {
                int xx = 0;
                int yy = 0;
                int zz = 0;
                byte o = ItemElementalShovel.getOrientation(focusstack);
                if (o == 1) {
                    yy = bb;
                    if (side <= 1) {
                        int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                        if (l == 0 || l == 2) {
                            xx = aa;
                        } else {
                            zz = aa;
                        }
                    } else if (side <= 3) {
                        zz = aa;
                    } else {
                        xx = aa;
                    }
                } else if (o == 2) {
                    if (side <= 1) {
                        int l = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                        yy = bb;
                        if (l == 0 || l == 2) {
                            xx = aa;
                        } else {
                            zz = aa;
                        }
                    } else {
                        zz = bb;
                        xx = aa;
                    }
                } else if (side <= 1) {
                    xx = aa;
                    zz = bb;
                } else if (side <= 3) {
                    xx = aa;
                    yy = bb;
                } else {
                    zz = aa;
                    yy = bb;
                }
                Block b2 = world.getBlock(x + xx + xm, y + yy + ym, z + zz + zm);
                if (!world.isAirBlock(x + xx + xm, y + yy + ym, z + zz + zm) && b2 != Blocks.vine && b2 != Blocks.tallgrass && b2.getMaterial() != Material.water && b2 != Blocks.deadbush && !b2.isReplaceable((IBlockAccess)world, x + xx + xm, y + yy + ym, z + zz + zm)) continue;
                b.add(new BlockCoordinates(x + xx + xm, y + yy + ym, z + zz + zm));
            }
        }
        return b;
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, int side, IArchitect.EnumAxis axis) {
        return false;
    }

    public static byte getOrientation(ItemStack stack) {
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("or")) {
            return stack.stackTagCompound.getByte("or");
        }
        return 0;
    }

    public static void setOrientation(ItemStack stack, byte o) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (stack.hasTagCompound()) {
            stack.stackTagCompound.setByte("or", (byte)(o % 3));
        }
    }
}

