/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.equipment;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import thaumcraft.api.IRepairable;
import thaumcraft.common.Thaumcraft;

public class ItemBowBone
extends ItemBow
implements IRepairable {
    public static final String[] bowPullIconNameArray = new String[]{"pulling_0", "pulling_1", "pulling_2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemBowBone() {
        this.maxStackSize = 1;
        this.setMaxDamage(512);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int ticks = this.getMaxItemUseDuration(stack) - count;
        if (ticks > 18) {
            player.stopUsingItem();
        }
    }

    public void onPlayerStoppedUsing(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        boolean flag;
        int j = this.getMaxItemUseDuration(par1ItemStack) - par4;
        ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, j);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        j = event.charge;
        boolean bl = flag = par3EntityPlayer.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)par1ItemStack) > 0;
        if (flag || par3EntityPlayer.inventory.hasItem(Items.arrow)) {
            int l;
            float f = (float)j / 10.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(par2World, (EntityLivingBase)par3EntityPlayer, f * 2.5f);
            entityarrow.setDamage(entityarrow.getDamage() + 0.5);
            int k = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)par1ItemStack);
            if (k > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)par1ItemStack)) > 0) {
                entityarrow.setKnockbackStrength(l);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)par1ItemStack) > 0) {
                entityarrow.setFire(100);
            }
            par1ItemStack.damageItem(1, (EntityLivingBase)par3EntityPlayer);
            par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (flag) {
                entityarrow.canBePickedUp = 2;
            } else {
                par3EntityPlayer.inventory.consumeInventoryItem(Items.arrow);
            }
            if (!par2World.isRemote) {
                par2World.spawnEntityInWorld((Entity)entityarrow);
            }
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, par1ItemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (par3EntityPlayer.capabilities.isCreativeMode || par3EntityPlayer.inventory.hasItem(Items.arrow) || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)par1ItemStack) > 0) {
            par3EntityPlayer.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        }
        return par1ItemStack;
    }

    public int getItemEnchantability() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("thaumcraft:bonebow");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = par1IconRegister.registerIcon("thaumcraft:bonebow_" + bowPullIconNameArray[i]);
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int j = stack.getMaxItemUseDuration() - useRemaining;
        if (usingItem == null) {
            return this.itemIcon;
        }
        if (j >= 13) {
            return this.getItemIconForUseDuration(2);
        }
        if (j > 7) {
            return this.getItemIconForUseDuration(1);
        }
        if (j > 0) {
            return this.getItemIconForUseDuration(0);
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int par1) {
        return this.iconArray[par1];
    }
}

