/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.projectile.EntityAlumentum;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketAspectPool;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.InventoryUtils;

public class ItemResource
extends Item
implements IEssentiaContainerItem {
    public IIcon[] icon = new IIcon[19];
    public IIcon iconOverlay;

    public ItemResource() {
        this.setMaxStackSize(64);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon[0] = ir.registerIcon("thaumcraft:alumentum");
        this.icon[1] = ir.registerIcon("thaumcraft:nitor");
        this.icon[2] = ir.registerIcon("thaumcraft:thaumiumingot");
        this.icon[3] = ir.registerIcon("thaumcraft:quicksilver");
        this.icon[4] = ir.registerIcon("thaumcraft:tallow");
        this.icon[5] = ir.registerIcon("thaumcraft:brain");
        this.icon[6] = ir.registerIcon("thaumcraft:amber");
        this.icon[7] = ir.registerIcon("thaumcraft:cloth");
        this.icon[8] = ir.registerIcon("thaumcraft:filter");
        this.icon[9] = ir.registerIcon("thaumcraft:knowledgefragment");
        this.icon[10] = ir.registerIcon("thaumcraft:mirrorglass");
        this.icon[11] = ir.registerIcon("thaumcraft:taint_slime");
        this.icon[12] = ir.registerIcon("thaumcraft:taint_tendril");
        this.icon[13] = ir.registerIcon("thaumcraft:label");
        this.iconOverlay = ir.registerIcon("thaumcraft:label_over");
        this.icon[14] = ir.registerIcon("thaumcraft:dust");
        this.icon[15] = ir.registerIcon("thaumcraft:charm");
        this.icon[16] = ir.registerIcon("thaumcraft:voidingot");
        this.icon[17] = ir.registerIcon("thaumcraft:voidseed");
        this.icon[18] = ir.registerIcon("thaumcraft:coin");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon[par1];
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return metadata == 13 ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 || this.getAspects(stack) == null ? this.getIconFromDamage(stack.getItemDamage()) : this.iconOverlay;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        if (par2 == 1 && stack.getItemDamage() == 13 && this.getAspects(stack) != null) {
            return this.getAspects(stack).getAspects()[0].getColor();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int a = 0; a <= 18; ++a) {
            if (a == 5) continue;
            par3List.add(new ItemStack((Item)this, 1, a));
        }
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return super.getUnlocalizedName() + "." + par1ItemStack.getItemDamage();
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.onUpdate(stack, world, entity, par4, par5);
        if (!(entity.worldObj.isRemote || stack.getItemDamage() != 11 && stack.getItemDamage() != 12 || !(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).isEntityUndead() || ((EntityLivingBase)entity).isPotionActive(Config.potionTaintPoisonID) || world.rand.nextInt(4321) > stack.stackSize)) {
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Config.potionTaintPoisonID, 120, 0, false));
            if (entity instanceof EntityPlayer) {
                String s = StatCollector.translateToLocal((String)"tc.taint_item_poison").replace("%s", "\u00a75\u00a7o" + stack.getDisplayName() + "\u00a7r");
                ((EntityPlayer)entity).addChatMessage((IChatComponent)new ChatComponentTranslation(s, new Object[0]));
                InventoryUtils.consumeInventoryItem((EntityPlayer)entity, stack.getItem(), stack.getItemDamage());
            }
        } else if (!entity.worldObj.isRemote && stack.getItemDamage() == 15) {
            int r = world.rand.nextInt(20000);
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("blurb")) {
                stack.stackTagCompound.removeTag("blurb");
            }
            if (r < 20) {
                Aspect aspect = null;
                switch (world.rand.nextInt(6)) {
                    case 0: {
                        aspect = Aspect.AIR;
                        break;
                    }
                    case 1: {
                        aspect = Aspect.EARTH;
                        break;
                    }
                    case 2: {
                        aspect = Aspect.FIRE;
                        break;
                    }
                    case 3: {
                        aspect = Aspect.WATER;
                        break;
                    }
                    case 4: {
                        aspect = Aspect.ORDER;
                        break;
                    }
                    case 5: {
                        aspect = Aspect.ENTROPY;
                    }
                }
                if (aspect != null) {
                    EntityAspectOrb orb = new EntityAspectOrb(world, entity.posX, entity.posY, entity.posZ, aspect, 1);
                    world.spawnEntityInWorld((Entity)orb);
                }
            } else if (r == 42 && entity instanceof EntityPlayer && !ResearchManager.isResearchComplete(((EntityPlayer)entity).getCommandSenderName(), "FOCUSPRIMAL") && !ResearchManager.isResearchComplete(((EntityPlayer)entity).getCommandSenderName(), "@FOCUSPRIMAL")) {
                ((EntityPlayer)entity).addChatMessage((IChatComponent)new ChatComponentTranslation("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.primalcharm.trigger"), new Object[0]));
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("@FOCUSPRIMAL"), (EntityPlayerMP)entity);
                Thaumcraft.proxy.getResearchManager().completeResearch((EntityPlayer)entity, "@FOCUSPRIMAL");
            }
        }
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (itemstack.getItemDamage() == 1) {
            Block var11 = world.getBlock(x, y, z);
            if (var11 == Blocks.snow_layer && (world.getBlockMetadata(x, y, z) & 7) < 1) {
                par7 = 1;
            } else if (var11 != Blocks.vine && var11 != Blocks.tallgrass && var11 != Blocks.deadbush && !var11.isReplaceable((IBlockAccess)world, x, y, z)) {
                if (par7 == 0) {
                    --y;
                }
                if (par7 == 1) {
                    ++y;
                }
                if (par7 == 2) {
                    --z;
                }
                if (par7 == 3) {
                    ++z;
                }
                if (par7 == 4) {
                    --x;
                }
                if (par7 == 5) {
                    ++x;
                }
            }
            if (itemstack.stackSize == 0) {
                return false;
            }
            if (!player.canPlayerEdit(x, y, z, par7, itemstack)) {
                return false;
            }
            if (world.canPlaceEntityOnSide(ConfigBlocks.blockAiry, x, y, z, false, par7, (Entity)player, itemstack)) {
                if (this.placeBlockAt(itemstack, player, world, x, y, z, par7, par8, par9, par10, ConfigBlocks.blockAiry, itemstack.getItemDamage())) {
                    world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ConfigBlocks.blockAiry.stepSound.getStepResourcePath(), (ConfigBlocks.blockAiry.stepSound.getVolume() + 1.0f) / 2.0f, ConfigBlocks.blockAiry.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.onItemUse(itemstack, player, world, x, y, z, par7, par8, par9, par10);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, Block bid, int metadata) {
        if (!world.setBlock(x, y, z, bid, metadata, 3)) {
            return false;
        }
        if (world.getBlock(x, y, z) == bid) {
            bid.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            bid.onPostBlockPlaced(world, x, y, z, metadata);
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer player) {
        if (itemstack.getItemDamage() == 0) {
            if (!player.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            world.playSoundAtEntity((Entity)player, "random.bow", 0.3f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)new EntityAlumentum(world, (EntityLivingBase)player));
            }
        } else if (itemstack.getItemDamage() == 9) {
            if (!player.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (!world.isRemote) {
                for (Aspect a : Aspect.getPrimalAspects()) {
                    short q = (short)(world.rand.nextInt(2) + 1);
                    Thaumcraft.proxy.playerKnowledge.addAspectPool(player.getCommandSenderName(), a, q);
                    ResearchManager.scheduleSave(player);
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketAspectPool(a.getTag(), q, Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(player.getCommandSenderName(), a)), (EntityPlayerMP)player);
                }
            }
        }
        return itemstack;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        Random rand;
        int r;
        AspectList aspects = this.getAspects(stack);
        if (aspects != null && aspects.size() > 0) {
            for (Aspect tag : aspects.getAspectsSorted()) {
                if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.getCommandSenderName(), tag)) {
                    list.add(tag.getName());
                    continue;
                }
                list.add(StatCollector.translateToLocal((String)"tc.aspect.unknown"));
            }
        }
        if (stack.getItemDamage() == 15 && (r = (rand = new Random(stack.hashCode() + player.ticksExisted / 120)).nextInt(200)) < 25) {
            list.add("\u00a76" + StatCollector.translateToLocal((String)("tc.primalcharm." + rand.nextInt(5))));
        }
        super.addInformation(stack, player, list, par4);
    }

    @Override
    public AspectList getAspects(ItemStack itemstack) {
        if (itemstack.hasTagCompound()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.getTagCompound());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    @Override
    public void setAspects(ItemStack itemstack, AspectList aspects) {
        if (!itemstack.hasTagCompound()) {
            itemstack.setTagCompound(new NBTTagCompound());
        }
        aspects.writeToNBT(itemstack.getTagCompound());
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.getItemDamage() == 15 ? 1 : super.getItemStackLimit(stack);
    }
}

