/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ResearchNoteData;

public class ItemResearchNotes
extends Item {
    @SideOnly(value=Side.CLIENT)
    public IIcon iconNote;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconNoteOver;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconDiscovery;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconDiscoveryOver;

    public ItemResearchNotes() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.iconNote = ir.registerIcon("thaumcraft:researchnotes");
        this.iconNoteOver = ir.registerIcon("thaumcraft:researchnotesoverlay");
        this.iconDiscovery = ir.registerIcon("thaumcraft:discovery");
        this.iconDiscoveryOver = ir.registerIcon("thaumcraft:discoveryoverlay");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return par1 / 64 == 0 ? this.iconNote : this.iconDiscovery;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int par1, int renderPass) {
        return renderPass == 0 ? (par1 / 64 == 0 ? this.iconNote : this.iconDiscovery) : (par1 / 64 == 0 ? this.iconNoteOver : this.iconDiscoveryOver);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            if (ResearchManager.getData(stack) != null && ResearchManager.getData(stack).isComplete() && !ResearchManager.isResearchComplete(player.getCommandSenderName(), ResearchManager.getData((ItemStack)stack).key)) {
                if (ResearchManager.doesPlayerHaveRequisites(player.getCommandSenderName(), ResearchManager.getData((ItemStack)stack).key)) {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(ResearchManager.getData((ItemStack)stack).key), (EntityPlayerMP)player);
                    Thaumcraft.proxy.getResearchManager().completeResearch(player, ResearchManager.getData((ItemStack)stack).key);
                    if (ResearchCategories.getResearch((String)ResearchManager.getData((ItemStack)stack).key).siblings != null) {
                        for (String sibling : ResearchCategories.getResearch((String)ResearchManager.getData((ItemStack)stack).key).siblings) {
                            if (ResearchManager.isResearchComplete(player.getCommandSenderName(), sibling) || !ResearchManager.doesPlayerHaveRequisites(player.getCommandSenderName(), sibling)) continue;
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(sibling), (EntityPlayerMP)player);
                            Thaumcraft.proxy.getResearchManager().completeResearch(player, sibling);
                        }
                    }
                    --stack.stackSize;
                    world.playSoundAtEntity((Entity)player, "thaumcraft:learn", 0.75f, 1.0f);
                } else {
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation(StatCollector.translateToLocal((String)"tc.researcherror"), new Object[0]));
                }
            } else if (stack.getItemDamage() == 42 || stack.getItemDamage() == 24) {
                String key = ResearchManager.findHiddenResearch(player);
                if (key.equals("FAIL")) {
                    --stack.stackSize;
                    EntityItem entityItem = new EntityItem(world, player.posX, player.posY + (double)(player.getEyeHeight() / 2.0f), player.posZ, new ItemStack(ConfigItems.itemResource, 7 + world.rand.nextInt(3), 9));
                    world.spawnEntityInWorld((Entity)entityItem);
                    world.playSoundAtEntity((Entity)player, "thaumcraft:erase", 0.75f, 1.0f);
                } else {
                    stack.setItemDamage(0);
                    stack.stackTagCompound = ResearchManager.createNote((ItemStack)stack, (String)key, (World)player.worldObj).stackTagCompound;
                    world.playSoundAtEntity((Entity)player, "thaumcraft:write", 0.75f, 1.0f);
                }
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int par2) {
        if (par2 == 1) {
            int c = 0x999999;
            ResearchNoteData rd = ResearchManager.getData(stack);
            if (rd != null) {
                c = rd.color;
            }
            return c;
        }
        return super.getColorFromItemStack(stack, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public boolean getShareTag() {
        return true;
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        String name = itemstack.getItemDamage() < 64 ? StatCollector.translateToLocal((String)"item.researchnotes.name") : StatCollector.translateToLocal((String)"item.discovery.name");
        return name;
    }

    public void addInformation(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        ResearchNoteData rd;
        if (stack.getItemDamage() == 24 || stack.getItemDamage() == 42) {
            list.add(EnumChatFormatting.GOLD + StatCollector.translateToLocal((String)"item.researchnotes.unknown.1"));
            list.add(EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"item.researchnotes.unknown.2"));
        }
        if ((rd = ResearchManager.getData(stack)) != null && rd.key != null && ResearchCategories.getResearch(rd.key) != null) {
            list.add("\u00a76" + ResearchCategories.getResearch(rd.key).getName());
            list.add("\u00a7o" + ResearchCategories.getResearch(rd.key).getText());
            int warp = ThaumcraftApi.getWarp(rd.key);
            if (warp > 0) {
                if (warp > 5) {
                    warp = 5;
                }
                String ws = StatCollector.translateToLocal((String)"tc.forbidden");
                String wr = StatCollector.translateToLocal((String)("tc.forbidden.level." + warp));
                String wte = ws.replaceAll("%n", wr);
                list.add(EnumChatFormatting.DARK_PURPLE + wte);
            }
        }
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return itemstack.getItemDamage() < 64 ? EnumRarity.rare : EnumRarity.epic;
    }
}

