/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityShockOrb
extends EntityThrowable {
    public int area = 4;
    public int damage = 5;

    public EntityShockOrb(World par1World) {
        super(par1World);
    }

    public EntityShockOrb(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote) {
            ArrayList<Entity> list = EntityUtils.getEntitiesInRange(this.worldObj, this.posX, this.posY, this.posZ, (Entity)this, Entity.class, this.area);
            for (Entity e : list) {
                if (!EntityUtils.canEntityBeSeen((Entity)this, e)) continue;
                e.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this.getThrower()), (float)this.damage);
            }
            for (int a = 0; a < 20; ++a) {
                int yy;
                int xx = MathHelper.floor_double(this.posX) + this.rand.nextInt(this.area) - this.rand.nextInt(this.area);
                int zz = MathHelper.floor_double(this.posZ) + this.rand.nextInt(this.area) - this.rand.nextInt(this.area);
                for (yy = MathHelper.floor_double(this.posY) + this.area; this.worldObj.isAirBlock(xx, yy, zz) && yy > MathHelper.floor_double(this.posY) - this.area; --yy) {
                }
                if (!this.worldObj.isAirBlock(xx, yy + 1, zz) || this.worldObj.isAirBlock(xx, yy, zz) || this.worldObj.getBlock(xx, yy + 1, zz) == ConfigBlocks.blockAiry || !EntityUtils.canEntityBeSeen((Entity)this, (double)xx + 0.5, (double)yy + 1.5, (double)zz + 0.5)) continue;
                this.worldObj.setBlock(xx, yy + 1, zz, ConfigBlocks.blockAiry, 10, 3);
            }
        }
        Thaumcraft.proxy.burst(this.worldObj, this.posX, this.posY, this.posZ, 3.0f);
        this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "thaumcraft:shock", 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
        this.setDead();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.ticksExisted > 500) {
            this.setDead();
        }
    }

    public float getShadowSize() {
        return 0.1f;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        this.setBeenAttacked();
        if (p_70097_1_.getEntity() != null) {
            Vec3 vec3 = p_70097_1_.getEntity().getLookVec();
            if (vec3 != null) {
                this.motionX = vec3.xCoord;
                this.motionY = vec3.yCoord;
                this.motionZ = vec3.zCoord;
                this.motionX *= 0.9;
                this.motionY *= 0.9;
                this.motionZ *= 0.9;
                this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:zap", 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
            }
            return true;
        }
        return false;
    }
}

