/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;

public class EntityFrostShard
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public double bounce = 0.5;
    public int bounceLimit = 3;
    public boolean fragile = false;

    public EntityFrostShard(World par1World) {
        super(par1World);
    }

    public EntityFrostShard(World par1World, EntityLivingBase par2EntityLiving, float scatter) {
        super(par1World, par2EntityLiving);
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, this.func_70182_d(), scatter);
    }

    protected float getGravityVelocity() {
        return this.fragile ? 0.015f : 0.05f;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.bounce);
        data.writeInt(this.bounceLimit);
        data.writeBoolean(this.fragile);
    }

    public void readSpawnData(ByteBuf data) {
        this.bounce = data.readDouble();
        this.bounceLimit = data.readInt();
        this.fragile = data.readBoolean();
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null) {
            int ox = MathHelper.floor_double((double)this.posX) - MathHelper.floor_double((double)mop.entityHit.posX);
            int oy = MathHelper.floor_double((double)this.posY) - MathHelper.floor_double((double)mop.entityHit.posY);
            int oz = MathHelper.floor_double((double)this.posZ) - MathHelper.floor_double((double)mop.entityHit.posZ);
            if (oz != 0) {
                this.motionZ *= -1.0;
            }
            if (ox != 0) {
                this.motionX *= -1.0;
            }
            if (oy != 0) {
                this.motionY *= -0.9;
            }
            this.motionX *= 0.66;
            this.motionY *= 0.66;
            this.motionZ *= 0.66;
            int a = 0;
            while ((float)a < this.getDamage()) {
                this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)ConfigBlocks.blockCustomOre) + "_15", this.posX, this.posY, this.posZ, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
                ++a;
            }
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.sideHit);
            if (dir.offsetZ != 0) {
                this.motionZ *= -1.0;
            }
            if (dir.offsetX != 0) {
                this.motionX *= -1.0;
            }
            if (dir.offsetY != 0) {
                this.motionY *= -0.9;
            }
            Block bhit = this.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            try {
                this.playSound(bhit.stepSound.getBreakSound(), 0.3f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            }
            catch (Exception e) {
                // empty catch block
            }
            int a = 0;
            while ((float)a < this.getDamage()) {
                this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)bhit) + "_" + this.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ), this.posX, this.posY, this.posZ, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
                ++a;
            }
        }
        this.motionX *= this.bounce;
        this.motionY *= this.bounce;
        this.motionZ *= this.bounce;
        float var20 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.posX -= this.motionX / (double)var20 * (double)0.05f;
        this.posY -= this.motionY / (double)var20 * (double)0.05f;
        this.posZ -= this.motionZ / (double)var20 * (double)0.05f;
        this.setBeenAttacked();
        if (!this.worldObj.isRemote && mop.entityHit != null) {
            double mx = mop.entityHit.motionX;
            double my = mop.entityHit.motionY;
            double mz = mop.entityHit.motionZ;
            mop.entityHit.attackEntityFrom(DamageSource.causeThrownDamage((Entity)this, (Entity)this.getThrower()), this.getDamage());
            if (mop.entityHit instanceof EntityLivingBase && this.getFrosty() > 0) {
                ((EntityLivingBase)mop.entityHit).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 200, this.getFrosty() - 1));
            }
            if (this.fragile) {
                mop.entityHit.hurtResistantTime = 0;
                this.setDead();
                this.playSound(Blocks.ice.stepSound.getBreakSound(), 0.3f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                mop.entityHit.motionX = mx + (mop.entityHit.motionX - mx) / 10.0;
                mop.entityHit.motionY = my + (mop.entityHit.motionY - my) / 10.0;
                mop.entityHit.motionZ = mz + (mop.entityHit.motionZ - mz) / 10.0;
            }
        }
        if (this.bounceLimit-- <= 0) {
            this.setDead();
            this.playSound(Blocks.ice.stepSound.getBreakSound(), 0.3f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            int a = 0;
            while ((float)a < 8.0f * this.getDamage()) {
                this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)ConfigBlocks.blockCustomOre) + "_15", this.posX, this.posY, this.posZ, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
                ++a;
            }
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote && this.getFrosty() > 0) {
            float s = this.getDamage() / 10.0f;
            for (int a = 0; a < this.getFrosty(); ++a) {
                Thaumcraft.proxy.sparkle((float)this.posX - s + this.rand.nextFloat() * (s * 2.0f), (float)this.posY - s + this.rand.nextFloat() * (s * 2.0f), (float)this.posZ - s + this.rand.nextFloat() * (s * 2.0f), 0.4f, 6, 0.005f);
            }
        }
        float var20 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, var20) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setFloat("damage", this.getDamage());
        par1NBTTagCompound.setBoolean("fragile", this.fragile);
        par1NBTTagCompound.setInteger("frost", this.getFrosty());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setDamage(par1NBTTagCompound.getFloat("damage"));
        this.fragile = par1NBTTagCompound.getBoolean("fragile");
        this.setFrosty(par1NBTTagCompound.getInteger("frost"));
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)new Float(0.0f));
        this.dataWatcher.addObject(17, (Object)new Byte(0));
    }

    public void setDamage(float par1) {
        this.dataWatcher.updateObject(16, (Object)Float.valueOf(par1));
        this.setSize(0.15f + par1 * 0.15f, 0.15f + par1 * 0.15f);
    }

    public float getDamage() {
        return this.dataWatcher.getWatchableObjectFloat(16);
    }

    public void setFrosty(int frosty) {
        this.dataWatcher.updateObject(17, (Object)((byte)frosty));
    }

    public int getFrosty() {
        return this.dataWatcher.getWatchableObjectByte(17);
    }
}

