/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.monster.EntityCultistCleric;
import thaumcraft.common.entities.monster.EntityCultistKnight;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockArc;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.TileBanner;

public class EntityCultistPortal
extends EntityMob
implements IBossDisplayData {
    int stage = 0;
    int stagecounter = 200;
    public int pulse = 0;

    public EntityCultistPortal(World par1World) {
        super(par1World);
        this.isImmuneToFire = true;
        this.experienceValue = 30;
        this.setSize(1.5f, 3.0f);
    }

    public int getTotalArmorValue() {
        return 5;
    }

    protected void entityInit() {
        super.entityInit();
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setInteger("stage", this.stage);
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.stage = nbt.getInteger("stage");
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(500.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(0.0);
        this.getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(1.0);
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canBePushed() {
        return false;
    }

    public void moveEntity(double par1, double par3, double par5) {
    }

    protected void updateEntityActionState() {
    }

    public boolean isInRangeToRenderDist(double par1) {
        return par1 < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.stagecounter > 0) {
                int a;
                --this.stagecounter;
                if (this.stagecounter == 160 && this.stage == 0) {
                    this.worldObj.setEntityState((Entity)this, (byte)16);
                    for (a = 2; a < 6; ++a) {
                        ForgeDirection dir = ForgeDirection.getOrientation((int)a);
                        this.worldObj.setBlock((int)this.posX - dir.offsetX * 6, (int)this.posY, (int)this.posZ + dir.offsetZ * 6, ConfigBlocks.blockWoodenDevice, 8, 3);
                        TileEntity te = this.worldObj.getTileEntity((int)this.posX - dir.offsetX * 6, (int)this.posY, (int)this.posZ + dir.offsetZ * 6);
                        if (te == null || !(te instanceof TileBanner)) continue;
                        int face = 0;
                        switch (a) {
                            case 2: {
                                face = 8;
                                break;
                            }
                            case 3: {
                                face = 0;
                                break;
                            }
                            case 4: {
                                face = 12;
                                break;
                            }
                            case 5: {
                                face = 4;
                                break;
                            }
                        }
                        ((TileBanner)te).setFacing((byte)face);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc((int)this.posX - dir.offsetX * 6, (int)this.posY, (int)this.posZ + dir.offsetZ * 6, this.getEntityId()), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, this.posX, this.posY, this.posZ, 32.0));
                        this.playSound("thaumcraft:wandfail", 1.0f, 1.0f);
                    }
                }
                if (this.stagecounter > 20 && this.stagecounter < 150 && this.stage == 0 && this.stagecounter % 13 == 0) {
                    a = (int)this.posX + this.rand.nextInt(5) - this.rand.nextInt(5);
                    int b = (int)this.posZ + this.rand.nextInt(5) - this.rand.nextInt(5);
                    if (a != (int)this.posX && b != (int)this.posZ && this.worldObj.isAirBlock(a, (int)this.posY, b)) {
                        this.worldObj.setEntityState((Entity)this, (byte)16);
                        float rr = this.worldObj.rand.nextFloat();
                        int md = rr < 0.05f ? 2 : (rr < 0.2f ? 1 : 0);
                        this.worldObj.setBlock(a, (int)this.posY, b, ConfigBlocks.blockLootCrate, md, 3);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(a, (int)this.posY, b, this.getEntityId()), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, this.posX, this.posY, this.posZ, 32.0));
                        this.playSound("thaumcraft:wandfail", 1.0f, 1.0f);
                    }
                }
            } else if (this.worldObj.getClosestPlayerToEntity((Entity)this, 48.0) != null) {
                this.worldObj.setEntityState((Entity)this, (byte)16);
                switch (this.stage) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.stagecounter = 15 + this.rand.nextInt(10 - this.stage) - this.stage;
                        this.spawnMinions();
                        break;
                    }
                    case 12: {
                        this.stagecounter = 50 + this.getTiming() * 2 + this.rand.nextInt(50);
                        this.spawnBoss();
                        break;
                    }
                    default: {
                        int t = this.getTiming();
                        this.stagecounter = t + this.rand.nextInt(5 + t / 3);
                        this.spawnMinions();
                    }
                }
                ++this.stage;
            } else {
                this.stagecounter = 30 + this.rand.nextInt(30);
            }
            if (this.stage < 12) {
                this.heal(1.0f);
            }
        }
        if (this.pulse > 0) {
            --this.pulse;
        }
    }

    int getTiming() {
        ArrayList<Entity> l = EntityUtils.getEntitiesInRange(this.worldObj, this.posX, this.posY, this.posZ, (Entity)this, EntityCultist.class, 32.0);
        return l.size() * 20;
    }

    void spawnMinions() {
        EntityCultist cultist = null;
        cultist = (double)this.rand.nextFloat() > 0.33 ? new EntityCultistKnight(this.worldObj) : new EntityCultistCleric(this.worldObj);
        cultist.setPosition(this.posX + (double)this.rand.nextFloat() - (double)this.rand.nextFloat(), this.posY + 0.25, this.posZ + (double)this.rand.nextFloat() - (double)this.rand.nextFloat());
        cultist.onSpawnWithEgg(null);
        cultist.spawnExplosionParticle();
        cultist.setHomeArea((int)this.posX, (int)this.posY, (int)this.posZ, 32);
        this.worldObj.spawnEntityInWorld((Entity)cultist);
        cultist.playSound("thaumcraft:wandfail", 1.0f, 1.0f);
        if (this.stage > 12) {
            this.attackEntityFrom(DamageSource.outOfWorld, 5 + this.rand.nextInt(5));
        }
    }

    void spawnBoss() {
        EntityCultistLeader cultist = new EntityCultistLeader(this.worldObj);
        cultist.setPosition(this.posX + (double)this.rand.nextFloat() - (double)this.rand.nextFloat(), this.posY + 0.25, this.posZ + (double)this.rand.nextFloat() - (double)this.rand.nextFloat());
        cultist.onSpawnWithEgg(null);
        cultist.setHomeArea((int)this.posX, (int)this.posY, (int)this.posZ, 32);
        cultist.spawnExplosionParticle();
        this.worldObj.spawnEntityInWorld((Entity)cultist);
        cultist.playSound("thaumcraft:wandfail", 1.0f, 1.0f);
    }

    public void onCollideWithPlayer(EntityPlayer p) {
        if (this.getDistanceSqToEntity((Entity)p) < 3.0 && p.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this), 8.0f)) {
            this.playSound("thaumcraft:zap", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f + 1.0f);
        }
    }

    protected float getSoundVolume() {
        return 0.75f;
    }

    public int getTalkInterval() {
        return 540;
    }

    protected String getLivingSound() {
        return "thaumcraft:monolith";
    }

    protected String getHurtSound() {
        return "thaumcraft:zap";
    }

    protected String getDeathSound() {
        return "thaumcraft:shock";
    }

    protected Item getDropItem() {
        return Item.getItemById((int)0);
    }

    protected void dropFewItems(boolean flag, int fortune) {
        EntityUtils.entityDropSpecialItem((Entity)this, new ItemStack(ConfigItems.itemEldritchObject, 1, 3), this.height / 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte msg) {
        if (msg == 16) {
            this.pulse = 10;
            this.spawnExplosionParticle();
        } else {
            super.handleHealthUpdate(msg);
        }
    }

    public void addPotionEffect(PotionEffect p_70690_1_) {
    }

    protected void fall(float p_70069_1_) {
    }

    public void onDeath(DamageSource p_70645_1_) {
        if (!this.worldObj.isRemote) {
            this.worldObj.newExplosion((Entity)this, this.posX, this.posY, this.posZ, 2.0f, false, false);
        }
        super.onDeath(p_70645_1_);
    }
}

