/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityTaintSpore;
import thaumcraft.common.entities.monster.EntityTaintSwarm;

public class EntityTaintSporeSwarmer
extends EntityTaintSpore {
    int spawnCounter = 500;

    public EntityTaintSporeSwarmer(World par1World) {
        super(par1World);
        this.setSporeSize(10);
    }

    @Override
    public void setSporeSize(int par1) {
        this.dataWatcher.updateObject(16, (Object)new Byte((byte)par1));
        this.setSize(1.0f, 1.0f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.experienceValue = par1;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(75.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.worldObj.isRemote) {
            this.sploosh(10);
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    protected void sporeOnUpdate() {
        this.func_145771_j(this.posX, this.posY, this.posZ);
        if (this.spawnCounter > 0) {
            --this.spawnCounter;
        }
        if (this.spawnCounter <= 0 && this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0) != null) {
            this.spawnCounter = 500;
            this.swarmBurst(1);
        }
        if (this.worldObj.isRemote) {
            for (int a = 0; a < this.swarm.size(); ++a) {
                if (this.swarm.get(a) != null && !((Entity)this.swarm.get((int)a)).isDead) continue;
                this.swarm.remove(a);
                break;
            }
            if (this.swarm.size() < (500 - this.spawnCounter) / 25) {
                this.swarm.add(Thaumcraft.proxy.swarmParticleFX(this.worldObj, (Entity)this, 0.1f, 10.0f, 0.0f));
            }
        }
        if (this.deathTime == 1) {
            this.swarmBurst(1);
        }
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
    }

    protected void swarmBurst(int amt) {
        if (!this.worldObj.isRemote) {
            this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:gore", 1.0f, 0.9f + this.worldObj.rand.nextFloat() * 0.1f);
            for (int a = 0; a < amt; ++a) {
                EntityTaintSwarm swarm = new EntityTaintSwarm(this.worldObj);
                swarm.setLocationAndAngles(this.posX, this.posY + 0.5, this.posZ, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.spawnEntityInWorld((Entity)swarm);
            }
            this.worldObj.setEntityState((Entity)this, (byte)6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 6) {
            this.spawnCounter = 500;
            this.sploosh(25);
            for (int a = 0; a < this.swarm.size(); ++a) {
                ((Entity)this.swarm.get(a)).setDead();
            }
            this.swarm.clear();
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @Override
    public int getTalkInterval() {
        return 200;
    }

    @Override
    protected String getLivingSound() {
        return "thaumcraft:roots";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, 0, j = MathHelper.floor_double((double)this.posZ))) {
            double d0 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
            int k = MathHelper.floor_double((double)(this.posY - (double)this.yOffset + d0));
            return this.worldObj.getLightBrightnessForSkyBlocks(i, k, j, 0);
        }
        return 0;
    }

    @Override
    public float getBrightness(float par1) {
        int j;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, 0, j = MathHelper.floor_double((double)this.posZ))) {
            double d0 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
            int k = MathHelper.floor_double((double)(this.posY - (double)this.yOffset + d0));
            return this.worldObj.getLightBrightness(i, k, j);
        }
        return 0.0f;
    }

    @Override
    protected Item getDropItem() {
        return ConfigItems.itemResource;
    }

    @Override
    protected void dropFewItems(boolean flag, int i) {
        for (int a = 0; a <= 1; ++a) {
            if (this.worldObj.rand.nextBoolean()) {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 11), this.height / 2.0f);
                continue;
            }
            this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 12), this.height / 2.0f);
        }
    }
}

