/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityTaintSpider;

public class EntityTaintSpore
extends EntityMob
implements ITaintedMob,
IEntityAdditionalSpawnData {
    public ArrayList swarm = new ArrayList();
    protected int growth = 0;
    public float displaySize = 0.0f;

    public EntityTaintSpore(World par1World) {
        super(par1World);
        this.setSporeSize(2);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)new Byte(1));
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Size", this.getSporeSize() - 1);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setSporeSize(par1NBTTagCompound.getInteger("Size") + 1);
    }

    public void setSporeSize(int par1) {
        this.dataWatcher.updateObject(16, (Object)new Byte((byte)par1));
        float size = Math.max(0.15f * (float)par1, 0.5f);
        this.setSize(size, size);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.experienceValue = par1;
    }

    public int getSporeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canBePushed() {
        return false;
    }

    public void moveEntity(double par1, double par3, double par5) {
        int z;
        int y;
        int x;
        par1 = 0.0;
        par5 = 0.0;
        if (par3 > 0.0) {
            par3 = 0.0;
        }
        if (this.worldObj.getBlock(x = MathHelper.floor_double((double)this.posX), y = MathHelper.floor_double((double)this.boundingBox.minY) - 1, z = MathHelper.floor_double((double)this.posZ)) == ConfigBlocks.blockTaintFibres && this.worldObj.getBlockMetadata(x, y, z) == 4) {
            return;
        }
        super.moveEntity(par1, par3, par5);
    }

    protected void updateEntityActionState() {
    }

    public boolean isInRangeToRenderDist(double par1) {
        return par1 < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote && this.ticksExisted % 20 == 0 && this.worldObj.getBiomeGenForCoords((int)MathHelper.floor_double((double)this.posX), (int)MathHelper.floor_double((double)this.posZ)).biomeID != Config.biomeTaintID) {
            this.damageEntity(DamageSource.starve, 1.0f);
        }
        this.sporeOnUpdate();
    }

    protected void sporeOnUpdate() {
        int z;
        int y;
        int x;
        if (this.getSporeSize() < 10 && this.growth++ == 1200) {
            this.setSporeSize(this.getSporeSize() + 1);
            this.growth = 0;
        }
        if (this.worldObj.isRemote) {
            if (this.displaySize < (float)this.getSporeSize()) {
                this.displaySize += 0.02f;
            }
            for (int a = 0; a < this.swarm.size(); ++a) {
                if (this.swarm.get(a) != null && !((Entity)this.swarm.get((int)a)).isDead) continue;
                this.swarm.remove(a);
                break;
            }
            if (this.swarm.size() < this.getSporeSize() / 3) {
                this.swarm.add(Thaumcraft.proxy.swarmParticleFX(this.worldObj, (Entity)this, 0.1f, 10.0f, 0.0f));
            }
        }
        if (this.worldObj.getBlock(x = MathHelper.floor_double((double)this.posX), y = MathHelper.floor_double((double)this.boundingBox.minY) - 1, z = MathHelper.floor_double((double)this.posZ)) != ConfigBlocks.blockTaintFibres || this.worldObj.getBlockMetadata(x, y, z) != 4) {
            this.spiderBurst();
        } else if (this.deathTime > 0) {
            this.spiderBurst();
        }
    }

    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
        this.spiderBurst();
    }

    protected void spiderBurst() {
        if (!this.worldObj.isRemote) {
            int z;
            int y;
            this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:gore", 1.0f, 0.9f + this.worldObj.rand.nextFloat() * 0.1f);
            int q = this.getSporeSize() / 3 + this.worldObj.rand.nextInt(this.getSporeSize() / 2 + 1);
            for (int a = 0; a < q; ++a) {
                EntityTaintSpider spiderling = new EntityTaintSpider(this.worldObj);
                spiderling.setLocationAndAngles(this.posX + (double)this.worldObj.rand.nextFloat() - (double)this.worldObj.rand.nextFloat(), this.posY + (double)this.worldObj.rand.nextFloat(), this.posZ + (double)this.worldObj.rand.nextFloat() - (double)this.worldObj.rand.nextFloat(), this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.spawnEntityInWorld((Entity)spiderling);
            }
            int x = MathHelper.floor_double((double)this.posX);
            if (this.worldObj.getBlock(x, y = MathHelper.floor_double((double)this.boundingBox.minY) - 1, z = MathHelper.floor_double((double)this.posZ)) == ConfigBlocks.blockTaintFibres && this.worldObj.getBlockMetadata(x, y, z) == 4) {
                this.worldObj.setBlockMetadataWithNotify(x, y, z, 3, 3);
            }
            this.setDead();
        } else {
            this.sploosh(50);
        }
    }

    protected void sploosh(int amt) {
        for (int a = 0; a < amt; ++a) {
            Thaumcraft.proxy.splooshFX((Entity)this);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeFloat((float)this.getSporeSize());
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.displaySize = data.readFloat();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public int getTalkInterval() {
        return 200;
    }

    protected String getLivingSound() {
        return "thaumcraft:swarm";
    }

    protected String getHurtSound() {
        return "thaumcraft:gore";
    }

    protected String getDeathSound() {
        return "thaumcraft:gore";
    }

    protected Item getDropItem() {
        return ConfigItems.itemResource;
    }

    protected void dropFewItems(boolean flag, int i) {
        if (this.worldObj.rand.nextBoolean()) {
            this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 11), this.height / 2.0f);
        } else {
            this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 12), this.height / 2.0f);
        }
    }
}

