/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.config.ConfigItems;

public class EntityTaintSpider
extends EntitySpider
implements ITaintedMob {
    public EntityTaintSpider(World par1World) {
        super(par1World);
        this.setSize(0.4f, 0.3f);
        this.experienceValue = 2;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(5.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(2.0);
    }

    protected float getSoundPitch() {
        return 0.7f;
    }

    protected Entity findPlayerToAttack() {
        double d0 = 12.0;
        return this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, d0);
    }

    @SideOnly(value=Side.CLIENT)
    public float spiderScaleAmount() {
        return 0.4f;
    }

    public float getShadowSize() {
        return 0.1f;
    }

    protected Item getDropItem() {
        return ConfigItems.itemResource;
    }

    protected void dropFewItems(boolean flag, int i) {
        if (this.worldObj.rand.nextInt(6) == 0) {
            if (this.worldObj.rand.nextBoolean()) {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 11), this.height / 2.0f);
            } else {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 12), this.height / 2.0f);
            }
        }
    }
}

