/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityBrainyZombie;

public class EntityGiantBrainyZombie
extends EntityBrainyZombie {
    public EntityGiantBrainyZombie(World world) {
        super(world);
        this.experienceValue = 15;
        this.yOffset *= 1.2f + this.getAnger();
        this.setSize(this.width * (1.2f + this.getAnger()), this.height * (1.2f + this.getAnger()));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getAnger() > 1.0f) {
            this.setAnger(this.getAnger() - 0.002f);
            this.setSize(0.6f * (1.2f + this.getAnger()), 1.8f * (1.2f + this.getAnger()));
        }
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue((double)(7.0f + (this.getAnger() - 1.0f) * 5.0f));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(20, (Object)new Float(1.0f));
    }

    public float getAnger() {
        return this.dataWatcher.getWatchableObjectFloat(20);
    }

    public void setAnger(float par1) {
        this.dataWatcher.updateObject(20, (Object)Float.valueOf(par1));
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        this.setAnger(Math.min(2.0f, this.getAnger() + 0.1f));
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(60.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(7.0);
    }

    @Override
    protected void dropFewItems(boolean flag, int i) {
        int a;
        for (a = 0; a < 6; ++a) {
            if (!this.worldObj.rand.nextBoolean()) continue;
            this.dropItem(Items.rotten_flesh, 2);
        }
        for (a = 0; a < 6; ++a) {
            if (!this.worldObj.rand.nextBoolean()) continue;
            this.dropItem(Items.rotten_flesh, 2);
        }
        if (this.worldObj.rand.nextInt(10) - i <= 4) {
            this.entityDropItem(new ItemStack(ConfigItems.itemZombieBrain), 2.0f);
        }
    }

    protected void dropRareDrop(int par1) {
        switch (this.rand.nextInt(4)) {
            case 0: {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 2), 2.0f);
                break;
            }
            case 1: {
                this.dropItem(Items.carrot, 1);
                break;
            }
            case 2: {
                this.dropItem(Items.potato, 1);
                break;
            }
            case 3: {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 6), 2.0f);
            }
        }
    }
}

