/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.projectile.EntityEldritchOrb;
import thaumcraft.common.items.ItemWispEssence;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXSonic;
import thaumcraft.common.lib.network.misc.PacketMiscEvent;

public class EntityEldritchGuardian
extends EntityMob
implements IRangedAttackMob,
IEldritchMob {
    public float armLiftL = 0.0f;
    public float armLiftR = 0.0f;
    boolean lastBlast = false;

    public EntityEldritchGuardian(World p_i1745_1_) {
        super(p_i1745_1_);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new AILongRangeAttack(this, 8.0, 1.0, 20, 40, 24.0f));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, 0, true));
        this.setSize(0.8f, 2.25f);
        this.experienceValue = 20;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(50.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(7.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(12, (Object)0);
        this.getDataWatcher().addObject(13, (Object)0);
        this.getDataWatcher().addObject(14, (Object)0);
    }

    public int getTotalArmorValue() {
        return 4;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (source.isMagicDamage()) {
            damage /= 2.0f;
        }
        return super.attackEntityFrom(source, damage);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            if (this.armLiftL > 0.0f) {
                this.armLiftL -= 0.05f;
            }
            if (this.armLiftR > 0.0f) {
                this.armLiftR -= 0.05f;
            }
            float x = (float)(this.posX + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f));
            float z = (float)(this.posZ + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f));
            Thaumcraft.proxy.wispFXEG(this.worldObj, x, (float)(this.posY + 0.22 * (double)this.height), z, (Entity)this);
        } else if (this.worldObj.provider.dimensionId != Config.dimensionOuterId && (this.ticksExisted == 0 || this.ticksExisted % 100 == 0) && this.worldObj.difficultySetting != EnumDifficulty.EASY) {
            double d6 = this.worldObj.difficultySetting == EnumDifficulty.HARD ? 576.0 : 256.0;
            for (int i = 0; i < this.worldObj.playerEntities.size(); ++i) {
                double d5;
                EntityPlayer entityplayer1 = (EntityPlayer)this.worldObj.playerEntities.get(i);
                if (!entityplayer1.isEntityAlive() || !((d5 = entityplayer1.getDistanceSq(this.posX, this.posY, this.posZ)) < d6)) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketMiscEvent(2), (EntityPlayerMP)entityplayer1);
            }
        }
    }

    public boolean attackEntityAsMob(Entity p_70652_1_) {
        boolean flag = super.attackEntityAsMob(p_70652_1_);
        if (flag) {
            int i = this.worldObj.difficultySetting.getDifficultyId();
            if (this.getHeldItem() == null && this.isBurning() && this.rand.nextFloat() < (float)i * 0.3f) {
                p_70652_1_.setFire(2 * i);
            }
        }
        return flag;
    }

    protected String getLivingSound() {
        return "thaumcraft:egidle";
    }

    protected String getDeathSound() {
        return "thaumcraft:egdeath";
    }

    public int getTalkInterval() {
        return 500;
    }

    protected Item getDropItem() {
        return Item.getItemById((int)0);
    }

    protected void dropFewItems(boolean flag, int i) {
        AspectList al;
        ItemStack ess;
        if (this.rand.nextBoolean()) {
            ess = new ItemStack(ConfigItems.itemWispEssence);
            al = new AspectList();
            ((ItemWispEssence)ess.getItem()).setAspects(ess, new AspectList().add(Aspect.UNDEAD, 2));
            this.entityDropItem(ess, 1.0f);
        }
        if (this.rand.nextBoolean()) {
            ess = new ItemStack(ConfigItems.itemWispEssence);
            al = new AspectList();
            ((ItemWispEssence)ess.getItem()).setAspects(ess, new AspectList().add(Aspect.ELDRITCH, 2));
            this.entityDropItem(ess, 1.0f);
        }
        super.dropFewItems(flag, i);
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void dropRareDrop(int p_70600_1_) {
        this.dropItem(ConfigItems.itemEldritchObject, 1);
    }

    public void writeEntityToNBT(NBTTagCompound p_70014_1_) {
        super.writeEntityToNBT(p_70014_1_);
        if (this.getHomePosition() != null && this.func_110174_bM() > 0.0f) {
            p_70014_1_.setInteger("HomeD", (int)this.func_110174_bM());
            p_70014_1_.setInteger("HomeX", this.getHomePosition().posX);
            p_70014_1_.setInteger("HomeY", this.getHomePosition().posY);
            p_70014_1_.setInteger("HomeZ", this.getHomePosition().posZ);
        }
    }

    public void readEntityFromNBT(NBTTagCompound p_70037_1_) {
        super.readEntityFromNBT(p_70037_1_);
        if (p_70037_1_.hasKey("HomeD")) {
            this.setHomeArea(p_70037_1_.getInteger("HomeX"), p_70037_1_.getInteger("HomeY"), p_70037_1_.getInteger("HomeZ"), p_70037_1_.getInteger("HomeD"));
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        IEntityLivingData p_110161_1_1 = super.onSpawnWithEgg(p_110161_1_);
        float f = this.worldObj.func_147462_b(this.posX, this.posY, this.posZ);
        if (this.worldObj.provider.dimensionId == Config.dimensionOuterId) {
            int bh = (int)this.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue() / 2;
            this.setAbsorptionAmount(this.getAbsorptionAmount() + (float)bh);
        }
        return p_110161_1_1;
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.worldObj.provider.dimensionId == Config.dimensionOuterId && this.hurtResistantTime <= 0 && this.ticksExisted % 25 == 0) {
            int bh = (int)this.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue() / 2;
            if (this.getAbsorptionAmount() < (float)bh) {
                this.setAbsorptionAmount(this.getAbsorptionAmount() + 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte p_70103_1_) {
        if (p_70103_1_ == 15) {
            this.armLiftL = 0.5f;
        } else if (p_70103_1_ == 16) {
            this.armLiftR = 0.5f;
        } else if (p_70103_1_ == 17) {
            this.armLiftL = 0.9f;
            this.armLiftR = 0.9f;
        } else {
            super.handleHealthUpdate(p_70103_1_);
        }
    }

    protected boolean canDespawn() {
        return !this.hasHome();
    }

    public float getEyeHeight() {
        return 2.1f;
    }

    public boolean getCanSpawnHere() {
        List ents = this.worldObj.getEntitiesWithinAABB(EntityEldritchGuardian.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 16.0, 32.0));
        return ents.size() > 0 ? false : super.getCanSpawnHere();
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    protected float getSoundVolume() {
        return 1.5f;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float f) {
        if (this.rand.nextFloat() > 0.1f) {
            EntityEldritchOrb blast = new EntityEldritchOrb(this.worldObj, (EntityLivingBase)this);
            this.lastBlast = !this.lastBlast;
            this.worldObj.setEntityState((Entity)this, this.lastBlast ? (byte)16 : 15);
            int rr = this.lastBlast ? 90 : 180;
            double xx = MathHelper.cos((float)((this.rotationYaw + (float)rr) % 360.0f / 180.0f * (float)Math.PI)) * 0.5f;
            double yy = 0.057777777 * (double)this.height;
            double zz = MathHelper.sin((float)((this.rotationYaw + (float)rr) % 360.0f / 180.0f * (float)Math.PI)) * 0.5f;
            blast.setPosition(blast.posX - xx, blast.posY - yy, blast.posZ - zz);
            double d0 = entitylivingbase.posX + entitylivingbase.motionX - this.posX;
            double d1 = entitylivingbase.posY - this.posY - (double)(entitylivingbase.height / 2.0f);
            double d2 = entitylivingbase.posZ + entitylivingbase.motionZ - this.posZ;
            blast.setThrowableHeading(d0, d1, d2, 1.0f, 2.0f);
            this.playSound("thaumcraft:egattack", 2.0f, 1.0f + this.rand.nextFloat() * 0.1f);
            this.worldObj.spawnEntityInWorld((Entity)blast);
        } else if (this.canEntityBeSeen((Entity)entitylivingbase)) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXSonic(this.getEntityId()), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, this.posX, this.posY, this.posZ, 32.0));
            try {
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.wither.id, 400, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entitylivingbase instanceof EntityPlayer) {
                Thaumcraft.addWarpToPlayer((EntityPlayer)entitylivingbase, 1 + this.worldObj.rand.nextInt(3), true);
            }
            this.playSound("thaumcraft:egscreech", 3.0f, 1.0f + this.rand.nextFloat() * 0.1f);
        }
    }

    public boolean isOnSameTeam(EntityLivingBase el) {
        return el instanceof IEldritchMob;
    }
}

