/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.golems;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.client.lib.PlayerNotifications;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.EntityTravelingTrunk;
import thaumcraft.common.entities.golems.Marker;

public class ItemGolemBell
extends Item {
    public IIcon icon;

    public ItemGolemBell() {
        this.setHasSubtypes(false);
        this.setCreativeTab(Thaumcraft.tabTC);
        this.setMaxStackSize(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:ironbell");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public boolean getShareTag() {
        return true;
    }

    public static int getGolemId(ItemStack stack) {
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("golemid")) {
            return stack.stackTagCompound.getInteger("golemid");
        }
        return -1;
    }

    public static int getGolemHomeFace(ItemStack stack) {
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("golemhomeface")) {
            return stack.stackTagCompound.getInteger("golemhomeface");
        }
        return -1;
    }

    public static ChunkCoordinates getGolemHomeCoords(ItemStack stack) {
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("golemhomex")) {
            return new ChunkCoordinates(stack.stackTagCompound.getInteger("golemhomex"), stack.stackTagCompound.getInteger("golemhomey"), stack.stackTagCompound.getInteger("golemhomez"));
        }
        return null;
    }

    public static ArrayList<Marker> getMarkers(ItemStack stack) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("markers")) {
            NBTTagList tl = stack.stackTagCompound.getTagList("markers", 10);
            for (int i = 0; i < tl.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = tl.getCompoundTagAt(i);
                int x = nbttagcompound1.getInteger("x");
                int y = nbttagcompound1.getInteger("y");
                int z = nbttagcompound1.getInteger("z");
                int dim = nbttagcompound1.getInteger("dim");
                byte s = nbttagcompound1.getByte("side");
                byte c = nbttagcompound1.getByte("color");
                markers.add(new Marker(x, y, z, (byte)dim, s, c));
            }
        }
        return markers;
    }

    public static void resetMarkers(ItemStack stack, World world, EntityPlayer player) {
        Entity golem = null;
        int gid = ItemGolemBell.getGolemId(stack);
        if (gid > -1 && (golem = world.getEntityByID(gid)) != null && golem instanceof EntityGolemBase) {
            stack.setTagInfo("markers", (NBTBase)new NBTTagList());
            ((EntityGolemBase)golem).setMarkers(new ArrayList<Marker>());
            world.playSoundAtEntity((Entity)player, "random.orb", 0.7f, 1.0f + world.rand.nextFloat() * 0.1f);
        }
    }

    public static void changeMarkers(ItemStack stack, EntityPlayer player, World world, int par4, int par5, int par6, int side) {
        Entity golem = null;
        ArrayList<Marker> markers = ItemGolemBell.getMarkers(stack);
        boolean markMultipleColors = false;
        int gid = ItemGolemBell.getGolemId(stack);
        if (gid > -1 && (golem = world.getEntityByID(gid)) != null && golem instanceof EntityGolemBase && ((EntityGolemBase)golem).getUpgradeAmount(4) > 0) {
            markMultipleColors = true;
        }
        int count = markers.size();
        int index = -1;
        int color = 0;
        if (!markMultipleColors) {
            index = markers.indexOf(new Marker(par4, par5, par6, world.provider.dimensionId, (byte)side, -1));
        } else {
            int a = -1;
            while (a < 16) {
                index = markers.indexOf(new Marker(par4, par5, par6, world.provider.dimensionId, (byte)side, (byte)a));
                color = a++;
                if (index != -1) break;
            }
        }
        if (index >= 0) {
            markers.remove(index);
            if (markMultipleColors && !player.isSneaking() && ++color <= 15) {
                markers.add(new Marker(par4, par5, par6, world.provider.dimensionId, (byte)side, (byte)color));
                ++count;
                if (world.isRemote) {
                    String text = StatCollector.translateToLocal((String)"tc.markerchange");
                    text = color > -1 ? text.replaceAll("%n", UtilsFX.colorNames[color]) : StatCollector.translateToLocal((String)"tc.markerchangeany");
                    PlayerNotifications.addNotification(text);
                }
            }
        } else {
            markers.add(new Marker(par4, par5, par6, world.provider.dimensionId, (byte)side, -1));
        }
        if (count != markers.size()) {
            NBTTagList tl = new NBTTagList();
            for (Marker l : markers) {
                NBTTagCompound nbtc = new NBTTagCompound();
                nbtc.setInteger("x", l.x);
                nbtc.setInteger("y", l.y);
                nbtc.setInteger("z", l.z);
                nbtc.setInteger("dim", l.dim);
                nbtc.setByte("side", l.side);
                nbtc.setByte("color", l.color);
                tl.appendTag((NBTBase)nbtc);
            }
            stack.setTagInfo("markers", (NBTBase)tl);
            if (gid > -1) {
                if (golem == null || !(golem instanceof EntityGolemBase)) {
                    stack.getTagCompound().removeTag("golemid");
                    stack.getTagCompound().removeTag("markers");
                    stack.getTagCompound().removeTag("golemhomex");
                    stack.getTagCompound().removeTag("golemhomey");
                    stack.getTagCompound().removeTag("golemhomez");
                    stack.getTagCompound().removeTag("golemhomeface");
                } else {
                    ((EntityGolemBase)golem).setMarkers(markers);
                }
            }
        }
        world.playSoundEffect((double)par4, (double)par5, (double)par6, "random.orb", 0.7f, 1.0f + world.rand.nextFloat() * 0.1f);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int par4, int par5, int par6, int side, float par8, float par9, float par10) {
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, true);
        if (movingobjectposition == null) {
            return true;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            ItemGolemBell.changeMarkers(stack, player, world, i, j, k, movingobjectposition.sideHit);
        }
        return !world.isRemote;
    }

    public boolean itemInteractionForEntity(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        if (target instanceof EntityGolemBase) {
            if (stack.hasTagCompound()) {
                stack.getTagCompound().removeTag("golemid");
                stack.getTagCompound().removeTag("markers");
                stack.getTagCompound().removeTag("golemhomex");
                stack.getTagCompound().removeTag("golemhomey");
                stack.getTagCompound().removeTag("golemhomez");
                stack.getTagCompound().removeTag("golemhomeface");
            }
            if (target.worldObj.isRemote) {
                if (player != null) {
                    player.swingItem();
                }
            } else {
                ArrayList<Marker> markers = ((EntityGolemBase)target).getMarkers();
                NBTTagList tl = new NBTTagList();
                for (Marker l : markers) {
                    NBTTagCompound nbtc = new NBTTagCompound();
                    nbtc.setInteger("x", l.x);
                    nbtc.setInteger("y", l.y);
                    nbtc.setInteger("z", l.z);
                    nbtc.setInteger("dim", l.dim);
                    nbtc.setByte("side", l.side);
                    nbtc.setByte("color", l.color);
                    tl.appendTag((NBTBase)nbtc);
                }
                stack.setTagInfo("markers", (NBTBase)tl);
                stack.getTagCompound().setInteger("golemid", target.getEntityId());
                stack.getTagCompound().setInteger("golemhomex", ((EntityGolemBase)target).getHomePosition().posX);
                stack.getTagCompound().setInteger("golemhomey", ((EntityGolemBase)target).getHomePosition().posY);
                stack.getTagCompound().setInteger("golemhomez", ((EntityGolemBase)target).getHomePosition().posZ);
                stack.getTagCompound().setInteger("golemhomeface", ((EntityGolemBase)target).homeFacing);
                target.worldObj.playSoundAtEntity((Entity)target, "random.orb", 0.7f, 1.0f + target.worldObj.rand.nextFloat() * 0.1f);
                if (player != null && player.capabilities.isCreativeMode) {
                    player.setCurrentItemOrArmor(0, stack.copy());
                }
            }
            return true;
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityTravelingTrunk && !entity.isDead) {
            byte upgrade = (byte)((EntityTravelingTrunk)entity).getUpgrade();
            if (upgrade == 3 && !((EntityTravelingTrunk)entity).func_152113_b().equals(player.getCommandSenderName())) {
                return false;
            }
            if (entity.worldObj.isRemote && entity instanceof EntityLiving) {
                ((EntityLiving)entity).spawnExplosionParticle();
                return false;
            }
            ItemStack dropped = new ItemStack(ConfigItems.itemTrunkSpawner);
            if (player.isSneaking()) {
                if (upgrade > -1 && entity.worldObj.rand.nextBoolean()) {
                    ((EntityTravelingTrunk)entity).entityDropItem(new ItemStack(ConfigItems.itemGolemUpgrade, 1, (int)upgrade), 0.5f);
                }
            } else {
                if (((EntityTravelingTrunk)entity).hasCustomNameTag()) {
                    dropped.setStackDisplayName(((EntityTravelingTrunk)entity).getCustomNameTag());
                }
                dropped.setTagInfo("upgrade", (NBTBase)new NBTTagByte(upgrade));
                if (upgrade == 4) {
                    dropped.setTagInfo("inventory", (NBTBase)((EntityTravelingTrunk)entity).inventory.writeToNBT(new NBTTagList()));
                }
            }
            ((EntityTravelingTrunk)entity).entityDropItem(dropped, 0.5f);
            if (upgrade != 4 || player.isSneaking()) {
                ((EntityTravelingTrunk)entity).inventory.dropAllItems();
            }
            entity.worldObj.playSoundAtEntity(entity, "thaumcraft:zap", 0.5f, 1.0f);
            entity.setDead();
            return true;
        }
        if (entity instanceof EntityGolemBase && !entity.isDead) {
            if (entity.worldObj.isRemote && entity instanceof EntityLiving) {
                ((EntityLiving)entity).spawnExplosionParticle();
                return false;
            }
            int type = ((EntityGolemBase)entity).golemType.ordinal();
            String deco = ((EntityGolemBase)entity).decoration;
            byte core = ((EntityGolemBase)entity).getCore();
            byte[] upgrades = ((EntityGolemBase)entity).upgrades;
            boolean advanced = ((EntityGolemBase)entity).advanced;
            ItemStack dropped = new ItemStack(ConfigItems.itemGolemPlacer, 1, type);
            if (advanced) {
                dropped.setTagInfo("advanced", (NBTBase)new NBTTagByte(1));
            }
            if (player.isSneaking()) {
                if (core > -1) {
                    ((EntityGolemBase)entity).entityDropItem(new ItemStack(ConfigItems.itemGolemCore, 1, (int)core), 0.5f);
                }
                for (byte b : upgrades) {
                    if (b <= -1 || !entity.worldObj.rand.nextBoolean()) continue;
                    ((EntityGolemBase)entity).entityDropItem(new ItemStack(ConfigItems.itemGolemUpgrade, 1, (int)b), 0.5f);
                }
            } else {
                if (((EntityGolemBase)entity).hasCustomNameTag()) {
                    dropped.setStackDisplayName(((EntityGolemBase)entity).getCustomNameTag());
                }
                if (deco.length() > 0) {
                    dropped.setTagInfo("deco", (NBTBase)new NBTTagString(deco));
                }
                if (core > -1) {
                    dropped.setTagInfo("core", (NBTBase)new NBTTagByte(core));
                }
                dropped.setTagInfo("upgrades", (NBTBase)new NBTTagByteArray(upgrades));
                ArrayList<Marker> markers = ((EntityGolemBase)entity).getMarkers();
                NBTTagList tl = new NBTTagList();
                for (Marker l : markers) {
                    NBTTagCompound nbtc = new NBTTagCompound();
                    nbtc.setInteger("x", l.x);
                    nbtc.setInteger("y", l.y);
                    nbtc.setInteger("z", l.z);
                    nbtc.setInteger("dim", l.dim);
                    nbtc.setByte("side", l.side);
                    nbtc.setByte("color", l.color);
                    tl.appendTag((NBTBase)nbtc);
                }
                dropped.setTagInfo("markers", (NBTBase)tl);
                dropped.setTagInfo("Inventory", (NBTBase)((EntityGolemBase)entity).inventory.writeToNBT(new NBTTagList()));
            }
            ((EntityGolemBase)entity).entityDropItem(dropped, 0.5f);
            ((EntityGolemBase)entity).dropStuff();
            entity.worldObj.playSoundAtEntity(entity, "thaumcraft:zap", 0.5f, 1.0f);
            entity.setDead();
            return true;
        }
        return false;
    }
}

