/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.golems;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.InventoryTrunk;
import thaumcraft.common.lib.events.EventHandlerEntity;
import thaumcraft.common.lib.utils.InventoryUtils;

public class EntityTravelingTrunk
extends EntityLiving
implements IEntityOwnable {
    public int slotCount = 27;
    public InventoryTrunk inventory = new InventoryTrunk(this, this.slotCount);
    public float lidrot;
    public float field_768_a;
    public float field_767_b;
    private int jumpDelay = 0;
    private int eatDelay = 0;

    public EntityTravelingTrunk(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.jumpDelay = this.rand.nextInt(20) + 10;
        this.isImmuneToFire = true;
        this.fireResistance = 10;
        this.lidrot = 0.0f;
        this.func_110163_bv();
        this.setSize(0.8f, 0.8f);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(75.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(15, (Object)new Byte(0));
        this.dataWatcher.addObject(16, (Object)new Byte(0));
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)-1);
        this.dataWatcher.addObject(19, (Object)new Byte(0));
        this.dataWatcher.addObject(20, (Object)new Short(0));
    }

    public boolean attackEntityFrom(DamageSource ds, float par2) {
        if (ds == DamageSource.cactus) {
            return false;
        }
        if (this.getUpgrade() == 3) {
            return false;
        }
        return super.attackEntityFrom(ds, par2);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Stay", this.getStay());
        nbttagcompound.setByte("upgrade", (byte)this.getUpgrade());
        if (this.func_152113_b() == null) {
            nbttagcompound.setString("Owner", "");
        } else {
            nbttagcompound.setString("Owner", this.func_152113_b());
        }
        nbttagcompound.setTag("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setStay(nbttagcompound.getBoolean("Stay"));
        this.setUpgrade(nbttagcompound.getByte("upgrade"));
        String s = nbttagcompound.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
        }
        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.setInvSize();
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getUpgrade() == 5) {
            this.pullItems();
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inWater) {
            this.motionY += (double)0.033f;
        }
        if (this.worldObj.isRemote) {
            if (!this.onGround && this.motionY < 0.0 && !this.inWater) {
                this.lidrot += 0.015f;
            }
            if ((this.onGround || this.inWater) && !this.isOpen()) {
                this.lidrot -= 0.1f;
                if (this.lidrot < 0.0f) {
                    this.lidrot = 0.0f;
                }
            }
            if (this.isOpen()) {
                this.lidrot += 0.035f;
            }
            float f = this.isOpen() ? 0.5f : 0.2f;
            if (this.lidrot > f) {
                this.lidrot = this.isOpen() ? 0.5f : 0.2f;
            }
        } else if (this.getHealth() < this.getMaxHealth() && (this.getUpgrade() == 3 || this.ticksExisted % 50 == 0)) {
            this.heal(1.0f);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void updateEntityActionState() {
        if (this.getAnger() > 0) {
            this.setAnger(this.getAnger() - 1);
        }
        if (this.eatDelay > 0) {
            --this.eatDelay;
        }
        this.fallDistance = 0.0f;
        if (this.getOwner() != null) {
            if (!this.worldObj.isRemote) {
                ArrayList<WeakReference<Object>> ll = EventHandlerEntity.linkedEntities.get(this.getOwner().getCommandSenderName());
                if (ll == null) {
                    ll = new ArrayList();
                }
                boolean add = true;
                for (WeakReference<Entity> weakReference : ll) {
                    if (weakReference.get() == null || ((Entity)weakReference.get()).getEntityId() != this.getEntityId()) continue;
                    add = false;
                    break;
                }
                if (add) {
                    ll.add(new WeakReference<EntityTravelingTrunk>(this));
                    EventHandlerEntity.linkedEntities.put(this.getOwner().getCommandSenderName(), ll);
                }
            }
            if (!this.getStay() && this.getOwner() != null && this.getDistanceToEntity(this.getOwner()) > 20.0f) {
                void var4_9;
                int i = MathHelper.floor_double((double)this.getOwner().posX) - 2;
                int j = MathHelper.floor_double((double)this.getOwner().posZ) - 2;
                int k = MathHelper.floor_double((double)this.getOwner().boundingBox.minY);
                boolean bl = false;
                while (var4_9 <= 4) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (var4_9 >= true && i1 >= 1 && var4_9 <= 3 && i1 <= 3 || !this.worldObj.isBlockNormalCubeDefault(i + var4_9, k - 1, j + i1, false) && this.worldObj.getBlock(i + var4_9, k - 1, j + i1).getMaterial() != Material.water || this.worldObj.isBlockNormalCubeDefault(i + var4_9, k, j + i1, false) || this.worldObj.isBlockNormalCubeDefault(i + var4_9, k + 1, j + i1, false)) continue;
                        this.worldObj.playSoundEffect((double)((float)(i + var4_9) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), "mob.endermen.portal", 0.5f, 1.0f);
                        this.setLocationAndAngles((float)(i + var4_9) + 0.5f, k, (float)(j + i1) + 0.5f, this.rotationYaw, this.rotationPitch);
                        this.setAttackTarget(null);
                        return;
                    }
                    ++var4_9;
                }
            }
            if (this.getAttackTarget() != null && this.getAttackTarget().isDead) {
                this.setAttackTarget(null);
                this.setAnger(5);
            }
            if (!this.getStay() && this.getUpgrade() == 2 && this.getAnger() == 0 && this.getAttackTarget() == null && this.getOwner() != null && this.getOwnerEntity().getAITarget() != null && !this.getOwnerEntity().getAITarget().isDead && this.getOwnerEntity().getAITarget() instanceof EntityLivingBase && this.canEntityBeSeen((Entity)this.getOwnerEntity().getAITarget())) {
                this.setAnger(600);
                this.setAttackTarget(this.getOwnerEntity().getAITarget());
            }
            boolean move = false;
            if (this.getAnger() > 0 && this.getAttackTarget() != null && !this.getAttackTarget().isDead && this.getAttackTarget() != this.getOwnerEntity()) {
                this.faceEntity((Entity)this.getAttackTarget(), 10.0f, 20.0f);
                move = true;
                if (this.attackTime <= 0 && (double)this.getDistanceToEntity((Entity)this.getAttackTarget()) < 1.5 && this.getAttackTarget().boundingBox.maxY > this.boundingBox.minY && this.getAttackTarget().boundingBox.minY < this.boundingBox.maxY) {
                    this.attackTime = 10 + this.worldObj.rand.nextInt(5);
                    this.getAttackTarget().attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 4.0f);
                    this.worldObj.setEntityState((Entity)this, (byte)17);
                    this.worldObj.playSoundAtEntity((Entity)this, "mob.blaze.hit", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                }
            }
            if (this.getOwner() != null && this.getDistanceToEntity(this.getOwner()) > 5.0f && this.getAnger() == 0 && !this.getStay()) {
                this.faceEntity(this.getOwner(), 10.0f, 20.0f);
                move = true;
            }
            if ((this.onGround || this.inWater) && this.jumpDelay-- <= 0 && move) {
                boolean fast = this.getUpgrade() == 0;
                this.jumpDelay = this.rand.nextInt(10) + 5;
                this.jumpDelay /= 3;
                this.isJumping = true;
                this.field_768_a = 1.0f;
                this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
                float f = this.moveForward = fast ? 8.0f : 6.0f;
                if (this.inWater) {
                    this.moveForward *= 0.75f;
                }
                this.jumpMovementFactor = fast ? 0.04f : 0.03f;
                this.worldObj.playSoundAtEntity((Entity)this, "random.chestclosed", 0.1f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            } else {
                this.isJumping = false;
                if (this.onGround) {
                    this.moveForward = 0.0f;
                    this.moveStrafing = 0.0f;
                }
            }
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    protected String getHurtSound() {
        return Blocks.log.stepSound.getStepResourcePath();
    }

    protected String getDeathSound() {
        return "random.break";
    }

    protected Item getDropItem() {
        return Item.getItemById((int)0);
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        this.setInvSize();
        return super.onSpawnWithEgg(par1EntityLivingData);
    }

    public void setInvSize() {
        this.setRows(this.getUpgrade() == 1 ? 4 : 3);
        this.slotCount = this.getRows() * 9;
    }

    public boolean interact(EntityPlayer player) {
        if (player.isSneaking()) {
            return false;
        }
        ItemStack itemstack = player.inventory.getCurrentItem();
        if (itemstack != null && itemstack.getItem() == ConfigItems.itemGolemBell) {
            return this.getUpgrade() == 3 && !this.func_152113_b().equals(player.getCommandSenderName());
        }
        if (this.getUpgrade() == -1 && itemstack != null && itemstack.getItem() == ConfigItems.itemGolemUpgrade) {
            this.setUpgrade(itemstack.getItemDamage());
            this.setInvSize();
            --itemstack.stackSize;
            if (itemstack.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
            }
            this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:upgrade", 0.5f, 1.0f);
            player.swingItem();
            return true;
        }
        if (itemstack != null && itemstack.getItem() instanceof ItemFood && this.getHealth() < this.getMaxHealth()) {
            ItemFood itemfood = (ItemFood)itemstack.getItem();
            --itemstack.stackSize;
            this.heal(itemfood.func_150905_g(itemstack));
            if (this.getHealth() == this.getMaxHealth()) {
                this.worldObj.playSoundAtEntity((Entity)this, "random.burp", 0.5f, this.worldObj.rand.nextFloat() * 0.5f + 0.5f);
            } else {
                this.worldObj.playSoundAtEntity((Entity)this, "random.eat", 0.5f, this.worldObj.rand.nextFloat() * 0.5f + 0.5f);
            }
            this.worldObj.setEntityState((Entity)this, (byte)18);
            this.lidrot = 0.15f;
            if (itemstack.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
            }
            return true;
        }
        if (!this.worldObj.isRemote) {
            if (this.getUpgrade() == 3 && !this.func_152113_b().equals(player.getCommandSenderName())) {
                return true;
            }
            player.openGui((Object)Thaumcraft.instance, 2, this.worldObj, this.getEntityId(), 0, 0);
            return false;
        }
        return true;
    }

    void showHeartsOrSmokeFX(boolean flag) {
        String s = "heart";
        int amount = 1;
        if (!flag) {
            s = "explode";
            amount = 7;
        }
        for (int i = 0; i < amount; ++i) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(s, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
        }
    }

    private void pullItems() {
        Entity entity;
        int a;
        if (this.isDead || this.getHealth() <= 0.0f) {
            return;
        }
        List list = null;
        if (!this.worldObj.isRemote) {
            list = this.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 0.5), (double)(this.posY - 0.5), (double)(this.posZ - 0.5), (double)(this.posX + 0.5), (double)(this.posY + 0.5), (double)(this.posZ + 0.5)));
            for (a = 0; a < list.size(); ++a) {
                ItemStack stack;
                ItemStack outstack;
                entity = (Entity)list.get(a);
                if (!(entity instanceof EntityItem) || (outstack = InventoryUtils.placeItemStackIntoInventory(stack = ((EntityItem)entity).getEntityItem().copy(), this.inventory, 0, true)) != null && outstack.stackSize == stack.stackSize) continue;
                this.worldObj.playSoundAtEntity((Entity)this, "random.eat", 0.5f, this.worldObj.rand.nextFloat() * 0.5f + 0.5f);
                this.worldObj.setEntityState((Entity)this, (byte)17);
                if (outstack != null && outstack.stackSize >= 0) {
                    ((EntityItem)entity).setEntityItemStack(outstack);
                    continue;
                }
                entity.setDead();
            }
        }
        list = this.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 3.0), (double)(this.posY - 3.0), (double)(this.posZ - 3.0), (double)(this.posX + 3.0), (double)(this.posY + 3.0), (double)(this.posZ + 3.0)));
        for (a = 0; a < list.size(); ++a) {
            entity = (Entity)list.get(a);
            if (!(entity instanceof EntityItem)) continue;
            double d6 = entity.posX - this.posX;
            double d8 = entity.posY - this.posY + (double)(this.height * 0.8f);
            double d10 = entity.posZ - this.posZ;
            double d11 = MathHelper.sqrt_double((double)(d6 * d6 + d8 * d8 + d10 * d10));
            double d13 = 0.075;
            entity.motionX -= (d6 /= d11) * d13;
            entity.motionY -= (d8 /= d11) * d13;
            entity.motionZ -= (d10 /= d11) * d13;
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        if (!this.worldObj.isRemote) {
            this.inventory.dropAllItems();
        }
        super.onDeath(par1DamageSource);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public int getUpgrade() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setUpgrade(int upgrade) {
        this.dataWatcher.updateObject(18, (Object)((byte)upgrade));
    }

    public int getRows() {
        return this.dataWatcher.getWatchableObjectByte(19);
    }

    public void setRows(int rows) {
        this.dataWatcher.updateObject(19, (Object)((byte)rows));
    }

    public int getAnger() {
        return this.dataWatcher.getWatchableObjectShort(20);
    }

    public void setAnger(int anger) {
        this.dataWatcher.updateObject(20, (Object)((short)anger));
    }

    public boolean isOpen() {
        return this.dataWatcher.getWatchableObjectByte(15) == 1;
    }

    public void setOpen(boolean par1) {
        this.dataWatcher.updateObject(15, (Object)(par1 ? (byte)1 : 0));
    }

    public boolean getStay() {
        return this.dataWatcher.getWatchableObjectByte(16) == 1;
    }

    public void setStay(boolean par1) {
        this.dataWatcher.updateObject(16, (Object)(par1 ? (byte)1 : 0));
    }

    public String func_152113_b() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public Entity getOwner() {
        return this.getOwnerEntity();
    }

    public EntityLivingBase getOwnerEntity() {
        return this.worldObj.getPlayerEntityByName(this.func_152113_b());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 17) {
            this.lidrot = 0.15f;
        } else if (par1 == 18) {
            this.lidrot = 0.15f;
            this.showHeartsOrSmokeFX(true);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public void travelToDimension(int par1) {
        if (this.getStay() || this.isDead || this.dimension == par1) {
            return;
        }
        if (this.getOwner() == null) {
            try {
                Entity entity;
                MinecraftServer minecraftserver = MinecraftServer.getServer();
                WorldServer worldserver1 = minecraftserver.worldServerForDimension(par1);
                if (worldserver1 == null) {
                    return;
                }
                EntityPlayer target = worldserver1.getPlayerEntityByName(this.func_152113_b());
                if (target == null) {
                    return;
                }
                this.worldObj.removeEntity((Entity)this);
                this.isDead = false;
                if (this.isEntityAlive()) {
                    this.worldObj.updateEntityWithOptionalForce((Entity)this, false);
                }
                if ((entity = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)this), (World)worldserver1)) != null) {
                    entity.copyDataFrom((Entity)this, true);
                    entity.setLocationAndAngles(target.posX, target.posY + 0.25, target.posZ, entity.rotationYaw, entity.rotationPitch);
                    entity.dimension = par1;
                    worldserver1.spawnEntityInWorld(entity);
                }
                this.dimension = par1;
                this.isDead = true;
            }
            catch (Exception e) {
                Thaumcraft.log.error("Error while teleporting traveling trunk to dimension " + par1);
                e.printStackTrace();
            }
        } else {
            super.travelToDimension(par1);
        }
    }
}

