/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.utils.InventoryUtils;

public class AIItemPickup
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private Entity targetEntity;
    int count = 0;

    public AIItemPickup(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.theGolem.ticksExisted % Config.golemDelay > 0) {
            return false;
        }
        return this.findItem();
    }

    private boolean findItem() {
        double range = Double.MAX_VALUE;
        float dmod = this.theGolem.getRange();
        List targets = this.theGolem.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.theGolem, AxisAlignedBB.getBoundingBox((double)this.theGolem.getHomePosition().posX, (double)this.theGolem.getHomePosition().posY, (double)this.theGolem.getHomePosition().posZ, (double)(this.theGolem.getHomePosition().posX + 1), (double)(this.theGolem.getHomePosition().posY + 1), (double)(this.theGolem.getHomePosition().posZ + 1)).expand((double)dmod, (double)dmod, (double)dmod));
        if (targets.size() == 0) {
            return false;
        }
        for (Entity e : targets) {
            if (!(e instanceof EntityItem) || ((EntityItem)e).delayBeforeCanPickup >= 5 || !this.theGolem.inventory.allEmpty() && this.theGolem.inventory.getAmountNeededSmart(((EntityItem)e).getEntityItem(), this.theGolem.getUpgradeAmount(5) > 0) <= 0 || this.theGolem.getCarried() != null && (!InventoryUtils.areItemStacksEqualStrict(this.theGolem.getCarried(), ((EntityItem)e).getEntityItem()) || ((EntityItem)e).getEntityItem().stackSize > this.theGolem.getCarrySpace())) continue;
            double distance = e.getDistanceSq((double)((float)this.theGolem.getHomePosition().posX + 0.5f), (double)((float)this.theGolem.getHomePosition().posY + 0.5f), (double)((float)this.theGolem.getHomePosition().posZ + 0.5f));
            double distance2 = e.getDistanceSq(this.theGolem.posX, this.theGolem.posY, this.theGolem.posZ);
            if (!(distance2 < range) || !(distance <= (double)(dmod * dmod))) continue;
            range = distance2;
            this.targetEntity = e;
        }
        return this.targetEntity != null;
    }

    public boolean continueExecuting() {
        return this.count-- > 0 && !this.theGolem.getNavigator().noPath() && this.targetEntity.isEntityAlive();
    }

    public void resetTask() {
        this.count = 0;
        this.targetEntity = null;
        this.theGolem.getNavigator().clearPathEntity();
    }

    public void updateTask() {
        this.theGolem.getLookHelper().setLookPositionWithEntity(this.targetEntity, 30.0f, 30.0f);
        double dist = this.theGolem.getDistanceSqToEntity(this.targetEntity);
        if (dist <= 2.0) {
            this.pickUp();
        }
    }

    private void pickUp() {
        int amount = 0;
        if (this.targetEntity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)this.targetEntity).getEntityItem().copy();
            amount = ((EntityItem)this.targetEntity).getEntityItem().stackSize < this.theGolem.getCarrySpace() ? ((EntityItem)this.targetEntity).getEntityItem().stackSize : this.theGolem.getCarrySpace();
            stack.stackSize = amount;
            ((EntityItem)this.targetEntity).getEntityItem().stackSize -= amount;
            if (this.theGolem.getCarried() == null) {
                this.theGolem.setCarried(stack);
            } else {
                this.theGolem.getCarried().stackSize += amount;
            }
        }
        if (amount == 0) {
            return;
        }
        this.targetEntity.worldObj.playSoundAtEntity(this.targetEntity, "random.pop", 0.2f, ((this.targetEntity.worldObj.rand.nextFloat() - this.targetEntity.worldObj.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    public void startExecuting() {
        this.count = 200;
        this.theGolem.getNavigator().tryMoveToEntityLiving(this.targetEntity, (double)this.theGolem.getAIMoveSpeed());
    }
}

