/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.utils.InventoryUtils;

public class AIHomePlace
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int countChest = 0;
    private IInventory inv;

    public AIHomePlace(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        ChunkCoordinates home = this.theGolem.getHomePosition();
        if (this.theGolem.getCarried() == null || this.theGolem.ticksExisted % Config.golemDelay > 0 || !this.theGolem.getNavigator().noPath() || this.theGolem.getDistanceSq((float)home.posX + 0.5f, (float)home.posY + 0.5f, (float)home.posZ + 0.5f) > 5.0) {
            return false;
        }
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        TileEntity tile = this.theGolem.worldObj.getTileEntity(cX, cY, cZ);
        boolean repeat = true;
        boolean didRepeat = false;
        while (repeat) {
            ItemStack result;
            if (didRepeat) {
                repeat = false;
            }
            if (tile != null && tile instanceof IInventory && !ItemStack.areItemStacksEqual((ItemStack)(result = InventoryUtils.placeItemStackIntoInventory(this.theGolem.getCarried(), (IInventory)tile, facing.ordinal(), false)), (ItemStack)this.theGolem.itemCarried)) {
                return true;
            }
            if (!didRepeat && InventoryUtils.getDoubleChest(tile) != null) {
                tile = InventoryUtils.getDoubleChest(tile);
                didRepeat = true;
                continue;
            }
            repeat = false;
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.shouldExecute() || this.countChest > 0;
    }

    public void resetTask() {
        try {
            if (this.inv != null && Config.golemChestInteract) {
                this.inv.closeInventory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTask() {
        --this.countChest;
        super.updateTask();
    }

    public void startExecuting() {
        ChunkCoordinates home = this.theGolem.getHomePosition();
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        TileEntity tile = this.theGolem.worldObj.getTileEntity(cX, cY, cZ);
        boolean repeat = true;
        boolean didRepeat = false;
        while (repeat) {
            ItemStack result;
            if (didRepeat) {
                repeat = false;
            }
            if (tile != null && tile instanceof IInventory && !ItemStack.areItemStacksEqual((ItemStack)(result = InventoryUtils.placeItemStackIntoInventory(this.theGolem.getCarried(), (IInventory)tile, facing.ordinal(), true)), (ItemStack)this.theGolem.itemCarried)) {
                this.theGolem.setCarried(result);
                try {
                    if (Config.golemChestInteract) {
                        ((IInventory)tile).openInventory();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.countChest = 5;
                this.inv = (IInventory)tile;
                break;
            }
            if (!didRepeat && InventoryUtils.getDoubleChest(tile) != null) {
                tile = InventoryUtils.getDoubleChest(tile);
                didRepeat = true;
                continue;
            }
            repeat = false;
        }
    }
}

