/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class AIHomeDrop
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int countChest = 0;
    private IInventory inv;
    int count = 0;

    public AIHomeDrop(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        ChunkCoordinates home = this.theGolem.getHomePosition();
        if (this.theGolem.getCarried() == null || !this.theGolem.getNavigator().noPath() || this.theGolem.getDistanceSq((float)home.posX + 0.5f, (float)home.posY + 0.5f, (float)home.posZ + 0.5f) > 5.0) {
            return false;
        }
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        TileEntity tile = this.theGolem.worldObj.getTileEntity(cX, cY, cZ);
        return tile == null || !(tile instanceof IInventory);
    }

    public boolean continueExecuting() {
        return this.count > 0 && (this.shouldExecute() || this.countChest > 0);
    }

    public void resetTask() {
        try {
            if (this.inv != null && Config.golemChestInteract) {
                this.inv.closeInventory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTask() {
        --this.countChest;
        --this.count;
        super.updateTask();
    }

    public void startExecuting() {
        this.count = 200;
        ChunkCoordinates home = this.theGolem.getHomePosition();
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        EntityItem item = new EntityItem(this.theGolem.worldObj, this.theGolem.posX, this.theGolem.posY + (double)(this.theGolem.height / 2.0f), this.theGolem.posZ, this.theGolem.itemCarried.copy());
        if (item != null) {
            double distance = this.theGolem.getDistance((double)cX + 0.5, (double)cY + 0.5, (double)cZ + 0.5);
            item.motionX = ((double)cX + 0.5 - this.theGolem.posX) * (distance / 3.0);
            item.motionY = 0.1 + ((double)cY + 0.5 - (this.theGolem.posY + (double)(this.theGolem.height / 2.0f))) * (distance / 3.0);
            item.motionZ = ((double)cZ + 0.5 - this.theGolem.posZ) * (distance / 3.0);
            item.delayBeforeCanPickup = 10;
            this.theGolem.worldObj.spawnEntityInWorld((Entity)item);
            this.theGolem.itemCarried = null;
            this.theGolem.startActionTimer();
            this.theGolem.updateCarried();
        }
    }
}

