/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;

public class AIFillGoto
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private ChunkCoordinates dest = null;
    int count = 0;
    int prevX = 0;
    int prevY = 0;
    int prevZ = 0;

    public AIFillGoto(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.theGolem.getCarried() != null || this.theGolem.ticksExisted % Config.golemDelay > 0 || !this.theGolem.hasSomething()) {
            return false;
        }
        ArrayList<ItemStack> mi = GolemHelper.getMissingItems(this.theGolem);
        if (mi == null || mi.size() == 0) {
            return false;
        }
        ArrayList<ItemStack> missingItems = new ArrayList<ItemStack>();
        if (this.theGolem.getUpgradeAmount(5) > 0) {
            for (ItemStack stack : mi) {
                int od = OreDictionary.getOreID((ItemStack)stack);
                if (od != -1) {
                    ItemStack[] ores;
                    for (ItemStack ore : ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0])) {
                        missingItems.add(ore.copy());
                    }
                    continue;
                }
                missingItems.add(stack.copy());
            }
        } else {
            for (ItemStack stack : mi) {
                missingItems.add(stack.copy());
            }
        }
        ArrayList<Object> results = new ArrayList();
        for (ItemStack stack : missingItems) {
            this.theGolem.itemWatched = stack.copy();
            ArrayList<Byte> matchingColors = this.theGolem.getColorsMatching(this.theGolem.itemWatched);
            for (byte color : matchingColors) {
                results = GolemHelper.getContainersWithGoods(this.theGolem.worldObj, this.theGolem, this.theGolem.itemWatched, color);
            }
            if (results.size() <= 0) continue;
            break;
        }
        if (results == null || results.size() == 0) {
            return false;
        }
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        ChunkCoordinates home = this.theGolem.getHomePosition();
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        int tX = 0;
        int tY = 0;
        int tZ = 0;
        double range = Double.MAX_VALUE;
        float dmod = this.theGolem.getRange();
        for (IInventory iInventory : results) {
            TileEntity te = (TileEntity)iInventory;
            double distance = this.theGolem.getDistanceSq((double)te.xCoord + 0.5, (double)te.yCoord + 0.5, (double)te.zCoord + 0.5);
            if (!(distance < range) || !(distance <= (double)(dmod * dmod)) || te.xCoord == cX && te.yCoord == cY && te.zCoord == cZ) continue;
            range = distance;
            tX = te.xCoord;
            tY = te.yCoord;
            tZ = te.zCoord;
            this.dest = new ChunkCoordinates(tX, tY, tZ);
        }
        if (this.dest != null) {
            this.movePosX = tX;
            this.movePosY = tY;
            this.movePosZ = tZ;
            return true;
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.count > 0 && !this.theGolem.getNavigator().noPath();
    }

    public void updateTask() {
        Vec3 var2;
        --this.count;
        if (this.count == 0 && this.prevX == MathHelper.floor_double((double)this.theGolem.posX) && this.prevY == MathHelper.floor_double((double)this.theGolem.posY) && this.prevZ == MathHelper.floor_double((double)this.theGolem.posZ) && (var2 = RandomPositionGenerator.findRandomTarget((EntityCreature)this.theGolem, (int)2, (int)1)) != null) {
            this.count = 20;
            this.theGolem.getNavigator().tryMoveToXYZ(var2.xCoord, var2.yCoord, var2.zCoord, (double)this.theGolem.getAIMoveSpeed());
        }
        super.updateTask();
    }

    public void resetTask() {
        this.dest = null;
        this.count = 0;
    }

    public void startExecuting() {
        this.count = 200;
        this.prevX = MathHelper.floor_double((double)this.theGolem.posX);
        this.prevY = MathHelper.floor_double((double)this.theGolem.posY);
        this.prevZ = MathHelper.floor_double((double)this.theGolem.posZ);
        this.theGolem.getNavigator().tryMoveToXYZ(this.movePosX, this.movePosY, this.movePosZ, (double)this.theGolem.getAIMoveSpeed());
    }
}

