/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.interact;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;
import thaumcraft.common.entities.golems.Marker;

public class AIUseItem
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int xx;
    private int yy;
    private int zz;
    private float movementSpeed;
    private float distance;
    private World theWorld;
    private Block block = Blocks.air;
    private int blockMd = 0;
    FakePlayer player;
    private int count = 0;
    private int color = -1;
    ItemInWorldManager im;
    int nextTick = 0;

    public AIUseItem(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(3);
        this.distance = MathHelper.ceiling_float_int((float)(this.theGolem.getRange() / 3.0f));
        if (this.theWorld instanceof WorldServer) {
            this.player = FakePlayerFactory.get((WorldServer)((WorldServer)this.theWorld), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
        }
        try {
            this.nextTick = this.theGolem.ticksExisted + this.theWorld.rand.nextInt(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean shouldExecute() {
        int d;
        boolean ignoreItem = false;
        ChunkCoordinates home = this.theGolem.getHomePosition();
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        TileEntity tile = this.theGolem.worldObj.getTileEntity(cX, cY, cZ);
        if (tile == null || !(tile instanceof IInventory)) {
            ignoreItem = true;
        }
        if ((d = 5 - this.theGolem.ticksExisted) < 1) {
            d = 1;
        }
        if (this.theGolem.itemCarried == null && !ignoreItem || this.theGolem.ticksExisted < this.nextTick || !this.theGolem.getNavigator().noPath()) {
            return false;
        }
        this.nextTick = this.theGolem.ticksExisted + d * 3;
        return this.findSomething();
    }

    public boolean continueExecuting() {
        return this.theWorld.getBlock(this.xx, this.yy, this.zz) == this.block && this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz) == this.blockMd && this.count-- > 0 && !this.theGolem.getNavigator().noPath();
    }

    public void updateTask() {
        this.theGolem.getLookHelper().setLookPosition((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, 30.0f, 30.0f);
        double dist = this.theGolem.getDistanceSq((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5);
        if (dist <= 4.0) {
            this.click();
        }
    }

    public void resetTask() {
        this.count = 0;
        this.theGolem.getNavigator().clearPathEntity();
    }

    public void startExecuting() {
        this.count = 200;
        this.theGolem.getNavigator().tryMoveToXYZ((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, (double)this.theGolem.getAIMoveSpeed());
    }

    void click() {
        ChunkCoordinates home = this.theGolem.getHomePosition();
        boolean ignoreItem = false;
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        int cX = home.posX - facing.offsetX;
        int cY = home.posY - facing.offsetY;
        int cZ = home.posZ - facing.offsetZ;
        TileEntity tile = this.theGolem.worldObj.getTileEntity(cX, cY, cZ);
        if (tile == null || !(tile instanceof IInventory)) {
            ignoreItem = true;
        }
        this.player.setPositionAndRotation(this.theGolem.posX, this.theGolem.posY, this.theGolem.posZ, this.theGolem.rotationYaw, this.theGolem.rotationPitch);
        this.player.setCurrentItemOrArmor(0, this.theGolem.itemCarried);
        this.player.setSneaking(this.theGolem.getToggles()[2]);
        Iterator<Integer> i$ = GolemHelper.getMarkedSides(this.theGolem, this.xx, this.yy, this.zz, this.theGolem.worldObj.provider.dimensionId, (byte)this.color).iterator();
        if (i$.hasNext()) {
            Integer side = i$.next();
            int x = 0;
            int y = 0;
            int z = 0;
            if (this.theGolem.worldObj.isAirBlock(this.xx, this.yy, this.zz)) {
                x = ForgeDirection.getOrientation((int)side.intValue()).getOpposite().offsetX;
                y = ForgeDirection.getOrientation((int)side.intValue()).getOpposite().offsetY;
                z = ForgeDirection.getOrientation((int)side.intValue()).getOpposite().offsetZ;
            }
            if (this.im == null) {
                this.im = new ItemInWorldManager(this.theGolem.worldObj);
            }
            if (this.theGolem.itemCarried == null && !ignoreItem) {
                this.resetTask();
                return;
            }
            try {
                if (this.theGolem.getToggles()[1]) {
                    this.theGolem.startLeftArmTimer();
                    this.im.onBlockClicked(this.xx + x, this.yy + y, this.zz + z, side.intValue());
                } else if (this.im.activateBlockOrUseItem((EntityPlayer)this.player, this.theGolem.worldObj, this.theGolem.itemCarried, this.xx + x, this.yy + y, this.zz + z, side.intValue(), 0.5f, 0.5f, 0.5f)) {
                    this.theGolem.startRightArmTimer();
                }
                this.theGolem.itemCarried = this.player.getCurrentEquippedItem();
                if (this.theGolem.itemCarried.stackSize <= 0) {
                    this.theGolem.itemCarried = null;
                }
                for (int a = 1; a < this.player.inventory.mainInventory.length; ++a) {
                    if (this.player.inventory.getStackInSlot(a) == null) continue;
                    if (this.theGolem.itemCarried == null) {
                        this.theGolem.itemCarried = this.player.inventory.getStackInSlot(a).copy();
                    } else {
                        this.player.dropPlayerItemWithRandomChoice(this.player.inventory.getStackInSlot(a), false);
                    }
                    this.player.inventory.setInventorySlotContents(a, null);
                }
                this.theGolem.updateCarried();
                this.resetTask();
                return;
            }
            catch (Exception e) {
                this.resetTask();
                return;
            }
        }
    }

    boolean findSomething() {
        ArrayList<Byte> matchingColors = this.theGolem.getColorsMatching(this.theGolem.itemCarried);
        for (byte col : matchingColors) {
            ArrayList<Marker> markers = this.theGolem.getMarkers();
            for (Marker marker : markers) {
                if (marker.color != col && col != -1 || this.theGolem.getToggles()[0] && !this.theGolem.worldObj.isAirBlock(marker.x, marker.y, marker.z) || !this.theGolem.getToggles()[0] && this.theGolem.worldObj.isAirBlock(marker.x, marker.y, marker.z)) continue;
                ForgeDirection opp = ForgeDirection.getOrientation((int)marker.side);
                if (!this.theGolem.worldObj.isAirBlock(marker.x + opp.offsetX, marker.y + opp.offsetY, marker.z + opp.offsetZ)) continue;
                this.color = col;
                this.xx = marker.x;
                this.yy = marker.y;
                this.zz = marker.z;
                this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
                this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
                return true;
            }
        }
        return false;
    }
}

