/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.interact;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.BlockCoordinates;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.EntityUtils;

public class AIHarvestCrops
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int xx;
    private int yy;
    private int zz;
    private float movementSpeed;
    private float distance;
    private World theWorld;
    private Block block = Blocks.air;
    private int blockMd = 0;
    private int delay = -1;
    private int maxDelay = 1;
    private int mod = 1;
    private int count = 0;
    ArrayList<BlockCoordinates> checklist = new ArrayList();

    public AIHarvestCrops(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(3);
        this.distance = MathHelper.ceiling_float_int((float)(this.theGolem.getRange() / 4.0f));
    }

    public boolean shouldExecute() {
        if (this.delay >= 0 || this.theGolem.ticksExisted % Config.golemDelay > 0 || !this.theGolem.getNavigator().noPath()) {
            return false;
        }
        Vec3 var1 = this.findGrownCrop();
        if (var1 == null) {
            return false;
        }
        this.xx = (int)var1.xCoord;
        this.yy = (int)var1.yCoord;
        this.zz = (int)var1.zCoord;
        this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
        this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
        return true;
    }

    public boolean continueExecuting() {
        return this.theWorld.getBlock(this.xx, this.yy, this.zz) == this.block && this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz) == this.blockMd && this.count-- > 0 && (this.delay > 0 || !this.theGolem.getNavigator().noPath());
    }

    public void updateTask() {
        double dist = this.theGolem.getDistanceSq((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5);
        this.theGolem.getLookHelper().setLookPosition((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, 30.0f, 30.0f);
        if (dist <= 4.0) {
            if (this.delay < 0) {
                this.maxDelay = this.delay = (int)Math.max(10.0f, (20.0f - (float)this.theGolem.getGolemStrength() * 2.0f) * this.block.getBlockHardness(this.theWorld, this.xx, this.yy, this.zz));
                this.mod = this.delay / Math.round((float)this.delay / 6.0f);
            }
            if (this.delay > 0) {
                if (--this.delay > 0 && this.delay % this.mod == 0 && this.theGolem.getNavigator().noPath()) {
                    this.theGolem.startActionTimer();
                    this.theWorld.playSoundEffect((double)((float)this.xx + 0.5f), (double)((float)this.yy + 0.5f), (double)((float)this.zz + 0.5f), this.block.stepSound.getBreakSound(), (this.block.stepSound.getVolume() + 0.7f) / 8.0f, this.block.stepSound.getPitch() * 0.5f);
                    BlockUtils.destroyBlockPartially(this.theWorld, this.theGolem.getEntityId(), this.xx, this.yy, this.zz, (int)(9.0f * (1.0f - (float)this.delay / (float)this.maxDelay)));
                }
                if (this.delay == 0) {
                    this.harvest();
                    this.checkAdjacent();
                }
            }
        }
    }

    private void checkAdjacent() {
        for (int x2 = -2; x2 <= 2; ++x2) {
            for (int z2 = -2; z2 <= 2; ++z2) {
                for (int y2 = -1; y2 <= 1; ++y2) {
                    Vec3 var1;
                    int x = this.xx + x2;
                    int y = this.yy + y2;
                    int z = this.zz + z2;
                    if ((float)Math.abs(this.theGolem.getHomePosition().posX - x) > this.distance || (float)Math.abs(this.theGolem.getHomePosition().posY - y) > this.distance || (float)Math.abs(this.theGolem.getHomePosition().posZ - z) > this.distance || !CropUtils.isGrownCrop(this.theWorld, x, y, z) || (var1 = Vec3.createVectorHelper((double)x, (double)y, (double)z)) == null) continue;
                    this.xx = (int)var1.xCoord;
                    this.yy = (int)var1.yCoord;
                    this.zz = (int)var1.zCoord;
                    this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
                    this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
                    this.delay = -1;
                    this.startExecuting();
                    return;
                }
            }
        }
    }

    public void resetTask() {
        BlockUtils.destroyBlockPartially(this.theWorld, this.theGolem.getEntityId(), this.xx, this.yy, this.zz, -1);
        this.delay = -1;
    }

    public void startExecuting() {
        this.count = 200;
        this.theGolem.getNavigator().tryMoveToXYZ((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, (double)this.theGolem.getAIMoveSpeed());
    }

    private Vec3 findGrownCrop() {
        Random rand = this.theGolem.getRNG();
        if (this.checklist.size() == 0) {
            int a = (int)(-this.distance);
            while ((float)a <= this.distance) {
                int b = (int)(-this.distance);
                while ((float)b <= this.distance) {
                    this.checklist.add(new BlockCoordinates(this.theGolem.getHomePosition().posX + a, 0, this.theGolem.getHomePosition().posZ + b));
                    ++b;
                }
                ++a;
            }
            Collections.shuffle(this.checklist, rand);
        }
        int x = this.checklist.get((int)0).x;
        int z = this.checklist.get((int)0).z;
        this.checklist.remove(0);
        for (int y = this.theGolem.getHomePosition().posY - 3; y <= this.theGolem.getHomePosition().posY + 3; ++y) {
            if (!CropUtils.isGrownCrop(this.theWorld, x, y, z)) continue;
            return Vec3.createVectorHelper((double)x, (double)y, (double)z);
        }
        return null;
    }

    void harvest() {
        this.count = 200;
        int md = this.blockMd;
        FakePlayer fp = FakePlayerFactory.get((WorldServer)((WorldServer)this.theWorld), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
        fp.setPosition(this.theGolem.posX, this.theGolem.posY, this.theGolem.posZ);
        if (CropUtils.clickableCrops.contains(this.block.getUnlocalizedName() + md)) {
            this.block.onBlockActivated(this.theWorld, this.xx, this.yy, this.zz, (EntityPlayer)fp, 0, 0.0f, 0.0f, 0.0f);
        } else {
            this.theWorld.func_147480_a(this.xx, this.yy, this.zz, true);
            if (this.theGolem.getUpgradeAmount(4) > 0) {
                ArrayList items = new ArrayList();
                ArrayList<Entity> drops = EntityUtils.getEntitiesInRange(this.theWorld, this.theGolem.posX, this.theGolem.posY, this.theGolem.posZ, (Entity)this.theGolem, EntityItem.class, 6.0);
                if (drops.size() > 0) {
                    for (Entity e : drops) {
                        if (!(e instanceof EntityItem)) continue;
                        if (e.ticksExisted < 2) {
                            Vec3 v = Vec3.createVectorHelper((double)(e.posX - this.theGolem.posX), (double)(e.posY - this.theGolem.posY), (double)(e.posZ - this.theGolem.posZ));
                            v = v.normalize();
                            e.motionX = -v.xCoord / 4.0;
                            e.motionY = 0.075;
                            e.motionZ = -v.zCoord / 4.0;
                        }
                        boolean done = false;
                        EntityItem item = (EntityItem)e;
                        ItemStack st = item.getEntityItem();
                        if (st.getItem() != null && st.getItem() == Items.dye && st.getItemDamage() == 3) {
                            int par4;
                            int var5 = BlockDirectional.getDirection((int)this.blockMd);
                            int par2 = this.xx + Direction.offsetX[var5];
                            Block var6 = this.theWorld.getBlock(par2, this.yy, par4 = this.zz + Direction.offsetZ[var5]);
                            if (var6 == Blocks.log && BlockLog.func_150165_c((int)this.theWorld.getBlockMetadata(par2, this.yy, par4)) == 3) {
                                --st.stackSize;
                                this.theWorld.setBlock(this.xx, this.yy, this.zz, Blocks.cocoa, BlockDirectional.getDirection((int)this.blockMd), 3);
                            }
                            done = true;
                        } else if (st.getItem() != null && st.getItem() == ConfigItems.itemManaBean) {
                            if (this.block.canPlaceBlockOnSide(this.theWorld, this.xx, this.yy, this.zz, 0)) {
                                --st.stackSize;
                                if (!st.getItem().onItemUse(st.copy(), (EntityPlayer)fp, this.theWorld, this.xx, this.yy + 1, this.zz, 0, 0.5f, 0.5f, 0.5f)) {
                                    this.theWorld.setBlock(this.xx, this.yy, this.zz, ConfigBlocks.blockManaPod, 0, 3);
                                }
                            }
                            done = true;
                        } else {
                            int[] xm = new int[]{0, 0, 1, 1, -1, 0, -1, -1, 1};
                            int[] zm = new int[]{0, 1, 0, 1, 0, -1, -1, 1, -1};
                            for (int count = 0; st != null && st.stackSize > 0 && count < 9; ++count) {
                                if (st.getItem() == null || !(st.getItem() instanceof IPlantable) && !(st.getItem() instanceof ItemSeedFood) || !st.getItem().onItemUse(st.copy(), (EntityPlayer)fp, this.theWorld, this.xx + xm[count], this.yy - 1, this.zz + zm[count], ForgeDirection.UP.ordinal(), 0.5f, 0.5f, 0.5f)) continue;
                                --st.stackSize;
                            }
                        }
                        if (st.stackSize <= 0) {
                            item.setDead();
                        } else {
                            item.setEntityItemStack(st);
                        }
                        if (!done) continue;
                        break;
                    }
                }
            }
        }
        fp.setDead();
        this.theGolem.startActionTimer();
    }
}

