/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.interact;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.EntityGolemBobber;

public class AIFish
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private float quality;
    private float distance;
    private World theWorld;
    private int maxDelay = 1;
    private int mod = 1;
    private int count = 0;
    private Vec3 target = null;
    private EntityGolemBobber bobber = null;
    private static final List LOOTCRAP = Arrays.asList(new WeightedRandomFishable(new ItemStack((Item)Items.leather_boots), 10).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.leather), 10), new WeightedRandomFishable(new ItemStack(Items.bone), 10), new WeightedRandomFishable(new ItemStack((Item)Items.potionitem), 10), new WeightedRandomFishable(new ItemStack(Items.string), 5), new WeightedRandomFishable(new ItemStack((Item)Items.fishing_rod), 2).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.bowl), 10), new WeightedRandomFishable(new ItemStack(Items.stick), 5), new WeightedRandomFishable(new ItemStack(Items.dye, 10, 0), 5), new WeightedRandomFishable(new ItemStack((Block)Blocks.tripwire_hook), 10), new WeightedRandomFishable(new ItemStack(Items.rotten_flesh), 10));
    private static final List LOOTRARE = Arrays.asList(new WeightedRandomFishable(new ItemStack(Blocks.waterlily), 1), new WeightedRandomFishable(new ItemStack(Items.name_tag), 1), new WeightedRandomFishable(new ItemStack(Items.saddle), 1), new WeightedRandomFishable(new ItemStack((Item)Items.bow), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack((Item)Items.fishing_rod), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack(Items.book), 1).func_150707_a());
    private static final List LOOTFISH = Arrays.asList(new WeightedRandomFishable(new ItemStack(Items.fish, 1, ItemFishFood.FishType.COD.func_150976_a()), 60), new WeightedRandomFishable(new ItemStack(Items.fish, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25), new WeightedRandomFishable(new ItemStack(Items.fish, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2), new WeightedRandomFishable(new ItemStack(Items.fish, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));

    public AIFish(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(3);
        this.distance = MathHelper.ceiling_float_int((float)(this.theGolem.getRange() / 2.0f));
    }

    public boolean shouldExecute() {
        Vec3 vv;
        if (this.target != null || this.count > 0 || this.theGolem.ticksExisted % Config.golemDelay > 0 || !this.theGolem.getNavigator().noPath()) {
            return false;
        }
        if (this.bobber != null) {
            this.bobber.setDead();
        }
        if ((vv = this.findWater()) == null) {
            return false;
        }
        this.target = Vec3.createVectorHelper((double)vv.xCoord, (double)vv.yCoord, (double)vv.zCoord);
        this.quality = 0.0f;
        int x = (int)this.target.xCoord;
        int y = (int)this.target.yCoord;
        int z = (int)this.target.zCoord;
        for (int a = 2; a <= 5; ++a) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)a);
            if (this.theWorld.getBlock(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).getMaterial() != Material.water || !this.theWorld.isAirBlock(x + dir.offsetX, y + 1 + dir.offsetY, z + dir.offsetZ)) continue;
            this.quality += 3.0E-5f;
            if (this.theWorld.canBlockSeeTheSky(x + dir.offsetX, y + 1 + dir.offsetY, z + dir.offsetZ)) {
                this.quality += 3.0E-5f;
            }
            for (int depth = 1; depth <= 3; ++depth) {
                if (this.theWorld.getBlock(x + dir.offsetX, y - depth + dir.offsetY, z + dir.offsetZ).getMaterial() != Material.water) continue;
                this.quality += 1.5E-5f;
            }
        }
        this.theWorld.playSoundAtEntity((Entity)this.theGolem, "random.bow", 0.5f, 0.4f / (this.theWorld.rand.nextFloat() * 0.4f + 0.8f));
        this.bobber = new EntityGolemBobber(this.theWorld, this.theGolem, x, y, z);
        return this.theWorld.spawnEntityInWorld((Entity)this.bobber);
    }

    public boolean continueExecuting() {
        return this.bobber != null && !this.bobber.isDead && this.target != null && this.count-- > 0;
    }

    public void updateTask() {
        if (this.target != null) {
            this.theGolem.getLookHelper().setLookPosition(this.target.xCoord + 0.5, this.target.yCoord + 1.0, this.target.zCoord + 0.5, 30.0f, 30.0f);
            float chance = this.quality + (float)this.theGolem.getGolemStrength() * 1.5E-4f;
            if (this.theWorld.rand.nextFloat() < chance) {
                this.theGolem.startRightArmTimer();
                int qq = 1;
                if (this.theGolem.getUpgradeAmount(0) > 0 && this.theWorld.rand.nextInt(10) < this.theGolem.getUpgradeAmount(0)) {
                    ++qq;
                }
                for (int a = 0; a < qq; ++a) {
                    ItemStack sr;
                    ItemStack fs = this.getFishingResult();
                    if (this.theGolem.getUpgradeAmount(2) > 0 && (sr = FurnaceRecipes.smelting().getSmeltingResult(fs)) != null) {
                        fs = sr.copy();
                    }
                    EntityItem entityitem = new EntityItem(this.theWorld, this.target.xCoord + 0.5, this.target.yCoord + 1.0, this.target.zCoord + 0.5, fs);
                    if (this.theGolem.getUpgradeAmount(2) > 0) {
                        entityitem.setFire(2);
                    }
                    entityitem.delayBeforeCanPickup = 20;
                    double d1 = this.theGolem.posX + (double)this.theWorld.rand.nextFloat() - (double)this.theWorld.rand.nextFloat() - this.target.xCoord + 0.5;
                    double d3 = this.theGolem.posY - this.target.yCoord + 1.0;
                    double d5 = this.theGolem.posZ + (double)this.theWorld.rand.nextFloat() - (double)this.theWorld.rand.nextFloat() - this.target.zCoord + 0.5;
                    double d7 = MathHelper.sqrt_double((double)(d1 * d1 + d3 * d3 + d5 * d5));
                    double d9 = 0.1;
                    entityitem.motionX = d1 * d9;
                    entityitem.motionY = d3 * d9 + (double)MathHelper.sqrt_double((double)d7) * 0.08;
                    entityitem.motionZ = d5 * d9;
                    this.theWorld.spawnEntityInWorld((Entity)entityitem);
                }
                if (this.bobber != null) {
                    this.bobber.playSound("random.splash", 0.15f, 1.0f + (this.theWorld.rand.nextFloat() - this.theWorld.rand.nextFloat()) * 0.4f);
                    ((WorldServer)this.theWorld).func_147487_a("splash", this.bobber.posX, this.bobber.posY + 0.5, this.bobber.posZ, 20 + this.theWorld.rand.nextInt(20), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    this.bobber.setDead();
                }
                this.target = null;
            }
        }
    }

    public void resetTask() {
        if (this.bobber != null) {
            this.bobber.setDead();
        }
        this.target = null;
        this.count = -1;
    }

    public void startExecuting() {
        this.count = 300 + this.theWorld.rand.nextInt(200);
        this.theGolem.startRightArmTimer();
    }

    private Vec3 findWater() {
        Random rand = this.theGolem.getRNG();
        int var2 = 0;
        while ((float)var2 < this.distance * 2.0f) {
            int z;
            int y;
            int x = (int)((float)(this.theGolem.getHomePosition().posX + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance);
            if (this.theWorld.getBlock(x, y = (int)((float)(this.theGolem.getHomePosition().posY + rand.nextInt((int)(1.0f + this.distance))) - this.distance / 2.0f), z = (int)((float)(this.theGolem.getHomePosition().posZ + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance)).getMaterial() == Material.water && this.theWorld.isAirBlock(x, y + 1, z)) {
                Vec3 v = Vec3.createVectorHelper((double)x, (double)y, (double)z);
                return v;
            }
            ++var2;
        }
        return null;
    }

    private ItemStack getFishingResult() {
        float f = this.theWorld.rand.nextFloat();
        float f1 = 0.1f - (float)this.theGolem.getUpgradeAmount(5) * 0.025f;
        float f2 = 0.05f + (float)this.theGolem.getUpgradeAmount(4) * 0.0125f;
        int x = (int)this.target.xCoord;
        int y = (int)this.target.yCoord;
        int z = (int)this.target.zCoord;
        for (int a = 2; a <= 5; ++a) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)a);
            if (this.theWorld.getBlock(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).getMaterial() != Material.water || !this.theWorld.isAirBlock(x + dir.offsetX, y + 1 + dir.offsetY, z + dir.offsetZ)) continue;
            f1 -= 0.005f;
            f2 += 0.00125f;
            if (this.theWorld.canBlockSeeTheSky(x + dir.offsetX, y + 1 + dir.offsetY, z + dir.offsetZ)) {
                f1 -= 0.005f;
                f2 += 0.00125f;
            }
            for (int depth = 1; depth <= 3; ++depth) {
                if (this.theWorld.getBlock(x + dir.offsetX, y - depth + dir.offsetY, z + dir.offsetZ).getMaterial() != Material.water) continue;
                f2 += 0.001f;
            }
        }
        f1 = MathHelper.clamp_float((float)f1, (float)0.0f, (float)1.0f);
        f2 = MathHelper.clamp_float((float)f2, (float)0.0f, (float)1.0f);
        if (f < f1) {
            return ((WeightedRandomFishable)WeightedRandom.getRandomItem((Random)this.theWorld.rand, (Collection)LOOTCRAP)).func_150708_a(this.theWorld.rand);
        }
        if ((f -= f1) < f2) {
            return ((WeightedRandomFishable)WeightedRandom.getRandomItem((Random)this.theWorld.rand, (Collection)LOOTRARE)).func_150708_a(this.theWorld.rand);
        }
        float f3 = f - f2;
        return ((WeightedRandomFishable)WeightedRandom.getRandomItem((Random)this.theWorld.rand, (Collection)LOOTFISH)).func_150708_a(this.theWorld.rand);
    }
}

