/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.combat;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class AIDartAttack
extends EntityAIBase {
    private final EntityGolemBase theGolem;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = 0;
    private int maxRangedAttackTime;

    public AIDartAttack(EntityGolemBase par1IRangedAttackMob) {
        this.theGolem = par1IRangedAttackMob;
        this.maxRangedAttackTime = 30 - this.theGolem.getUpgradeAmount(0) * 8;
        this.rangedAttackTime = this.maxRangedAttackTime / 2;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase var1 = this.theGolem.getAttackTarget();
        if (var1 == null) {
            return false;
        }
        if (!this.theGolem.isValidTarget((Entity)var1)) {
            this.theGolem.setAttackTarget(null);
            return false;
        }
        double ra = this.theGolem.getDistanceSq(var1.posX, var1.boundingBox.minY, var1.posZ);
        if (ra < 9.0) {
            return false;
        }
        this.attackTarget = var1;
        return true;
    }

    public boolean continueExecuting() {
        return this.shouldExecute() && !this.theGolem.getNavigator().noPath();
    }

    public void resetTask() {
        this.attackTarget = null;
        this.rangedAttackTime = this.maxRangedAttackTime / 2;
    }

    public void updateTask() {
        double var1 = this.theGolem.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean var3 = this.theGolem.getEntitySenses().canSee((Entity)this.attackTarget);
        this.theGolem.getNavigator().tryMoveToEntityLiving((Entity)this.attackTarget, (double)this.theGolem.getAIMoveSpeed());
        if (var3) {
            this.theGolem.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
            this.rangedAttackTime = Math.max(this.rangedAttackTime - 1, 0);
            if (this.rangedAttackTime <= 0) {
                float r = this.theGolem.getRange() * 0.8f;
                if (var1 <= (double)(r *= r) && var3) {
                    this.theGolem.attackEntityWithRangedAttack(this.attackTarget);
                    this.rangedAttackTime = this.maxRangedAttackTime;
                }
            }
        }
    }
}

