/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.combat;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class AIAvoidCreeperSwell
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private float farSpeed;
    private float nearSpeed;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private PathEntity entityPathEntity;
    private PathNavigate entityPathNavigate;
    Vec3 targetBlock;

    public AIAvoidCreeperSwell(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.distanceFromEntity = 5.0f;
        this.entityPathNavigate = par1EntityCreature.getNavigator();
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        List var1;
        if (this.farSpeed == 0.0f) {
            this.farSpeed = this.theGolem.getAIMoveSpeed() * 1.125f;
            this.nearSpeed = this.theGolem.getAIMoveSpeed() * 1.25f;
        }
        if ((var1 = this.theGolem.worldObj.getEntitiesWithinAABB(EntityCreeper.class, this.theGolem.boundingBox.expand((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity))).isEmpty()) {
            return false;
        }
        if (((EntityCreeper)var1.get(0)).getCreeperState() != 1) {
            return false;
        }
        this.closestLivingEntity = (Entity)var1.get(0);
        if (!this.theGolem.getEntitySenses().canSee(this.closestLivingEntity)) {
            return false;
        }
        Vec3 var2 = RandomPositionGenerator.findRandomTargetBlockAwayFrom((EntityCreature)this.theGolem, (int)16, (int)7, (Vec3)Vec3.createVectorHelper((double)this.closestLivingEntity.posX, (double)this.closestLivingEntity.posY, (double)this.closestLivingEntity.posZ));
        if (var2 == null) {
            return false;
        }
        if (this.closestLivingEntity.getDistanceSq(var2.xCoord, var2.yCoord, var2.zCoord) < this.closestLivingEntity.getDistanceSqToEntity((Entity)this.theGolem)) {
            return false;
        }
        this.entityPathEntity = this.entityPathNavigate.getPathToXYZ(var2.xCoord, var2.yCoord, var2.zCoord);
        this.targetBlock = var2;
        return this.entityPathEntity == null ? false : this.entityPathEntity.isDestinationSame(var2);
    }

    public boolean continueExecuting() {
        return !this.entityPathNavigate.noPath();
    }

    public void startExecuting() {
        double var1 = this.targetBlock.xCoord + 0.5 - this.theGolem.posX;
        double var3 = this.targetBlock.zCoord + 0.5 - this.theGolem.posZ;
        float var5 = MathHelper.sqrt_double((double)(var1 * var1 + var3 * var3));
        this.theGolem.motionX += var1 / (double)var5 * 1.0 * (double)0.8f + this.theGolem.motionX * (double)0.2f;
        this.theGolem.motionZ += var3 / (double)var5 * 1.0 * (double)0.8f + this.theGolem.motionZ * (double)0.2f;
        this.theGolem.motionY = 0.3;
        this.entityPathNavigate.setPath(this.entityPathEntity, (double)this.nearSpeed);
    }

    public void resetTask() {
        this.closestLivingEntity = null;
    }

    public void updateTask() {
        if (this.theGolem.getDistanceSqToEntity(this.closestLivingEntity) < 49.0) {
            this.theGolem.getNavigator().setSpeed((double)this.nearSpeed);
        } else {
            this.theGolem.getNavigator().setSpeed((double)this.farSpeed);
        }
    }
}

