/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.common.entities.golems.EntityTravelingTrunk;

public class InventoryMob
implements IInventory {
    public ItemStack[] inventory;
    public Entity ent;
    public boolean inventoryChanged;
    public int slotCount;
    public int stacklimit = 64;

    public InventoryMob(Entity entity, int slots) {
        this.slotCount = slots;
        this.inventory = new ItemStack[this.slotCount];
        this.inventoryChanged = false;
        this.ent = entity;
    }

    public InventoryMob(Entity entity, int slots, int lim) {
        this.slotCount = slots;
        this.inventory = new ItemStack[this.slotCount];
        this.inventoryChanged = false;
        this.stacklimit = lim;
        this.ent = entity;
    }

    public int getInventorySlotContainItem(Item i) {
        for (int j = 0; j < this.inventory.length; ++j) {
            if (this.inventory[j] == null || this.inventory[j].getItem() != i) continue;
            return j;
        }
        return -1;
    }

    public int storeItemStack(ItemStack itemstack) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.inventory[i].getItem() != itemstack.getItem() || !this.inventory[i].isStackable() || this.inventory[i].stackSize >= this.inventory[i].getMaxStackSize() || this.inventory[i].stackSize >= this.getInventoryStackLimit() || this.inventory[i].getHasSubtypes() && this.inventory[i].getItemDamage() != itemstack.getItemDamage()) continue;
            return i;
        }
        return -1;
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int storePartialItemStack(ItemStack itemstack) {
        int l;
        Item i = itemstack.getItem();
        int j = itemstack.stackSize;
        int k = this.storeItemStack(itemstack);
        if (k < 0) {
            k = this.getFirstEmptyStack();
        }
        if (k < 0) {
            return j;
        }
        if (this.inventory[k] == null) {
            this.inventory[k] = new ItemStack(i, 0, itemstack.getItemDamage());
        }
        if ((l = j) > this.inventory[k].getMaxStackSize() - this.inventory[k].stackSize) {
            l = this.inventory[k].getMaxStackSize() - this.inventory[k].stackSize;
        }
        if (l > this.getInventoryStackLimit() - this.inventory[k].stackSize) {
            l = this.getInventoryStackLimit() - this.inventory[k].stackSize;
        }
        if (l == 0) {
            return j;
        }
        this.inventory[k].stackSize += l;
        this.inventory[k].animationsToGo = 5;
        return j -= l;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i;
            do {
                i = itemstack.stackSize;
                itemstack.stackSize = this.storePartialItemStack(itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i);
            return itemstack.stackSize < i;
        }
        int j = this.getFirstEmptyStack();
        if (j >= 0) {
            this.inventory[j] = ItemStack.copyItemStack((ItemStack)itemstack);
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack[] aitemstack = this.inventory;
        if (aitemstack[i] != null) {
            if (aitemstack[i].stackSize <= j) {
                ItemStack itemstack = aitemstack[i];
                aitemstack[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i].splitStack(j);
            if (aitemstack[i].stackSize == 0) {
                aitemstack[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        ItemStack[] aitemstack = this.inventory;
        aitemstack[i] = itemstack;
    }

    public NBTTagList writeToNBT(NBTTagList nbttaglist) {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(nbttagcompound);
            nbttaglist.appendTag((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public void readFromNBT(NBTTagList nbttaglist) {
        this.inventory = new ItemStack[this.slotCount];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
            if (itemstack.getItem() == null || j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = itemstack;
        }
    }

    public int getSizeInventory() {
        return this.inventory.length + 1;
    }

    public ItemStack getStackInSlot(int i) {
        ItemStack[] aitemstack = this.inventory;
        return aitemstack[i];
    }

    public int getInventoryStackLimit() {
        return this.stacklimit;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.ent.isDead) {
            return false;
        }
        return entityplayer.getDistanceSqToEntity(this.ent) <= 64.0;
    }

    public boolean func_28018_c(ItemStack itemstack) {
        for (int j = 0; j < this.inventory.length; ++j) {
            if (this.inventory[j] == null || !ItemStack.areItemStacksEqual((ItemStack)this.inventory[j], (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    public void dropAllItems() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            this.ent.entityDropItem(this.inventory[i], 0.0f);
            this.inventory[i] = null;
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public boolean hasSomething() {
        for (int a = 0; a < this.slotCount; ++a) {
            if (this.inventory[a] == null) continue;
            return true;
        }
        return false;
    }

    public boolean allEmpty() {
        for (int a = 0; a < this.slotCount; ++a) {
            if (this.inventory[a] == null) continue;
            return false;
        }
        return true;
    }

    public int getAmountNeeded(ItemStack stackInSlot) {
        int amt = 0;
        for (int a = 0; a < this.slotCount; ++a) {
            if (this.inventory[a] == null || !this.inventory[a].isItemEqual(stackInSlot)) continue;
            amt += this.inventory[a].stackSize;
        }
        return amt;
    }

    public int getAmountNeededSmart(ItemStack stackInSlot, boolean fuzzy) {
        int amt = 0;
        for (int a = 0; a < this.slotCount; ++a) {
            if (this.inventory[a] == null) continue;
            if (fuzzy) {
                ItemStack[] ores;
                if (this.inventory[a].isItemEqual(stackInSlot)) {
                    amt += this.inventory[a].stackSize;
                    continue;
                }
                int od = OreDictionary.getOreID((ItemStack)this.inventory[a]);
                if (od == -1 || !ThaumcraftApiHelper.containsMatch(false, new ItemStack[]{stackInSlot}, ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]))) continue;
                amt += this.inventory[a].stackSize;
                continue;
            }
            if (!this.inventory[a].isItemEqual(stackInSlot) || !ItemStack.areItemStackTagsEqual((ItemStack)this.inventory[a], (ItemStack)stackInSlot)) continue;
            amt += this.inventory[a].stackSize;
        }
        return amt;
    }

    public ArrayList<ItemStack> getItemsNeeded(boolean fuzzy) {
        boolean amt = false;
        ArrayList<ItemStack> needed = new ArrayList<ItemStack>();
        for (int a = 0; a < this.slotCount; ++a) {
            if (this.inventory[a] == null) continue;
            if (fuzzy) {
                int od = OreDictionary.getOreID((ItemStack)this.inventory[a]);
                if (od != -1) {
                    ItemStack[] ores;
                    for (ItemStack ore : ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0])) {
                        needed.add(ore.copy());
                    }
                    continue;
                }
                needed.add(this.inventory[a].copy());
                continue;
            }
            needed.add(this.inventory[a].copy());
        }
        return needed;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public String getInventoryName() {
        return "Inventory";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void markDirty() {
        this.inventoryChanged = true;
    }

    public void openInventory() {
        if (this.ent instanceof EntityTravelingTrunk) {
            ((EntityTravelingTrunk)this.ent).setOpen(true);
        }
    }

    public void closeInventory() {
        if (this.ent instanceof EntityTravelingTrunk) {
            ((EntityTravelingTrunk)this.ent).setOpen(false);
        }
    }
}

