/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.container.SlotLimitedByClass;
import thaumcraft.common.tiles.TileFocalManipulator;

public class ContainerFocalManipulator
extends Container {
    private TileFocalManipulator table;
    private int lastBreakTime;

    public ContainerFocalManipulator(InventoryPlayer par1InventoryPlayer, TileFocalManipulator tileEntity) {
        int i;
        this.table = tileEntity;
        this.addSlotToContainer(new SlotLimitedByClass(ItemFocusBasic.class, (IInventory)tileEntity, 0, 88, 60));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)par1InventoryPlayer, j + i * 9 + 9, 16 + j * 18, 151 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)par1InventoryPlayer, i, 16 + i * 18, 209));
        }
    }

    public boolean enchantItem(EntityPlayer p, int button) {
        if (button >= 0 && !this.table.startCraft(button, p)) {
            this.table.getWorldObj().playSoundEffect((double)this.table.xCoord, (double)this.table.yCoord, (double)this.table.zCoord, "thaumcraft:craftfail", 0.33f, 1.0f);
        }
        return false;
    }

    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        return this.table.isUseableByPlayer(par1EntityPlayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(par2);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (par2 != 0 ? (itemstack1.getItem() instanceof ItemFocusBasic ? !this.mergeItemStack(itemstack1, 0, 1, false) : (par2 >= 1 && par2 < 28 ? !this.mergeItemStack(itemstack1, 28, 37, false) : par2 >= 28 && par2 < 37 && !this.mergeItemStack(itemstack1, 1, 28, false))) : !this.mergeItemStack(itemstack1, 1, 37, false)) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize == itemstack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(par1EntityPlayer, itemstack1);
        }
        return itemstack;
    }
}

