/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import thaumcraft.common.container.SlotLimitedByClass;
import thaumcraft.common.items.wands.foci.ItemFocusExcavation;
import thaumcraft.common.tiles.TileArcaneBore;

public class ContainerArcaneBore
extends Container {
    private TileArcaneBore tileEntity;

    public ContainerArcaneBore(InventoryPlayer iinventory, TileArcaneBore e) {
        this.tileEntity = e;
        this.addSlotToContainer(new SlotLimitedByClass(ItemFocusExcavation.class, e, 0, 26, 18));
        this.addSlotToContainer(new SlotLimitedByClass(ItemPickaxe.class, e, 1, 74, 18));
        this.bindPlayerInventory(iinventory);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 59 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 117));
        }
    }

    public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
        return this.tileEntity.getWorldObj().getTileEntity(this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord) != this.tileEntity ? false : par1EntityPlayer.getDistanceSq((double)this.tileEntity.xCoord + 0.5, (double)this.tileEntity.yCoord + 0.5, (double)this.tileEntity.zCoord + 0.5) <= 64.0;
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot <= 1 ? !this.mergeItemStack(stackInSlot, 2, this.inventorySlots.size(), true) : (slot > 1 ? (stackInSlot.getItem() instanceof ItemFocusExcavation ? !this.mergeItemStack(stackInSlot, 0, 1, false) : stackInSlot.getItem() instanceof ItemPickaxe && !this.mergeItemStack(stackInSlot, 1, 2, false)) : !this.mergeItemStack(stackInSlot, 2, 38, false))) {
                return null;
            }
            if (stackInSlot.stackSize == 0) {
                slotObject.putStack(null);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.stackSize == stack.stackSize) {
                return null;
            }
        }
        return stack;
    }
}

