/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.client.renderers.block.BlockRenderer;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.items.ItemShard;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileArcaneLamp;
import thaumcraft.common.tiles.TileArcaneLampFertility;
import thaumcraft.common.tiles.TileArcaneLampGrowth;
import thaumcraft.common.tiles.TileBrainbox;
import thaumcraft.common.tiles.TileCrucible;
import thaumcraft.common.tiles.TileGrate;
import thaumcraft.common.tiles.TileMagicWorkbenchCharger;
import thaumcraft.common.tiles.TileThaumatorium;
import thaumcraft.common.tiles.TileThaumatoriumTop;
import thaumcraft.common.tiles.TileVisRelay;

public class BlockMetalDevice
extends BlockContainer {
    public IIcon[] icon = new IIcon[23];
    public IIcon iconGlow;
    private int delay = 0;

    public BlockMetalDevice() {
        super(Material.iron);
        this.setHardness(3.0f);
        this.setResistance(17.0f);
        this.setStepSound(Block.soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.icon[0] = ir.registerIcon("thaumcraft:metalbase");
        for (int a = 1; a <= 6; ++a) {
            this.icon[a] = ir.registerIcon("thaumcraft:crucible" + a);
        }
        this.icon[7] = ir.registerIcon("thaumcraft:goldbase");
        this.icon[8] = ir.registerIcon("thaumcraft:grate");
        this.icon[9] = ir.registerIcon("thaumcraft:grate_hatch");
        this.icon[10] = ir.registerIcon("thaumcraft:lamp_side");
        this.icon[11] = ir.registerIcon("thaumcraft:lamp_top");
        this.icon[12] = ir.registerIcon("thaumcraft:lamp_grow_side");
        this.icon[13] = ir.registerIcon("thaumcraft:lamp_grow_top");
        this.icon[14] = ir.registerIcon("thaumcraft:lamp_grow_side_off");
        this.icon[15] = ir.registerIcon("thaumcraft:lamp_grow_top_off");
        this.icon[16] = ir.registerIcon("thaumcraft:alchemyblock");
        this.icon[17] = ir.registerIcon("thaumcraft:brainbox");
        this.icon[18] = ir.registerIcon("thaumcraft:lamp_fert_side");
        this.icon[19] = ir.registerIcon("thaumcraft:lamp_fert_top");
        this.icon[20] = ir.registerIcon("thaumcraft:lamp_fert_side_off");
        this.icon[21] = ir.registerIcon("thaumcraft:lamp_fert_top_off");
        this.icon[22] = ir.registerIcon("thaumcraft:alchemyblockadv");
        this.iconGlow = ir.registerIcon("thaumcraft:animatedglow");
    }

    public IIcon getIcon(int i, int md) {
        if (md == 3) {
            return this.icon[22];
        }
        if (md == 7) {
            return this.icon[10];
        }
        if (md == 8) {
            return this.icon[12];
        }
        if (md == 10 || md == 9 || md == 11) {
            return this.icon[16];
        }
        if (md == 12) {
            return this.icon[17];
        }
        if (md == 13) {
            return this.icon[18];
        }
        if (md == 14 || md == 2) {
            return this.icon[0];
        }
        return md == 0 || md == 1 || md == 5 || md == 6 ? this.icon[0] : this.icon[7];
    }

    public IIcon getIcon(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        int metadata = iblockaccess.getBlockMetadata(i, j, k);
        if (metadata == 5 || metadata == 6) {
            return this.icon[8];
        }
        if (metadata == 7) {
            if (side <= 1) {
                return this.icon[11];
            }
            return this.icon[10];
        }
        if (metadata == 8) {
            TileEntity te = iblockaccess.getTileEntity(i, j, k);
            if (te != null && te instanceof TileArcaneLampGrowth) {
                if (((TileArcaneLampGrowth)te).charges > 0) {
                    if (side <= 1) {
                        return this.icon[13];
                    }
                    return this.icon[12];
                }
                if (side <= 1) {
                    return this.icon[15];
                }
                return this.icon[14];
            }
        } else if (metadata == 13) {
            TileEntity te = iblockaccess.getTileEntity(i, j, k);
            if (te != null && te instanceof TileArcaneLampFertility) {
                if (((TileArcaneLampFertility)te).charges > 0) {
                    if (side <= 1) {
                        return this.icon[19];
                    }
                    return this.icon[18];
                }
                if (side <= 1) {
                    return this.icon[21];
                }
                return this.icon[20];
            }
        } else {
            if (metadata == 10 || metadata == 9 || metadata == 11) {
                return this.icon[16];
            }
            if (metadata == 12) {
                return this.icon[17];
            }
            if (metadata == 3) {
                return this.icon[22];
            }
        }
        if (side == 1) {
            return this.icon[1];
        }
        if (side == 0) {
            return this.icon[2];
        }
        return this.icon[3];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 5));
        par3List.add(new ItemStack(par1, 1, 7));
        par3List.add(new ItemStack(par1, 1, 8));
        par3List.add(new ItemStack(par1, 1, 13));
        par3List.add(new ItemStack(par1, 1, 9));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 12));
        par3List.add(new ItemStack(par1, 1, 14));
        par3List.add(new ItemStack(par1, 1, 2));
    }

    public int getRenderType() {
        return ConfigBlocks.blockMetalDeviceRI;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        int metadata;
        if (!world.isRemote && (metadata = world.getBlockMetadata(i, j, k)) == 0) {
            TileCrucible tile = (TileCrucible)world.getTileEntity(i, j, k);
            if (tile != null && entity instanceof EntityItem && !(entity instanceof EntitySpecialItem) && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                tile.attemptSmelt((EntityItem)entity);
            } else {
                ++this.delay;
                if (this.delay < 10) {
                    return;
                }
                this.delay = 0;
                if (entity instanceof EntityLivingBase && tile != null && tile.heat > 150 && tile.tank.getFluidAmount() > 0) {
                    entity.attackEntityFrom(DamageSource.inFire, 1.0f);
                    world.playSoundEffect((double)i, (double)j, (double)k, "random.fizz", 0.4f, 2.0f + world.rand.nextFloat() * 0.4f);
                }
            }
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        int metadata = world.getBlockMetadata(i, j, k);
        if (metadata == 5 || metadata == 6) {
            this.setBlockBounds(0.0f, 0.8125f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (metadata == 7 || metadata == 8 || metadata == 13) {
            this.setBlockBounds(BlockRenderer.W4, BlockRenderer.W2, BlockRenderer.W4, BlockRenderer.W12, BlockRenderer.W14, BlockRenderer.W12);
        } else if (metadata == 10) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        } else if (metadata == 11) {
            this.setBlockBounds(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (metadata == 12) {
            this.setBlockBounds(BlockRenderer.W3, BlockRenderer.W3, BlockRenderer.W3, BlockRenderer.W13, BlockRenderer.W13, BlockRenderer.W13);
        } else if (metadata == 2) {
            this.setBlockBounds(BlockRenderer.W5, 0.5f, BlockRenderer.W5, BlockRenderer.W11, 1.0f, BlockRenderer.W11);
        } else if (metadata == 14) {
            TileEntity te = world.getTileEntity(i, j, k);
            if (te != null && te instanceof TileVisRelay) {
                switch (ForgeDirection.getOrientation((int)((TileVisRelay)te).orientation).getOpposite()) {
                    case UP: {
                        this.setBlockBounds(BlockRenderer.W5, 0.5f, BlockRenderer.W5, BlockRenderer.W11, 1.0f, BlockRenderer.W11);
                        break;
                    }
                    case DOWN: {
                        this.setBlockBounds(BlockRenderer.W5, 0.0f, BlockRenderer.W5, BlockRenderer.W11, 0.5f, BlockRenderer.W11);
                        break;
                    }
                    case EAST: {
                        this.setBlockBounds(0.5f, BlockRenderer.W5, BlockRenderer.W5, 1.0f, BlockRenderer.W11, BlockRenderer.W11);
                        break;
                    }
                    case WEST: {
                        this.setBlockBounds(0.0f, BlockRenderer.W5, BlockRenderer.W5, 0.5f, BlockRenderer.W11, BlockRenderer.W11);
                        break;
                    }
                    case SOUTH: {
                        this.setBlockBounds(BlockRenderer.W5, BlockRenderer.W5, 0.5f, BlockRenderer.W11, BlockRenderer.W11, 1.0f);
                        break;
                    }
                    case NORTH: {
                        this.setBlockBounds(BlockRenderer.W5, BlockRenderer.W5, 0.0f, BlockRenderer.W11, BlockRenderer.W11, 0.5f);
                    }
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        super.setBlockBoundsBasedOnState(world, i, j, k);
    }

    public void addCollisionBoxesToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        int metadata = world.getBlockMetadata(i, j, k);
        if (metadata == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            float f = 0.125f;
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 0.85f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.85f, f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 0.85f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 0.85f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else if (metadata == 2) {
            this.setBlockBounds(BlockRenderer.W5, 0.5f, BlockRenderer.W5, BlockRenderer.W11, 1.0f, BlockRenderer.W11);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else if (metadata == 5) {
            if (par7Entity != null && !(par7Entity instanceof EntityItem)) {
                this.setBlockBounds(0.0f, 0.8125f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        } else if (metadata == 6) {
            this.setBlockBounds(0.0f, 0.8125f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else if (metadata == 7 || metadata == 8 || metadata == 13) {
            this.setBlockBounds(BlockRenderer.W4, BlockRenderer.W2, BlockRenderer.W4, BlockRenderer.W12, BlockRenderer.W14, BlockRenderer.W12);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else if (metadata == 12) {
            this.setBlockBounds(BlockRenderer.W3, BlockRenderer.W3, BlockRenderer.W3, BlockRenderer.W13, BlockRenderer.W13, BlockRenderer.W13);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        } else if (metadata == 14) {
            TileEntity te = world.getTileEntity(i, j, k);
            if (te != null && te instanceof TileVisRelay) {
                switch (ForgeDirection.getOrientation((int)((TileVisRelay)te).orientation).getOpposite()) {
                    case UP: {
                        this.setBlockBounds(BlockRenderer.W5, 0.5f, BlockRenderer.W5, BlockRenderer.W11, 1.0f, BlockRenderer.W11);
                        break;
                    }
                    case DOWN: {
                        this.setBlockBounds(BlockRenderer.W5, 0.0f, BlockRenderer.W5, BlockRenderer.W11, 0.5f, BlockRenderer.W11);
                        break;
                    }
                    case EAST: {
                        this.setBlockBounds(0.5f, BlockRenderer.W5, BlockRenderer.W5, 1.0f, BlockRenderer.W11, BlockRenderer.W11);
                        break;
                    }
                    case WEST: {
                        this.setBlockBounds(0.0f, BlockRenderer.W5, BlockRenderer.W5, 0.5f, BlockRenderer.W11, BlockRenderer.W11);
                        break;
                    }
                    case SOUTH: {
                        this.setBlockBounds(BlockRenderer.W5, BlockRenderer.W5, 0.5f, BlockRenderer.W11, BlockRenderer.W11, 1.0f);
                        break;
                    }
                    case NORTH: {
                        this.setBlockBounds(BlockRenderer.W5, BlockRenderer.W5, 0.0f, BlockRenderer.W11, BlockRenderer.W11, 0.5f);
                    }
                }
                super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int i, int j, int k, Random r) {
        TileEntity te;
        if (r.nextInt(10) == 0 && (te = w.getTileEntity(i, j, k)) != null && te instanceof TileCrucible && ((TileCrucible)te).tank.getFluidAmount() > 0 && ((TileCrucible)te).heat > 150) {
            w.playSound((double)i, (double)j, (double)k, "liquid.lavapop", 0.1f + r.nextFloat() * 0.1f, 1.2f + r.nextFloat() * 0.2f, false);
        }
    }

    public int damageDropped(int metadata) {
        if (metadata == 6) {
            return 5;
        }
        if (metadata == 10 || metadata == 11) {
            return 9;
        }
        return metadata;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileCrucible();
        }
        if (metadata == 5) {
            return new TileGrate();
        }
        if (metadata == 6) {
            return new TileGrate();
        }
        if (metadata == 1) {
            return new TileAlembic();
        }
        if (metadata == 7) {
            return new TileArcaneLamp();
        }
        if (metadata == 8) {
            return new TileArcaneLampGrowth();
        }
        if (metadata == 10) {
            return new TileThaumatorium();
        }
        if (metadata == 11) {
            return new TileThaumatoriumTop();
        }
        if (metadata == 12) {
            return new TileBrainbox();
        }
        if (metadata == 13) {
            return new TileArcaneLampFertility();
        }
        if (metadata == 14) {
            return new TileVisRelay();
        }
        if (metadata == 2) {
            return new TileMagicWorkbenchCharger();
        }
        return super.createTileEntity(world, metadata);
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int rs) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileThaumatorium) {
            return Container.calcRedstoneFromInventory((IInventory)((IInventory)te));
        }
        if (te != null && te instanceof TileAlembic) {
            float r = (float)((TileAlembic)te).amount / (float)((TileAlembic)te).maxAmount;
            return MathHelper.floor_float((float)(r * 14.0f)) + (((TileAlembic)te).amount > 0 ? 1 : 0);
        }
        if (te != null && te instanceof TileCrucible) {
            float f = ((TileCrucible)te).aspects.visSize();
            ((TileCrucible)te).getClass();
            float r = f / 100.0f;
            return MathHelper.floor_float((float)(r * 14.0f)) + (((TileCrucible)te).aspects.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    public TileEntity createNewTileEntity(World var1, int md) {
        return null;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block nbid) {
        TileEntity te = world.getTileEntity(x, y, z);
        int md = world.getBlockMetadata(x, y, z);
        if (te != null && te instanceof TileCrucible) {
            ((TileCrucible)te).getBellows();
        }
        if (!world.isRemote) {
            TileEntity tile;
            TileThaumcraft telb;
            if (te != null && te instanceof TileAlembic) {
                world.markBlockForUpdate(x, y, z);
            } else if (te != null && te instanceof TileArcaneLamp) {
                telb = (TileArcaneLamp)te;
                if (world.isAirBlock(x + telb.facing.offsetX, y + telb.facing.offsetY, z + telb.facing.offsetZ)) {
                    this.dropBlockAsItem(world, x, y, z, 7, 0);
                    world.setBlockToAir(x, y, z);
                }
            } else if (te != null && te instanceof TileArcaneLampGrowth) {
                telb = (TileArcaneLampGrowth)te;
                if (world.isAirBlock(x + ((TileArcaneLampGrowth)telb).facing.offsetX, y + ((TileArcaneLampGrowth)telb).facing.offsetY, z + ((TileArcaneLampGrowth)telb).facing.offsetZ)) {
                    this.dropBlockAsItem(world, x, y, z, 8, 0);
                    world.setBlockToAir(x, y, z);
                }
            } else if (te != null && te instanceof TileBrainbox) {
                telb = (TileBrainbox)te;
                if (world.isAirBlock(x + ((TileBrainbox)telb).facing.offsetX, y + ((TileBrainbox)telb).facing.offsetY, z + ((TileBrainbox)telb).facing.offsetZ)) {
                    this.dropBlockAsItem(world, x, y, z, 12, 0);
                    world.setBlockToAir(x, y, z);
                }
            } else if (te != null && te instanceof TileVisRelay && md == 14) {
                telb = (TileVisRelay)te;
                if (world.isAirBlock(x + ForgeDirection.getOrientation((int)((TileVisRelay)telb).orientation).getOpposite().offsetX, y + ForgeDirection.getOrientation((int)((TileVisRelay)telb).orientation).getOpposite().offsetY, z + ForgeDirection.getOrientation((int)((TileVisRelay)telb).orientation).getOpposite().offsetZ)) {
                    this.dropBlockAsItem(world, x, y, z, 14, 0);
                    world.setBlockToAir(x, y, z);
                }
            } else if (md == 10) {
                if (world.getBlock(x, y + 1, z) != this || world.getBlockMetadata(x, y + 1, z) != 11 || world.getBlock(x, y - 1, z) != this || world.getBlockMetadata(x, y - 1, z) != 0) {
                    InventoryUtils.dropItems(world, x, y, z);
                    world.setBlockToAir(x, y, z);
                    world.setBlock(x, y, z, (Block)this, 9, 3);
                    return;
                }
                tile = world.getTileEntity(x, y, z);
                if (tile != null && tile instanceof TileThaumatorium) {
                    ((TileThaumatorium)tile).getUpgrades();
                }
            } else if (md == 11) {
                if (world.getBlock(x, y - 1, z) != this || world.getBlockMetadata(x, y - 1, z) != 10) {
                    world.setBlockToAir(x, y, z);
                    world.setBlock(x, y, z, (Block)this, 9, 3);
                    return;
                }
                tile = world.getTileEntity(x, y - 1, z);
                if (tile != null && tile instanceof TileThaumatorium) {
                    ((TileThaumatorium)tile).getUpgrades();
                }
            }
            boolean flag = world.isBlockIndirectlyGettingPowered(x, y, z);
            if (flag || nbid.canProvidePower()) {
                this.onPoweredBlockChange(world, x, y, z, flag);
            }
        }
        super.onNeighborBlockChange(world, x, y, z, nbid);
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        InventoryUtils.dropItems(par1World, par2, par3, par4);
        TileEntity te = par1World.getTileEntity(par2, par3, par4);
        if (te != null && te instanceof TileCrucible) {
            ((TileCrucible)te).spillRemnants();
        } else if (te != null && te instanceof TileAlembic && ((TileAlembic)te).aspectFilter != null) {
            par1World.spawnEntityInWorld((Entity)new EntityItem(par1World, (double)((float)par2 + 0.5f), (double)((float)par3 + 0.5f), (double)((float)par4 + 0.5f), new ItemStack(ConfigItems.itemResource, 1, 13)));
        } else if (te != null && te instanceof TileArcaneLamp) {
            ((TileArcaneLamp)te).removeLights();
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileEntity te;
        FluidStack fs;
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 0 && !world.isRemote && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.inventory.getCurrentItem())) != null && fs.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000))) {
            int volume = fs.amount;
            TileEntity te2 = world.getTileEntity(x, y, z);
            if (te2 != null && te2 instanceof TileCrucible) {
                TileCrucible tile = (TileCrucible)te2;
                if (tile.tank.getFluidAmount() < tile.tank.getCapacity()) {
                    FluidContainerRegistry.FluidContainerData[] fcs;
                    tile.fill(ForgeDirection.UNKNOWN, FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.inventory.getCurrentItem()), true);
                    ItemStack emptyContainer = null;
                    for (FluidContainerRegistry.FluidContainerData fcd : fcs = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                        if (!fcd.filledContainer.isItemEqual(player.inventory.getCurrentItem())) continue;
                        emptyContainer = fcd.emptyContainer.copy();
                    }
                    player.inventory.decrStackSize(player.inventory.currentItem, 1);
                    if (emptyContainer != null && !player.inventory.addItemStackToInventory(emptyContainer)) {
                        player.dropPlayerItemWithRandomChoice(emptyContainer, false);
                    }
                    player.inventoryContainer.detectAndSendChanges();
                    te2.markDirty();
                    world.markBlockForUpdate(x, y, z);
                    world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "game.neutral.swim", 0.33f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
                } else {
                    return true;
                }
            }
        }
        if (metadata == 1 && !world.isRemote && !player.isSneaking() && player.getHeldItem() == null && (te = world.getTileEntity(x, y, z)) != null && te instanceof TileAlembic) {
            TileAlembic tile = (TileAlembic)te;
            String msg = "";
            if (tile.aspect == null || tile.amount == 0) {
                msg = StatCollector.translateToLocal((String)"tile.alembic.msg.1");
            } else if ((double)tile.amount < (double)tile.maxAmount * 0.4) {
                msg = StatCollector.translateToLocal((String)"tile.alembic.msg.2");
            } else if ((double)tile.amount < (double)tile.maxAmount * 0.8) {
                msg = StatCollector.translateToLocal((String)"tile.alembic.msg.3");
            } else if (tile.amount < tile.maxAmount) {
                msg = StatCollector.translateToLocal((String)"tile.alembic.msg.4");
            } else if (tile.amount == tile.maxAmount) {
                msg = StatCollector.translateToLocal((String)"tile.alembic.msg.5");
            }
            player.addChatMessage((IChatComponent)new ChatComponentTranslation("\u00a73" + msg, new Object[0]));
            world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:alembicknock", 0.2f, 1.0f);
        }
        if (metadata == 1 && (te = world.getTileEntity(x, y, z)) != null && te instanceof TileAlembic) {
            if (player.isSneaking() && ((TileAlembic)te).aspectFilter != null) {
                ((TileAlembic)te).aspectFilter = null;
                world.markBlockForUpdate(x, y, z);
                te.markDirty();
                if (world.isRemote) {
                    world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:page", 1.0f, 1.1f, false);
                } else {
                    ForgeDirection fd = ForgeDirection.getOrientation((int)side);
                    world.spawnEntityInWorld((Entity)new EntityItem(world, (double)((float)x + 0.5f + (float)fd.offsetX / 3.0f), (double)((float)y + 0.5f), (double)((float)z + 0.5f + (float)fd.offsetZ / 3.0f), new ItemStack(ConfigItems.itemResource, 1, 13)));
                }
                return true;
            }
            if (player.isSneaking() && player.getHeldItem() == null) {
                ((TileAlembic)te).amount = 0;
                ((TileAlembic)te).aspect = null;
                if (world.isRemote) {
                    world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:alembicknock", 0.2f, 1.0f, false);
                    world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "game.neutral.swim", 0.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f, false);
                }
            } else {
                if (player.getHeldItem() != null && ((TileAlembic)te).aspectFilter == null && player.getHeldItem().getItem() == ConfigItems.itemResource && player.getHeldItem().getItemDamage() == 13) {
                    if (((TileAlembic)te).amount == 0 && ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()) == null) {
                        return true;
                    }
                    if (((TileAlembic)te).amount == 0 && ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()) != null) {
                        ((TileAlembic)te).aspect = ((IEssentiaContainerItem)player.getHeldItem().getItem()).getAspects(player.getHeldItem()).getAspects()[0];
                    }
                    --player.getHeldItem().stackSize;
                    ((TileAlembic)te).aspectFilter = ((TileAlembic)te).aspect;
                    world.markBlockForUpdate(x, y, z);
                    te.markDirty();
                    if (world.isRemote) {
                        world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "thaumcraft:page", 1.0f, 0.9f, false);
                    }
                    return true;
                }
                if (player.getHeldItem() != null && ((TileAlembic)te).amount > 0 && (player.getHeldItem().getItem() == ConfigItems.itemJarFilled || player.getHeldItem().isItemEqual(new ItemStack(ConfigBlocks.blockJar, 1, 0)) || player.getHeldItem().isItemEqual(new ItemStack(ConfigBlocks.blockJar, 1, 3)))) {
                    boolean doit = false;
                    ItemStack drop = null;
                    if (player.getHeldItem().isItemEqual(new ItemStack(ConfigBlocks.blockJar, 1, 0)) || player.getHeldItem().isItemEqual(new ItemStack(ConfigBlocks.blockJar, 1, 3))) {
                        drop = new ItemStack(ConfigItems.itemJarFilled, 1, player.getHeldItem().getItemDamage());
                        doit = true;
                        ((ItemJarFilled)drop.getItem()).setAspects(drop, new AspectList().add(((TileAlembic)te).aspect, ((TileAlembic)te).amount));
                        ((TileAlembic)te).amount = 0;
                        ((TileAlembic)te).aspect = null;
                        --player.getHeldItem().stackSize;
                        if (!player.inventory.addItemStackToInventory(drop) && !world.isRemote) {
                            world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, drop));
                        }
                    } else {
                        drop = player.getHeldItem();
                        if (!(((ItemJarFilled)drop.getItem()).getAspects(drop) != null && ((ItemJarFilled)drop.getItem()).getAspects(drop).visSize() != 0 && ((ItemJarFilled)drop.getItem()).getAspects(drop).getAmount(((TileAlembic)te).aspect) <= 0 || ((ItemJarFilled)drop.getItem()).getFilter(drop) != null && ((ItemJarFilled)drop.getItem()).getFilter(drop) != ((TileAlembic)te).aspect)) {
                            int amount = Math.min(((ItemJarFilled)drop.getItem()).getAspects(drop) == null ? 64 : 64 - ((ItemJarFilled)drop.getItem()).getAspects(drop).visSize(), ((TileAlembic)te).amount);
                            if (drop.getItemDamage() == 3) {
                                amount = ((TileAlembic)te).amount;
                            }
                            if (amount > 0) {
                                ((TileAlembic)te).amount -= amount;
                                AspectList as = ((ItemJarFilled)drop.getItem()).getAspects(drop);
                                if (as == null) {
                                    as = new AspectList();
                                }
                                as.add(((TileAlembic)te).aspect, amount);
                                if (as.getAmount(((TileAlembic)te).aspect) > 64) {
                                    int q = as.getAmount(((TileAlembic)te).aspect) - 64;
                                    as.reduce(((TileAlembic)te).aspect, q);
                                }
                                ((ItemJarFilled)drop.getItem()).setAspects(drop, as);
                                if (((TileAlembic)te).amount <= 0) {
                                    ((TileAlembic)te).aspect = null;
                                }
                                doit = true;
                                player.setCurrentItemOrArmor(0, drop);
                            }
                        }
                    }
                    if (doit) {
                        te.markDirty();
                        world.markBlockForUpdate(x, y, z);
                        if (world.isRemote) {
                            world.playSound((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "game.neutral.swim", 0.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f, false);
                        }
                    }
                    return true;
                }
            }
        }
        if (metadata == 5) {
            world.setBlockMetadataWithNotify(x, y, z, 6, 2);
            world.playAuxSFXAtEntity(player, 1003, x, y, z, 0);
            return true;
        }
        if (metadata == 6) {
            world.setBlockMetadataWithNotify(x, y, z, 5, 2);
            world.playAuxSFXAtEntity(player, 1003, x, y, z, 0);
            return true;
        }
        if (world.isRemote) {
            return true;
        }
        if (metadata == 10 && (te = world.getTileEntity(x, y, z)) instanceof TileThaumatorium && !player.isSneaking()) {
            player.openGui((Object)Thaumcraft.instance, 3, world, x, y, z);
            return true;
        }
        if (metadata == 11 && (te = world.getTileEntity(x, y - 1, z)) instanceof TileThaumatorium && !player.isSneaking()) {
            player.openGui((Object)Thaumcraft.instance, 3, world, x, y - 1, z);
            return true;
        }
        if ((metadata == 14 || metadata == 2) && !world.isRemote && !player.isSneaking() && player.getHeldItem() != null && player.getHeldItem().getItem() instanceof ItemShard && (te = world.getTileEntity(x, y, z)) != null && te instanceof TileVisRelay) {
            TileVisRelay tile = (TileVisRelay)te;
            byte c = (byte)player.getHeldItem().getItemDamage();
            tile.color = c == tile.color || c == 6 ? (byte)-1 : c;
            tile.removeThisNode();
            tile.nodeRefresh = true;
            tile.markDirty();
            world.markBlockForUpdate(x, y, z);
            world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:crystal", 0.2f, 1.0f);
        }
        return super.onBlockActivated(world, x, y, z, player, side, par7, par8, par9);
    }

    public void onPoweredBlockChange(World par1World, int par2, int par3, int par4, boolean flag) {
        int l = par1World.getBlockMetadata(par2, par3, par4);
        if (l == 5 && flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 6, 2);
            par1World.playAuxSFXAtEntity((EntityPlayer)null, 1003, par2, par3, par4, 0);
        } else if (l == 6 && !flag) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
            par1World.playAuxSFXAtEntity((EntityPlayer)null, 1003, par2, par3, par4, 0);
        }
    }

    public void onBlockPlacedBy(World world, int par2, int par3, int par4, EntityLivingBase ent, ItemStack stack) {
        TileEntity tile;
        int l = MathHelper.floor_double((double)((double)(ent.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (stack.getItemDamage() == 1 && (tile = world.getTileEntity(par2, par3, par4)) instanceof TileAlembic) {
            if (l == 0) {
                ((TileAlembic)tile).facing = 2;
            }
            if (l == 1) {
                ((TileAlembic)tile).facing = 5;
            }
            if (l == 2) {
                ((TileAlembic)tile).facing = 3;
            }
            if (l == 3) {
                ((TileAlembic)tile).facing = 4;
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        int md = world.getBlockMetadata(x, y, z);
        if (md == 3) {
            return 11;
        }
        if (md == 7) {
            return 15;
        }
        if (md == 8) {
            TileEntity te2 = world.getTileEntity(x, y, z);
            if (te2 != null && te2 instanceof TileArcaneLampGrowth) {
                if (((TileArcaneLampGrowth)te2).charges > 0) {
                    return 15;
                }
                return 8;
            }
        } else if (md == 13) {
            TileEntity te3 = world.getTileEntity(x, y, z);
            if (te3 != null && te3 instanceof TileArcaneLampFertility) {
                if (((TileArcaneLampFertility)te3).charges > 0) {
                    return 15;
                }
                return 8;
            }
        } else if (md == 14 && (te = world.getTileEntity(x, y, z)) != null && te instanceof TileVisRelay) {
            if (VisNetHandler.isNodeValid(((TileVisRelay)te).getParent())) {
                return 10;
            }
            return 2;
        }
        return super.getLightValue(world, x, y, z);
    }
}

