/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileEssentiaReservoir;

public class BlockEssentiaReservoir
extends BlockContainer {
    public IIcon icon = null;

    public BlockEssentiaReservoir() {
        super(Material.iron);
        this.setHardness(2.0f);
        this.setResistance(17.0f);
        this.setStepSound(Block.soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:essentiareservoir");
    }

    public IIcon getIcon(int i, int md) {
        return this.icon;
    }

    public IIcon getIcon(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        return this.icon;
    }

    public int getRenderType() {
        return ConfigBlocks.blockEssentiaReservoirRI;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TileEssentiaReservoir();
        }
        return super.createTileEntity(world, metadata);
    }

    public TileEntity createNewTileEntity(World var1, int md) {
        return null;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int rs) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEssentiaReservoir) {
            float r = (float)((TileEssentiaReservoir)te).essentia.visSize() / (float)((TileEssentiaReservoir)te).maxAmount;
            return MathHelper.floor_float((float)(r * 14.0f)) + (((TileEssentiaReservoir)te).essentia.visSize() > 0 ? 1 : 0);
        }
        return 0;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileEssentiaReservoir) {
            int sz = ((TileEssentiaReservoir)te).essentia.visSize() / 16;
            int q = 0;
            if (sz > 0) {
                world.createExplosion(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, false);
                for (int a = 0; a < 50; ++a) {
                    int zz;
                    int yy;
                    int xx = x + world.rand.nextInt(5) - world.rand.nextInt(5);
                    if (!world.isAirBlock(xx, yy = y + world.rand.nextInt(5) - world.rand.nextInt(5), zz = z + world.rand.nextInt(5) - world.rand.nextInt(5))) continue;
                    if (yy < y) {
                        world.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGoo, 8, 3);
                    } else {
                        world.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGas, 8, 3);
                    }
                    if (q++ >= sz) break;
                }
            }
        }
        super.breakBlock(world, x, y, z, par5, par6);
    }
}

