/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileChestHungry;

public class BlockChestHungry
extends BlockContainer {
    private Random random = new Random();
    public IIcon icon;

    public BlockChestHungry() {
        super(Material.wood);
        this.setHardness(2.5f);
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:woodplain");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icon;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return ConfigBlocks.blockChestHungryRI;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int rs) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof IInventory) {
            return Container.calcRedstoneFromInventory((IInventory)((IInventory)te));
        }
        return 0;
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack is) {
        int var6 = par1World.getBlockMetadata(par2, par3, par4) & 3;
        int var7 = BlockPistonBase.determineOrientation((World)par1World, (int)par2, (int)par3, (int)par4, (EntityLivingBase)((EntityPlayer)par5EntityLiving));
        par1World.setBlock(par2, par3, par4, (Block)this, var7, 3);
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileChestHungry var7 = (TileChestHungry)par1World.getTileEntity(par2, par3, par4);
        if (var7 != null) {
            for (int var8 = 0; var8 < var7.getSizeInventory(); ++var8) {
                ItemStack var9 = var7.getStackInSlot(var8);
                if (var9 == null) continue;
                float var10 = this.random.nextFloat() * 0.8f + 0.1f;
                float var11 = this.random.nextFloat() * 0.8f + 0.1f;
                float var12 = this.random.nextFloat() * 0.8f + 0.1f;
                while (var9.stackSize > 0) {
                    int var13 = this.random.nextInt(21) + 10;
                    if (var13 > var9.stackSize) {
                        var13 = var9.stackSize;
                    }
                    var9.stackSize -= var13;
                    EntityItem var14 = new EntityItem(par1World, (double)((float)par2 + var10), (double)((float)par3 + var11), (double)((float)par4 + var12), new ItemStack(var9.getItem(), var13, var9.getItemDamage()));
                    float var15 = 0.05f;
                    var14.motionX = (float)this.random.nextGaussian() * var15;
                    var14.motionY = (float)this.random.nextGaussian() * var15 + 0.2f;
                    var14.motionZ = (float)this.random.nextGaussian() * var15;
                    if (var9.hasTagCompound()) {
                        var14.getEntityItem().setTagCompound((NBTTagCompound)var9.getTagCompound().copy());
                    }
                    par1World.spawnEntityInWorld((Entity)var14);
                }
            }
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        float var5 = 0.0625f;
        return AxisAlignedBB.getBoundingBox((double)((float)par2 + var5), (double)par3, (double)((float)par4 + var5), (double)((float)(par2 + 1) - var5), (double)((float)(par3 + 1) - var5), (double)((float)(par4 + 1) - var5));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        TileChestHungry var10 = (TileChestHungry)world.getTileEntity(x, y, z);
        if (var10 == null) {
            return;
        }
        if (world.isRemote) {
            return;
        }
        if (entity instanceof EntityItem && !entity.isDead) {
            ItemStack leftovers = InventoryUtils.placeItemStackIntoInventory(((EntityItem)entity).getEntityItem(), var10, 1, true);
            if (leftovers == null || leftovers.stackSize != ((EntityItem)entity).getEntityItem().stackSize) {
                world.playSoundAtEntity(entity, "random.eat", 0.25f, (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f + 1.0f);
                world.addBlockEvent(x, y, z, ConfigBlocks.blockChestHungry, 2, 2);
            }
            if (leftovers != null) {
                ((EntityItem)entity).setEntityItemStack(leftovers);
            } else {
                entity.setDead();
            }
            var10.markDirty();
        }
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileChestHungry var10 = (TileChestHungry)par1World.getTileEntity(par2, par3, par4);
        if (var10 == null) {
            return true;
        }
        if (par1World.isRemote) {
            return true;
        }
        par5EntityPlayer.displayGUIChest((IInventory)var10);
        return true;
    }

    public TileEntity createNewTileEntity(World par1World, int m) {
        return new TileChestHungry();
    }
}

