/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.models.ModelTubeValve;
import thaumcraft.common.blocks.BlockTube;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileTubeValve;

public class TileTubeValveRenderer
extends TileEntitySpecialRenderer {
    private ModelTubeValve model = new ModelTubeValve();

    public void renderEntityAt(TileTubeValve valve, double x, double y, double z, float fq) {
        UtilsFX.bindTexture("textures/models/valve.png");
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (valve.facing.offsetY == 0) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)valve.facing.offsetY, (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)90.0f, (float)valve.facing.offsetX, (float)valve.facing.offsetY, (float)valve.facing.offsetZ);
        GL11.glRotated((double)((double)(-valve.rotation) * 1.5), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)(-(valve.rotation / 360.0f) * 0.12f), (double)0.0);
        GL11.glPushMatrix();
        this.model.render();
        GL11.glPopMatrix();
        this.renderValve();
        GL11.glPopMatrix();
    }

    void renderValve() {
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.25f, (float)-0.25f, (float)-0.25f);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        Tessellator tessellator = Tessellator.instance;
        IIcon icon = ((BlockTube)ConfigBlocks.blockTube).iconValve;
        float f1 = icon.getMaxU();
        float f2 = icon.getMinV();
        float f3 = icon.getMinU();
        float f4 = icon.getMaxV();
        this.field_147501_a.field_147553_e.bindTexture(TextureMap.locationBlocksTexture);
        ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f1, (float)f2, (float)f3, (float)f4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.1f);
        GL11.glPopMatrix();
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.renderEntityAt((TileTubeValve)tileentity, d, d1, d2, f);
    }
}

