/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.tiles.TileNodeStabilizer;

@SideOnly(value=Side.CLIENT)
public class TileNodeStabilizerRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)MODEL);
    private static final ResourceLocation MODEL = new ResourceLocation("thaumcraft", "textures/models/node_stabilizer.obj");

    public void renderTileEntityAt(TileNodeStabilizer tile, double par2, double par4, double par6, float par8) {
        int lock = 1;
        int bright = 20;
        if (tile.getWorldObj() != null) {
            if (tile.getWorldObj().getBlockMetadata(tile.xCoord, tile.yCoord, tile.zCoord) == 10) {
                lock = 2;
            }
            bright = tile.getBlockType().getMixedBrightnessForBlock((IBlockAccess)tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord);
        } else {
            lock = tile.lock;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4), (float)((float)par6 + 0.5f));
        GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.bindTexture("textures/models/node_stabilizer.png");
        this.model.renderPart("lock");
        for (int a = 0; a < 4; ++a) {
            GL11.glPushMatrix();
            if (tile.getWorldObj() != null) {
                int j = bright;
                int k = j % 65536;
                int l = j / 65536;
                OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            }
            GL11.glRotatef((float)(90 * a), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)tile.count / 100.0f));
            UtilsFX.bindTexture("textures/models/node_stabilizer.png");
            this.model.renderPart("piston");
            if (lock == 2) {
                GL11.glColor4f((float)1.0f, (float)0.2f, (float)0.2f, (float)1.0f);
            }
            if (tile.getWorldObj() != null) {
                float scale = MathHelper.sin((float)((float)(Minecraft.getMinecraft().renderViewEntity.ticksExisted + a * 5) / 3.0f)) * 0.1f + 0.9f;
                int j = 50 + (int)(170.0f * ((float)tile.count / 37.0f * scale));
                int k = j % 65536;
                int l = j / 65536;
                OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)k / 1.0f), (float)((float)l / 1.0f));
            }
            UtilsFX.bindTexture("textures/models/node_stabilizer_over.png");
            this.model.renderPart("piston");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (tile.count > 0) {
            GL11.glPushMatrix();
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDepthMask((boolean)false);
            float alpha = MathHelper.sin((float)((float)Minecraft.getMinecraft().renderViewEntity.ticksExisted / 8.0f)) * 0.1f + 0.5f;
            UtilsFX.bindTexture("textures/misc/node_bubble.png");
            UtilsFX.renderFacingQuad((double)tile.xCoord + 0.5, (double)tile.yCoord + 1.5, (double)tile.zCoord + 0.5, 0.0f, 0.9f, (float)tile.count / 37.0f * alpha, 1, 0, par8, lock == 1 ? 0xFFFFFF : 0xFF4444);
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
    }

    public void renderTileEntityAt(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderTileEntityAt((TileNodeStabilizer)par1TileEntity, par2, par4, par6, par8);
    }
}

