/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileAlchemyFurnaceAdvanced;

@SideOnly(value=Side.CLIENT)
public class TileAlchemyFurnaceAdvancedRenderer
extends TileEntitySpecialRenderer {
    private IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)FURNACE);
    private static final ResourceLocation FURNACE = new ResourceLocation("thaumcraft", "textures/models/adv_alch_furnace.obj");

    public void renderTileEntityAt(TileAlchemyFurnaceAdvanced tile, double par2, double par4, double par6, float par8) {
        int a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4), (float)((float)par6 + 0.5f));
        GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (tile.heat <= 100) {
            UtilsFX.bindTexture("textures/models/alch_furnace.png");
        } else {
            UtilsFX.bindTexture("textures/models/alch_furnace_on.png");
        }
        this.model.renderPart("Base");
        if (tile.vis <= 0) {
            UtilsFX.bindTexture("textures/models/alch_furnace_tank.png");
        } else {
            UtilsFX.bindTexture("textures/models/alch_furnace_tank_on.png");
        }
        for (a = 0; a < 4; ++a) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(90 * a), (float)0.0f, (float)0.0f, (float)1.0f);
            this.model.renderPart("Tank");
            GL11.glPopMatrix();
        }
        if (tile.vis > 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)-0.5f, (float)1.1f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderQuadCenteredFromIcon(ConfigBlocks.FLUXGOO.getIcon(), 190, 0.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            float f = 1.0f - (float)tile.vis / (float)tile.maxVis;
            for (int a2 = 0; a2 < 4; ++a2) {
                GL11.glPushMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(90 * a2), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.85f, (float)-1.8f, (float)-1.4f);
                GL11.glScaled((double)0.3, (double)0.6, (double)1.0);
                this.renderQuadCenteredFromIcon(tile.getBlockType().getIcon(0, 0), 150, 0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
                this.renderQuadCenteredFromIcon(ConfigBlocks.FLUXGOO.getIcon(), 190, f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(90 * a2), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)1.15f, (float)1.8f, (float)-1.4f);
                GL11.glScaled((double)-0.3, (double)-0.6, (double)-1.0);
                this.renderQuadCenteredFromIcon(tile.getBlockType().getIcon(0, 0), 150, 0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
                this.renderQuadCenteredFromIcon(ConfigBlocks.FLUXGOO.getIcon(), 190, f);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        if (tile.heat > 100) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
            for (a = 0; a < 4; ++a) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)(90 * a), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-1.0f);
                GL11.glPushMatrix();
                this.renderQuadCenteredFromIcon(Blocks.fire.getIcon(0, 0), 220, 1.0f - Math.min(1.0f, (float)tile.heat / (float)tile.maxPower));
                GL11.glPopMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.05f);
                this.renderQuadCenteredFromIcon(tile.getBlockType().getIcon(0, 0), 150, 0.0f);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void renderQuadCenteredFromIcon(IIcon icon, int brightness, float width) {
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        RenderHelper.disableStandardItemLighting();
        Tessellator tessellator = Tessellator.instance;
        float f1 = icon.getMaxU();
        float f2 = icon.getMinV();
        float f3 = icon.getMinU();
        float f4 = icon.getMaxV();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.startDrawingQuads();
        tessellator.setBrightness(brightness);
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, (double)f1, (double)f4);
        tessellator.addVertexWithUV(1.0, 1.0, 0.0, (double)f3, (double)f4);
        tessellator.addVertexWithUV(1.0, (double)width, 0.0, (double)f3, (double)f2);
        tessellator.addVertexWithUV(0.0, (double)width, 0.0, (double)f1, (double)f2);
        tessellator.draw();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        RenderHelper.enableStandardItemLighting();
    }

    public void renderTileEntityAt(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderTileEntityAt((TileAlchemyFurnaceAdvanced)par1TileEntity, par2, par4, par6, par8);
    }
}

